/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.common.attributehandling;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.cat.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.commonmo.transactions.transactionlistener.TransactionTypeList;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;

public class AttributeUtilities {
    private static final String CREATED_BY = "createdBy";
    private static final String TIME_OF_CREATION = "timeOfCreation";
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String ANR_CREATED = "anrCreated";
    private static final String TIME_OF_ANR_CREATION = "timeOfAnrCreation";
    private static final String CTRL_MODE = "ctrlMode";
    private static final Class THIS_CLASS = AttributeUtilities.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static AttributeUtilities theOne;
    private static final Object lock;
    private static final String LAST_MODIFICATION = "lastModification";
    private static final String TIME_OF_LAST_MODIFICATION = "timeOfLastModification";

    private AttributeUtilities() {
    }

    public static void validateAttributeShouldBeSame(MoIterator moterator, ManagedObject mo, String attributeName, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        AttributeUtilities.validateAttribute(moterator, mo, new String[]{attributeName}, true, coordinator);
    }

    public static void validateSeveralAttributeCombinationShouldBeUnique(MoIterator moIterator, ManagedObject mo, String[] attributeNames, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        AttributeUtilities.validateAttribute(moIterator, mo, attributeNames, false, coordinator);
    }

    public static void validateAttributeShouldBeUnique(MoIterator moIterator, ManagedObject mo, String attributeName, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        AttributeUtilities.validateAttribute(moIterator, mo, new String[]{attributeName}, false, coordinator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateAttribute(MoIterator moIterator, ManagedObject mo, String[] attributeNames, boolean shouldBeSame, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        if (moIterator != null) {
            logger.traceEnter(THIS_CLASS, "validateAttribute(moIterator.size = " + moIterator.size() + ", " + "mo = " + mo.getLocalDistinguishedName() + ", attributeNames.length " + attributeNames.length + ", shouldBeSame = " + shouldBeSame + ")");
            Object object = lock;
            synchronized (object) {
                String calledFrom = shouldBeSame ? "validateAttributeShouldBeSame" : "validateAttributeShouldBeUnique";
                logger.traceEnter(THIS_CLASS, "validateAttribute(siblings, moLdn=" + mo.getLocalDistinguishedName() + "), called from: " + calledFrom);
                while (moIterator != null && moIterator.hasMoreElements()) {
                    ManagedObject sibling = (ManagedObject)moIterator.nextElement();
                    String siblingLdn = sibling.getLocalDistinguishedName();
                    if (siblingLdn.equals(mo.getLocalDistinguishedName())) continue;
                    AttributeUtilities.validateSiblingParameters(attributeNames, mo, sibling, shouldBeSame, coordinator);
                }
                logger.traceReturn(THIS_CLASS, "validateAttribute()");
            }
        }
    }

    private static void validateSiblingParameters(String[] attributeNames, ManagedObject mo, ManagedObject sibling, boolean shouldBeSame, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateSiblingParameters()");
        if (attributeNames.length == 1) {
            AttributeUtilities.validateOutcomeOfSingleParam(attributeNames, shouldBeSame, mo, sibling, coordinator);
        } else {
            AttributeUtilities.validatedOutcomeOfSeveralParameters(attributeNames, shouldBeSame, mo, sibling, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "validateSiblingParameters()");
    }

    private static boolean validateOutcomeOfSingleParam(String[] attributeNames, boolean shouldBeSame, ManagedObject mo, ManagedObject sibling, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateOutcomeOfSingleParam()");
        String attributeName = attributeNames[0];
        Object referenceValue = mo.getAttribute(attributeName, coordinator);
        Object siblingValue = sibling.getAttribute(attributeName, coordinator);
        boolean compareIsOk = AttributeUtilities.compareValue(shouldBeSame, referenceValue, siblingValue);
        if (!compareIsOk) {
            if (shouldBeSame) {
                String message = "The values for attribute [" + attributeName + "] must be the same for all MOs of the type [" + mo.getType() + "]. The value [" + AttributeUtilities.valueToString(referenceValue) + "] for MO [" + mo.getLocalDistinguishedName() + "] does not match the value [" + AttributeUtilities.valueToString(siblingValue) + "] for MO [" + sibling.getLocalDistinguishedName() + "]";
                AttributeUtilities.logInfoAndThrowException(message);
            } else {
                String message = "The values for attribute [" + attributeName + "] must be unique among all MOs of the type [" + mo.getType() + "]. The value [" + AttributeUtilities.valueToString(referenceValue) + "] for MO [" + mo.getLocalDistinguishedName() + "] is the same as for MO [" + sibling.getLocalDistinguishedName() + "]";
                AttributeUtilities.logInfoAndThrowException(message);
            }
        }
        logger.traceReturn(THIS_CLASS, "validateOutcomeOfSingleParam(return " + compareIsOk + ")");
        return compareIsOk;
    }

    protected static boolean compareValue(boolean shouldBeSame, Object referenceValue, Object siblingValue) {
        logger.traceEnter(THIS_CLASS, "compareValue(shouldBeSame[" + shouldBeSame + "], referenceValue[" + referenceValue + "], siblingValue[" + siblingValue + "])");
        boolean okCombination = true;
        okCombination = referenceValue instanceof Object[] && siblingValue instanceof Object[] ? AttributeUtilities.compareStructValues(shouldBeSame, referenceValue, siblingValue) : (referenceValue instanceof Struct && siblingValue instanceof Struct ? AttributeUtilities.compareStructs(shouldBeSame, referenceValue, siblingValue) : AttributeUtilities.compareNonStruct(shouldBeSame, referenceValue, siblingValue));
        logger.traceReturn(THIS_CLASS, "compareValue(Result[" + okCombination + "])");
        return okCombination;
    }

    private static boolean compareStructValues(boolean shouldBeSame, Object referenceValue, Object siblingValue) {
        boolean sameSize;
        Object[] refArray = (Object[])referenceValue;
        Object[] sibArray = (Object[])siblingValue;
        boolean okCombination = true;
        boolean bl = sameSize = refArray.length == sibArray.length;
        if (sameSize) {
            for (int i = 0; i < refArray.length; ++i) {
                if (AttributeUtilities.compareValue(shouldBeSame, refArray[i], sibArray[i])) continue;
                okCombination = false;
                break;
            }
        } else if (shouldBeSame) {
            okCombination = false;
        }
        return okCombination;
    }

    private static boolean compareStructs(boolean shouldBeSame, Object referenceValue, Object siblingValue) {
        logger.traceEnter(THIS_CLASS, "compareStructs()");
        boolean structsAreOk = true;
        boolean structsAreEqual = StructImpl.compareStructs((Struct)((Struct)referenceValue), (Struct)((Struct)siblingValue));
        if (shouldBeSame && !structsAreEqual || !shouldBeSame && structsAreEqual) {
            structsAreOk = false;
        }
        logger.traceReturn(THIS_CLASS, "compareStructs()");
        return structsAreOk;
    }

    private static boolean compareNonStruct(boolean shouldBeSame, Object referenceValue, Object siblingValue) {
        logger.traceEnter(THIS_CLASS, "compareNonStruct()");
        boolean valuesAreOk = true;
        if (shouldBeSame) {
            if (siblingValue == null || !referenceValue.equals(siblingValue)) {
                valuesAreOk = false;
            }
        } else if (siblingValue == null || referenceValue.equals(siblingValue)) {
            valuesAreOk = false;
        }
        logger.traceReturn(THIS_CLASS, "compareNonStruct()");
        return valuesAreOk;
    }

    private static void validatedOutcomeOfSeveralParameters(String[] attributeNames, boolean shouldBeSame, ManagedObject mo, ManagedObject sibling, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        String message;
        logger.traceEnter(THIS_CLASS, "validatedOutcomeOfSeveralParameters()");
        int numberOfBadCombinations = 0;
        StringBuffer moAttributes = new StringBuffer();
        StringBuffer siblingAttributes = new StringBuffer();
        for (int i = 0; i < attributeNames.length; ++i) {
            Object siblingValue;
            Object referenceValue = mo.getAttribute(attributeNames[i], coordinator);
            if (!AttributeUtilities.compareValue(shouldBeSame, referenceValue, siblingValue = sibling.getAttribute(attributeNames[i], coordinator))) {
                ++numberOfBadCombinations;
            }
            moAttributes.append("[" + attributeNames[i] + " = " + AttributeUtilities.valueToString(referenceValue) + "] ");
            siblingAttributes.append("[" + attributeNames[i] + " = " + AttributeUtilities.valueToString(siblingValue) + "] ");
        }
        boolean outCome = true;
        if (shouldBeSame) {
            if (numberOfBadCombinations > 0) {
                message = "The combination of attributes [" + moAttributes + "] for MO [" + mo.getLocalDistinguishedName() + "] should be the same as for the other MOs of same type. Values [" + siblingAttributes + "]";
                AttributeUtilities.logInfoAndThrowException(message);
            }
        } else if (numberOfBadCombinations == attributeNames.length) {
            message = "The combination of attributes [" + moAttributes + "] for MO [" + mo.getLocalDistinguishedName() + "] is not unique, they are already used by another MO [" + sibling.getLocalDistinguishedName() + "]";
            AttributeUtilities.logInfoAndThrowException(message);
        }
        logger.traceReturn(THIS_CLASS, "validatedOutcomeOfSeveralParameters(return true)");
    }

    public static Pair isAttributeSameAsSiblings(MoIterator cellIterator, String ldn, Object referenceValue, String attributeName, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "isAttributeSameAsSiblings()");
        Pair returnValue = AttributeUtilities.validateAttribute(false, cellIterator, ldn, referenceValue, attributeName, coordinator);
        logger.traceReturn(THIS_CLASS, "isAttributeSameAsSiblings()");
        return returnValue;
    }

    public static Pair isAttributUnique(MoIterator cellIterator, String ldn, Object referenceValue, String attributeName, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "isAttributUnique()");
        Pair returnValue = AttributeUtilities.validateAttribute(true, cellIterator, ldn, referenceValue, attributeName, coordinator);
        logger.traceReturn(THIS_CLASS, "isAttributUnique()");
        return returnValue;
    }

    private static Pair validateAttribute(boolean shouldBeUnique, MoIterator cellIterator, String ldn, Object referenceValue, String attributeName, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        Object cellValue;
        ManagedObject cell;
        String cellLdn;
        logger.traceEnter(THIS_CLASS, "validateAttribute(shouldBeUnique=" + shouldBeUnique + ")");
        Pair returnValue = null;
        while (cellIterator != null && cellIterator.hasMoreElements() && ((cellLdn = (cell = (ManagedObject)cellIterator.nextElement()).getLocalDistinguishedName()).equals(ldn) || (returnValue = AttributeUtilities.compareShouldBeUnique(shouldBeUnique, referenceValue, cellValue = cell.getAttribute(attributeName, coordinator), cellLdn)) == null)) {
        }
        logger.traceReturn(THIS_CLASS, "validateAttribute()");
        return returnValue;
    }

    private static Pair compareShouldBeUnique(boolean shouldBeUnique, Object referenceValue, Object cellValue, String cellLdn) {
        logger.traceEnter(THIS_CLASS, "compareShouldBeUnique()");
        Pair returnValue = null;
        if (shouldBeUnique) {
            boolean compare = false;
            compare = referenceValue instanceof Struct ? StructImpl.compareStructs((Struct)((Struct)referenceValue), (Struct)((Struct)cellValue)) : referenceValue.equals(cellValue);
            if (compare) {
                returnValue = AttributeUtilities.getPair(cellLdn, cellValue);
            }
        } else {
            boolean compare = true;
            compare = referenceValue instanceof Struct ? StructImpl.compareStructs((Struct)((Struct)referenceValue), (Struct)((Struct)cellValue)) : referenceValue.equals(cellValue);
            if (!compare) {
                returnValue = AttributeUtilities.getPair(cellLdn, cellValue);
            }
        }
        logger.traceReturn(THIS_CLASS, "compareShouldBeUnique():");
        return returnValue;
    }

    public static Pair validateAttributeUniqueCombination(String moLdn, MoIterator cellIterator, String[] attributeNames, Object[] attributeValues, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateAttributeUniqueCombination()");
        if (attributeNames.length != attributeValues.length) {
            logger.traceError(THIS_CLASS, "Invalid Parameter: attributeNames and attributeValues must have identical size.");
            logger.traceReturn(THIS_CLASS, "validateAttributeUniqueCombination()");
            return null;
        }
        Pair pair = null;
        while (cellIterator.hasMoreElements()) {
            int numberOfMatches;
            ManagedObject sibling = (ManagedObject)cellIterator.nextElement();
            if (moLdn.equals(sibling.getLocalDistinguishedName()) || (numberOfMatches = AttributeUtilities.getNumberOfMatches(attributeNames, sibling, attributeValues, coordinator)) != attributeNames.length) continue;
            pair = AttributeUtilities.getPair(sibling.getLocalDistinguishedName(), null);
            break;
        }
        logger.traceReturn(THIS_CLASS, "validateAttributeUniqueCombination()");
        return pair;
    }

    private static int getNumberOfMatches(String[] attributeNames, ManagedObject sibling, Object[] attributeValues, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "getNumberOfMatches()");
        int numberOfMatches = 0;
        for (int i = 0; i < attributeNames.length; ++i) {
            Object siblingValue = sibling.getAttribute(attributeNames[i], coordinator);
            if (attributeValues[i] instanceof Struct && siblingValue instanceof Struct) {
                if (!StructImpl.compareStructs((Struct)((Struct)attributeValues[i]), (Struct)((Struct)siblingValue))) continue;
                ++numberOfMatches;
                continue;
            }
            if (!attributeValues[i].equals(siblingValue)) continue;
            ++numberOfMatches;
        }
        logger.traceReturn(THIS_CLASS, "getNumberOfMatches()");
        return numberOfMatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair getPair(String ldn, Object value) {
        logger.traceEnter(THIS_CLASS, "getPair()");
        Object object = lock;
        synchronized (object) {
            if (theOne == null) {
                theOne = new AttributeUtilities();
            }
        }
        logger.traceReturn(THIS_CLASS, "getPair()");
        AttributeUtilities attributeUtilities = theOne;
        attributeUtilities.getClass();
        return attributeUtilities.new Pair(ldn, value);
    }

    public static Object getAnrAttributeValue(AbstractGenericAttributeValidatorMao mo, String attrName, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        Object returnAttributeValue = null;
        if (ANR_CREATED.equals(attrName)) {
            Integer createdBy = (Integer)mo.getAttribute(CREATED_BY, coordinator);
            returnAttributeValue = AttributeUtilities.convertCreatedByToAnrCreated(createdBy);
        } else if (TIME_OF_ANR_CREATION.equals(attrName)) {
            returnAttributeValue = AttributeUtilities.handleTimeOfAnrCreated(mo, coordinator);
        } else if (CTRL_MODE.equals(attrName)) {
            returnAttributeValue = AttributeUtilities.handleCtrlMode(mo, coordinator);
        }
        return returnAttributeValue;
    }

    private static Boolean convertCreatedByToAnrCreated(Integer createdByAnr) {
        logger.traceDebug(THIS_CLASS, "convertCreatedByToAnrCreated() executed");
        return createdByAnr == 0;
    }

    public static void setInitialTimeParameters(GenericMao moToSet, int createdBy, int lastModification, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setInitialTimeParameters()");
        moToSet.setReadOnlyAttribute(TIME_OF_CREATION, (Object)DateTimeHelper.dateToString((long)System.currentTimeMillis(), (String)YYYY_MM_DD_HH_MM_SS), coordinator);
        moToSet.setReadOnlyAttribute(CREATED_BY, (Object)new Integer(createdBy), coordinator);
        if (lastModification >= 0) {
            moToSet.setReadOnlyAttribute(LAST_MODIFICATION, (Object)new Integer(lastModification), coordinator);
            moToSet.setReadOnlyAttribute(TIME_OF_LAST_MODIFICATION, (Object)"", coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setInitialTimeParameters()");
    }

    public static void setModificationAttribute(String attributeName, GenericMao moToSet, int operator_id, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setModificationAttribute()");
        boolean otherAttribute = false;
        if (!(attributeName.equals(TIME_OF_LAST_MODIFICATION) || attributeName.equals(LAST_MODIFICATION) || attributeName.equals(TIME_OF_CREATION) || attributeName.equals(CREATED_BY))) {
            otherAttribute = true;
        }
        if (otherAttribute) {
            moToSet.setReadOnlyAttribute(TIME_OF_LAST_MODIFICATION, (Object)DateTimeHelper.dateToString((long)System.currentTimeMillis(), (String)YYYY_MM_DD_HH_MM_SS), coordinator);
            if (!TransactionTypeList.getInstance().isNonBlocking(coordinator)) {
                Integer operator_modification = new Integer(operator_id);
                moToSet.setReadOnlyAttribute(LAST_MODIFICATION, (Object)operator_modification, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "setModificationAttribute()");
    }

    public static void setModificationAttrAtDelete(GenericMao moToSet, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setModificationAttrAtDelete()");
        if (!TransactionTypeList.getInstance().isNonBlocking(coordinator)) {
            Integer operator_delete = new Integer(5);
            moToSet.setReadOnlyAttribute(LAST_MODIFICATION, (Object)operator_delete, coordinator);
        }
        moToSet.setReadOnlyAttribute(TIME_OF_LAST_MODIFICATION, (Object)DateTimeHelper.dateToString((long)System.currentTimeMillis(), (String)YYYY_MM_DD_HH_MM_SS), coordinator);
        logger.traceReturn(THIS_CLASS, "setModificationAttrAtDelete()");
    }

    public static String valueToString(Object value) throws NotHandledAttributeTypeException, MoNotFoundException, NoSuchFieldException {
        String returnValue = "";
        if (value instanceof Object[]) {
            Object[] valueArray = (Object[])value;
            for (int i = 0; i < valueArray.length; ++i) {
                returnValue = returnValue + AttributeUtilities.valueToString(valueArray[i]);
                returnValue = returnValue + " ";
            }
        } else if (value instanceof Struct) {
            Struct struct = (Struct)value;
            String[] names = struct.getNames();
            String s = "[";
            for (int i = 0; i < names.length; ++i) {
                if (i > 0) {
                    s = s + ":";
                }
                s = s + names[i] + "=" + struct.getValue(names[i]);
            }
            returnValue = s = s + "]";
        } else {
            returnValue = value.toString();
        }
        return returnValue;
    }

    private static String handleTimeOfAnrCreated(GenericMao moToSet, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        logger.traceEnter(THIS_CLASS, "handleTimeOfAnrCreated()");
        String result = "";
        Integer createdByValue = (Integer)moToSet.getAttribute(CREATED_BY, coordinator);
        if (AttributeUtilities.convertCreatedByToAnrCreated(createdByValue).booleanValue()) {
            result = (String)moToSet.getAttribute(TIME_OF_CREATION, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "handleTimeOfAnrCreated()");
        return result;
    }

    private static Integer handleCtrlMode(GenericMao moToSet, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        Integer ctrlModeAuto;
        Integer ctrlModeManual;
        logger.traceEnter(THIS_CLASS, "handleCtrlMode()");
        Integer createdByValue = (Integer)moToSet.getAttribute(CREATED_BY, coordinator);
        Integer createByOperator = new Integer(2);
        Integer returnAttributeValue = createByOperator.equals(createdByValue) ? (ctrlModeManual = new Integer(0)) : (ctrlModeAuto = new Integer(1));
        logger.traceReturn(THIS_CLASS, "handleCtrlMode()");
        return returnAttributeValue;
    }

    private static void logInfoAndThrowException(String message) throws PrepareFailedException {
        logger.info(THIS_CLASS, message);
        throw new PrepareFailedException(message);
    }

    static {
        lock = new Object();
    }

    public class Pair {
        public final String ldn;
        public final Object value;

        public Pair(String inLdn, Object inValue) {
            this.ldn = inLdn;
            this.value = inValue;
        }
    }
}

