/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.common.attributehandling;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.attributehandling.AttrCoordinatorImpl;
import se.ericsson.crbs.cat.common.attributehandling.AttributeValueHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class AttributeValueHandlerFactory {
    private static final Class THIS_CLASS = AttributeValueHandlerFactory.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static Map txidToAttributeValueHandlerMap = new HashMap();
    private static Object lock = new Object();
    private static AttributeValueHandlerFactory theOne = null;

    private AttributeValueHandlerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttributeValueHandlerFactory getInstance() {
        Object object = lock;
        synchronized (object) {
            if (theOne == null) {
                theOne = new AttributeValueHandlerFactory();
            }
            return theOne;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttributeValueHandler getAttributeValueHandler(Coordinator coordinator) {
        Object object = lock;
        synchronized (object) {
            AttributeValueHandler valueHandler;
            logger.traceEnter(THIS_CLASS, "getAttributeValueHandler(txid = " + coordinator.getTransactionID() + ")");
            Integer txidIndex = new Integer(coordinator.getTransactionID());
            boolean valueHandlerExist = txidToAttributeValueHandlerMap.containsKey(txidIndex);
            if (valueHandlerExist) {
                valueHandler = (AttributeValueHandler)txidToAttributeValueHandlerMap.get(txidIndex);
            } else {
                valueHandler = new AttributeValueHandler(coordinator);
                txidToAttributeValueHandlerMap.put(txidIndex, valueHandler);
            }
            logger.traceDebug(THIS_CLASS, "ValueHandler exist [" + valueHandlerExist + "]. " + "Number of ValueHandlers in system [" + txidToAttributeValueHandlerMap.size() + "]");
            logger.traceReturn(THIS_CLASS, "getAttributeValueHandler()");
            return valueHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleRollBack(Coordinator coordinator) {
        Object object = lock;
        synchronized (object) {
            logger.traceEnter(THIS_CLASS, "handleRollBack(txid = " + coordinator.getTransactionID() + ")");
            Integer txidIndex = new Integer(coordinator.getTransactionID());
            txidToAttributeValueHandlerMap.remove(txidIndex);
            logger.traceDebug(THIS_CLASS, "Remove ValueHandler for transaction [" + coordinator.getTransactionID() + "]. " + "Number of ValueHandlers in system [" + txidToAttributeValueHandlerMap.size() + "]");
            logger.traceReturn(THIS_CLASS, "handleRollBack(txid = " + coordinator.getTransactionID() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleCommit(Coordinator coordinator) {
        Object object = lock;
        synchronized (object) {
            logger.traceEnter(THIS_CLASS, "handleCommit(txid = " + coordinator.getTransactionID() + ")");
            AttributeValueHandler commitValueHandler = AttributeValueHandlerFactory.getAttributeValueHandler(new AttrCoordinatorImpl(0));
            AttributeValueHandler currentValueHandler = AttributeValueHandlerFactory.getAttributeValueHandler(coordinator);
            commitValueHandler.copyAttributeValueHandler(currentValueHandler);
            AttributeValueHandlerFactory.handleRollBack(coordinator);
            logger.traceReturn(THIS_CLASS, "handleCommit(txid = " + coordinator.getTransactionID() + ")");
        }
    }

    public static void clearCache() {
        txidToAttributeValueHandlerMap.clear();
    }
}

