/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.cat.common.validator.AbstractAttributeValidator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class ForbiddenCombinationValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = ForbiddenCombinationValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final Object moAttribute;
    private final String moTypeToMatch;
    private final String moTypeToMatchsAttributeName;
    private final GenericMaoContext genericMaoContext;
    private final Object moTypeToMatchsAttributeNameValue;
    private final String moAttributeName;

    public ForbiddenCombinationValidator(Object inputMoAttributeValue, String inputMoAttributeName, String inputMoTypeToMatch, String inputMoTypeToMatchsAttributeName, Object inputMoTypeToMatchsAttributeNameValue, GenericMaoContext inputGenericMaoContext) {
        super(THIS_CLASS.getName(), inputMoAttributeName, false, true, false);
        this.moAttribute = inputMoAttributeValue;
        this.moAttributeName = inputMoAttributeName;
        this.moTypeToMatch = inputMoTypeToMatch;
        this.moTypeToMatchsAttributeName = inputMoTypeToMatchsAttributeName;
        this.moTypeToMatchsAttributeNameValue = inputMoTypeToMatchsAttributeNameValue;
        this.genericMaoContext = inputGenericMaoContext;
    }

    public void validate(ManagedObject moToValidate, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + moToValidate + ")");
        this.validateForbiddenAttribute(moToValidate, coordinator);
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void validateForbiddenAttribute(ManagedObject moToValidate, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        Object attributeValue = moToValidate.getAttribute(this.moAttributeName, coordinator);
        if (attributeValue.equals(this.moAttribute)) {
            MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(this.moTypeToMatch);
            while (moIterator != null && moIterator.hasMoreElements()) {
                ManagedObject nextElement = (ManagedObject)moIterator.nextElement();
                Object forbiddenAttributeValue = nextElement.getAttribute(this.moTypeToMatchsAttributeName, coordinator);
                if (!this.moTypeToMatchsAttributeNameValue.equals(forbiddenAttributeValue)) continue;
                String errorMessage = "The combination MO[" + moToValidate.getLocalDistinguishedName() + "], Attribute[" + this.moAttributeName + "], Value[" + attributeValue + "] is not valid together with MO[" + nextElement.getLocalDistinguishedName() + "], Attribute[" + this.moTypeToMatchsAttributeName + "], Value[" + forbiddenAttributeValue + "]";
                this.logAndThrowPrepareFailedException(errorMessage);
            }
        }
    }
}

