/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.antennanearunit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.net.FTPException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.exception.ActionCollisionException;
import se.ericsson.crbs.cat.common.exception.NoLicenseException;
import se.ericsson.crbs.cat.common.ftp.FtpFaultNumberTranslationHelper;
import se.ericsson.crbs.cat.common.validator.AbstractGenericAttributeValidatorMao;
import se.ericsson.crbs.cat.mao.antennanearunit.AntennaNearUnitMao;
import se.ericsson.crbs.cat.mao.antennanearunit.CorruptFileInServerException;
import se.ericsson.crbs.cat.mao.antennanearunit.DownloadFailureException;
import se.ericsson.crbs.cat.mao.antennanearunit.ReadUserDataFailureException;
import se.ericsson.crbs.cat.mao.antennanearunit.SelfTestProcedureFailureException;
import se.ericsson.crbs.cat.mao.antennanearunit.SendTmfConfigurationFileException;
import se.ericsson.crbs.cat.mao.antennanearunit.WriteUserDataFailureException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonifu.InternalErrorException;
import se.ericsson.crbs.omf.mao.commonmo.NoConnectionWithUnitException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class AntennaNearUnitMaoImpl
extends AbstractGenericAttributeValidatorMao
implements AntennaNearUnitMao {
    private static final String PRODUCT_DATA = "productData";
    private static final String PRODUCT_REVISION = "productRevision";
    private static final String PRODUCT_NUMBER = "productNumber";
    private static final String PRODUCT_NAME = "productName";
    private static final String SERIAL_NUMBER = "serialNumber";
    private static final String PRODUCTION_DATE = "productionDate";
    private static final String PRODUCTION_DATE_DEFAULT_VALUE = "";
    private static final String HARDWARE_VERSION = "hardwareVersion";
    private static final String IUANT_DEVICE_TYPE = "iuantDeviceType";
    private static final String ACTION_RESTART_UNIT = "restartUnit";
    private static final String ACTION_WRITE_USER_DATA = "writeUserData";
    private static final String ACTION_DOWNLOAD_SOFTWARE = "downloadSoftware";
    private static final String ACTION_READ_USER_DATA = "readUserData";
    private static final String ACTION_SELF_TEST = "selfTest";
    private static final int RESULT_WRITE_USER_DATA_EXCEPTION = 1;
    private static final int RESULT_DOWNLOAD_FAILURE_EXCEPTION = 1;
    private static final int RESULT_READ_USER_DATA_FAILURE_EXCEPTION = 1;
    private static final int RESULT_SELF_TEST_PROCEDURE_FAILURE_EXCEPTION = 1;
    private static final int RESULT_INTERNAL_ERROR_EXCEPTION = 1;
    private static final int RESULT_SEND_TMF_CONFIGURATION_FILE_FAILURE_EXCEPTION = 1;
    private static final String ARGUMENT_MEMORY_OFFSET = "memory_offset";
    private static final String ARGUMENT_NUMBER_OF_OCTETS_TO_WRITE = "numberOfOctetsToWrite";
    private static final String ARGUMENT_USERDATAW = "userDataW";
    private static final String ARGUMENT_PATH = "path";
    private static final String ARGUMENT_NUMBER_OF_OCTETS_TO_READ = "numberOfOctetsToRead";
    private static final String ACTION_SEND_TMF_CONFIGURATION_FILE = "sendTmfConfigurationFile";
    private static final Class THIS_CLASS = AntennaNearUnitMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)AntennaNearUnitMaoImpl.class.getName());
    private static final String LOCAL_FILE_PATH = "/c/tmp/";
    private String localFilePath = "/c/tmp/";
    private static final String ADMINISTRATIVE_STATE_ATTR = "administrativeState";
    private static final Integer LOCK = new Integer(0);
    private static final int SHUTTING_DOWN = 2;

    public AntennaNearUnitMaoImpl(ManagedObject parent, AttrList attributes, String identity, GenericMaoContext inputGenericMaoContext, Integer softwareRevision, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(parent, attributes, identity, "AntennaNearUnit", inputGenericMaoContext, softwareRevision, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "AntennaNearUnitMaoImpl() - constructor");
        logger.traceReturn(THIS_CLASS, "AntennaNearUnitMaoImpl() - constructor");
    }

    public AntennaNearUnitMaoImpl(MoDataWrapper recoveredData, String moType, GenericMaoContext inputGenericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(recoveredData, moType, inputGenericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "AntennaNearUnitMaoImpl() - reconstructor");
        logger.traceReturn(THIS_CLASS, "AntennaNearUnitMaoImpl() - reconstructor");
    }

    public void actionDownloadSoftware(String ftpServer, String filePath, String ftpUserName, String ftpPassword, Coordinator inputCoordinator) throws MoAccessException, DownloadFailureException, CorruptFileInServerException, NoLicenseException, ActionCollisionException {
        logger.traceEnter(THIS_CLASS, "actionDownloadSoftware()");
        logger.traceDebug(THIS_CLASS, "server: " + ftpServer + ", path: " + filePath + ", userName: " + ftpUserName + ", coordinator: " + inputCoordinator);
        String zipFileName = this.getFirmWareFileViaFtp(ftpServer, filePath, ftpUserName, ftpPassword);
        String extractedFileData = this.extractZipFileAndVerify(zipFileName);
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put(ARGUMENT_PATH, this.localFilePath + extractedFileData);
        try {
            this.sendActionWithCfm(ACTION_DOWNLOAD_SOFTWARE, inputCoordinator, parameters);
        }
        catch (FroRequestFailedException frfe) {
            String exceptionVariables = frfe.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            int resultInt = Integer.parseInt(result.trim());
            if (1 == resultInt) {
                String msg = "Download failure. Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new DownloadFailureException("AntennaNearUnit", msg);
            }
            if (0x100000C == resultInt) {
                String msg = "Corrupt file in server = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new CorruptFileInServerException("AntennaNearUnit", msg);
            }
            if (0x100000A == resultInt) {
                String msg = "Missing license  = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new NoLicenseException("AntennaNearUnit", msg);
            }
            if (0x100000B == resultInt) {
                String msg = "Action \"downloadSoftware\" cannot be run at the same time as \"antennaDeviceScan\" of NodeManagementFunction MO.";
                logger.traceAbnormal(THIS_CLASS, "Action \"downloadSoftware\" cannot be run at the same time as \"antennaDeviceScan\" of NodeManagementFunction MO.");
                throw new ActionCollisionException("AntennaNearUnit", "Action \"downloadSoftware\" cannot be run at the same time as \"antennaDeviceScan\" of NodeManagementFunction MO.");
            }
            logger.traceAbnormal(THIS_CLASS, "Undefined exception recieved from FRO");
            throw frfe;
        }
        logger.traceReturn(THIS_CLASS, "actionDownloadSoftware()");
    }

    private String extractZipFileAndVerify(String zipFileName) throws DownloadFailureException {
        String extractedFileName = PRODUCTION_DATE_DEFAULT_VALUE;
        try {
            ZipFile zip = new ZipFile(this.localFilePath + zipFileName);
            ZipEntry zipEntry = zip.entries().nextElement();
            long zipCrcNo = zipEntry.getCrc();
            ZipFileData extractedFileData = this.extractFileAndGetCrc(zipFileName);
            extractedFileName = extractedFileData.name;
            if (zipCrcNo != extractedFileData.crcNo) {
                String errMsg = "Zip file damaged in download";
                logger.traceAbnormal(THIS_CLASS, "Zip file damaged in download");
                throw new DownloadFailureException("AntennaNearUnit", "Zip file damaged in download");
            }
            zip.close();
        }
        catch (IOException e) {
            String errMsg = "Error when handling zip file. " + e;
            logger.traceAbnormal(THIS_CLASS, errMsg);
            throw new DownloadFailureException("AntennaNearUnit", errMsg);
        }
        finally {
            File zipFile = new File(this.localFilePath + zipFileName);
            boolean delete = zipFile.delete();
            if (!delete) {
                logger.info(THIS_CLASS, "Could not delete Zip file [" + zipFile.getAbsolutePath() + "]");
            }
        }
        return extractedFileName;
    }

    private String getFirmWareFileViaFtp(String server, String path, String username, String password) throws DownloadFailureException {
        String fileName = new File(path).getName();
        String remoteFilePath = path;
        try {
            logger.traceDebug(THIS_CLASS, "Downloading Firmware file from server... server= " + server + ", path= " + path);
            this.genericMaoContext.getFTPClientWrapperFactory().getFTPClientWrapper().get(server, username, password, this.localFilePath + fileName, remoteFilePath);
        }
        catch (FTPException ftpe) {
            FtpFaultNumberTranslationHelper ftpFaultNumberTranslater = new FtpFaultNumberTranslationHelper();
            String errMsg = "FTP-error, Failed to retrieve \"" + remoteFilePath + "\" due to error: " + ftpFaultNumberTranslater.translateFtpFaultNumber(ftpe);
            logger.traceAbnormal(THIS_CLASS, errMsg);
            logger.traceDebug(THIS_CLASS, errMsg);
            throw new DownloadFailureException("AntennaNearUnit", errMsg);
        }
        catch (Exception e) {
            String errMsg = "FTP-error, Failed to retrieve \"" + remoteFilePath + "\" due to error: " + e;
            logger.traceDebug(THIS_CLASS, errMsg);
            throw new DownloadFailureException("AntennaNearUnit", errMsg);
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipFileData extractFileAndGetCrc(String fileName) throws IOException {
        ZipFileData fileData = new ZipFileData();
        ZipInputStream zipInputStream = null;
        FilterInputStream checkedInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(this.localFilePath + fileName));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            String entryName = zipEntry.getName();
            fileData.setName(entryName);
            checkedInputStream = new CheckedInputStream(zipInputStream, new CRC32());
            fileOutputStream = new FileOutputStream(this.localFilePath + entryName);
            byte[] buf = new byte[1024];
            int n = ((CheckedInputStream)checkedInputStream).read(buf, 0, 1024);
            while (n > -1) {
                fileOutputStream.write(buf, 0, n);
                n = ((CheckedInputStream)checkedInputStream).read(buf, 0, 1024);
            }
            fileData.setCrc(((CheckedInputStream)checkedInputStream).getChecksum().getValue());
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.closeEntry();
            }
            if (checkedInputStream != null) {
                checkedInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return fileData;
    }

    public String actionReadUserData(int memoryOffset, int numberOfOctetsToRead, Coordinator coordinator) throws MoAccessException, ReadUserDataFailureException {
        logger.traceEnter(THIS_CLASS, "actionReadUserData()");
        logger.traceDebug(THIS_CLASS, "memory_offset: " + memoryOffset + ", numberOfOctetsToRead: " + numberOfOctetsToRead);
        TreeMap<String, Integer> parameters = new TreeMap<String, Integer>();
        parameters.put(ARGUMENT_MEMORY_OFFSET, new Integer(memoryOffset));
        parameters.put(ARGUMENT_NUMBER_OF_OCTETS_TO_READ, new Integer(numberOfOctetsToRead));
        String returnString = PRODUCTION_DATE_DEFAULT_VALUE;
        try {
            Map returnedParameters = this.sendActionWithCfm(ACTION_READ_USER_DATA, coordinator, parameters);
            Iterator parameterNameIterator = returnedParameters.keySet().iterator();
            returnString = (String)parameterNameIterator.next();
        }
        catch (FroRequestFailedException frfe) {
            String exceptionVariables = frfe.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            int resultInt = Integer.parseInt(result.trim());
            if (1 == resultInt) {
                String msg = "Read of user data failed. Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new ReadUserDataFailureException("AntennaNearUnit", msg);
            }
            logger.traceAbnormal(THIS_CLASS, "Undefined exception recieved from FRO");
            throw frfe;
        }
        logger.traceReturn(THIS_CLASS, "actionReadUserData()");
        return returnString;
    }

    public void actionRestartUnit(Coordinator coordinator) throws MoAccessException, NoConnectionWithUnitException, InternalErrorException {
        logger.traceEnter(THIS_CLASS, "actionRestartUnit()");
        logger.traceDebug(THIS_CLASS, "Coodinator: " + coordinator);
        try {
            this.sendActionWithCfm(ACTION_RESTART_UNIT, coordinator, new TreeMap());
        }
        catch (FroRequestFailedException frfe) {
            String exceptionVariables = frfe.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            int resultInt = Integer.parseInt(result.trim());
            if (0x1000006 == resultInt) {
                String msg = "No connection with unit. Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new NoConnectionWithUnitException("AntennaNearUnit", msg);
            }
            if (1 == resultInt) {
                String msg = "Action \"restartUnit\" failed";
                logger.traceAbnormal(THIS_CLASS, "Action \"restartUnit\" failed");
                throw new InternalErrorException("AntennaNearUnit", "Action \"restartUnit\" failed");
            }
            logger.traceAbnormal(THIS_CLASS, "Undefined exception recieved from FRO");
            throw frfe;
        }
        logger.traceReturn(THIS_CLASS, "actionRestartUnit()");
    }

    public String actionSelfTest(Coordinator coordinator) throws MoAccessException, NoConnectionWithUnitException, SelfTestProcedureFailureException {
        logger.traceEnter(THIS_CLASS, "actionSelfTest()");
        String returnString = PRODUCTION_DATE_DEFAULT_VALUE;
        try {
            Map returnedParameters = this.sendActionWithCfm(ACTION_SELF_TEST, coordinator, new TreeMap());
            Iterator parameterNameIterator = returnedParameters.keySet().iterator();
            if (parameterNameIterator.hasNext()) {
                returnString = (String)parameterNameIterator.next();
            }
        }
        catch (FroRequestFailedException frfe) {
            String exceptionVariables = frfe.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            int resultInt = Integer.parseInt(result.trim());
            if (1 == resultInt) {
                String msg = "Self test procedure failure. Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new SelfTestProcedureFailureException("AntennaNearUnit", msg);
            }
            if (0x1000006 == resultInt) {
                String msg = "No connection with unit. Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new NoConnectionWithUnitException("AntennaNearUnit", msg);
            }
            logger.traceAbnormal(THIS_CLASS, "Undefined exception recieved from FRO");
            throw frfe;
        }
        logger.traceReturn(THIS_CLASS, "actionSelfTest()");
        return returnString;
    }

    public void actionWriteUserData(int memoryOffset, int numberOfOctetsToWrite, String userDataW, Coordinator coordinator) throws MoAccessException, WriteUserDataFailureException {
        logger.traceEnter(THIS_CLASS, "actionWriteUserData()");
        logger.traceDebug(THIS_CLASS, "memoryOffset: " + memoryOffset + ", numberOfOctetsToWrite: " + numberOfOctetsToWrite + ", userDataW: " + userDataW);
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put(ARGUMENT_MEMORY_OFFSET, new Integer(memoryOffset));
        parameters.put(ARGUMENT_NUMBER_OF_OCTETS_TO_WRITE, new Integer(numberOfOctetsToWrite));
        parameters.put(ARGUMENT_USERDATAW, userDataW);
        try {
            this.sendActionWithCfm(ACTION_WRITE_USER_DATA, coordinator, parameters);
        }
        catch (FroRequestFailedException frfe) {
            String exceptionVariables = frfe.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            int resultInt = Integer.parseInt(result.trim());
            if (1 == resultInt) {
                String msg = "Write of user data failed. Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new WriteUserDataFailureException("AntennaNearUnit", msg);
            }
            logger.traceAbnormal(THIS_CLASS, "Undefined exception recieved from FRO");
            throw frfe;
        }
        logger.traceReturn(THIS_CLASS, "actionWriteUserData()");
    }

    public Object getAttribute(String attrName, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        Object result = PRODUCT_DATA.equals(attrName) ? this.provideProductData(coordinator) : super.getAttribute(attrName, coordinator);
        return result;
    }

    public Object[] getAttributes(String[] attributeNames, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributes()");
        ArrayList<String> attributeNamesList = new ArrayList<String>();
        HashMap<String, Struct> derecatedValues = new HashMap<String, Struct>();
        for (int i = 0; i < attributeNames.length; ++i) {
            if (PRODUCT_DATA.equals(attributeNames[i])) {
                derecatedValues.put(attributeNames[i], this.provideProductData(coordinator));
                continue;
            }
            attributeNamesList.add(attributeNames[i]);
        }
        Object[] myAttributes = super.getAttributes(attributeNamesList.toArray(new String[attributeNamesList.size()]), coordinator);
        logger.traceReturn(THIS_CLASS, "getAttributes()");
        return this.combineAttributeLists(attributeNames, attributeNamesList, myAttributes, derecatedValues);
    }

    private Struct provideProductData(Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        String[] attributeNames = new String[]{PRODUCT_REVISION, PRODUCT_NUMBER, PRODUCT_NAME, SERIAL_NUMBER, PRODUCTION_DATE};
        Object[] attributeValues = new Object[]{this.getAttribute(HARDWARE_VERSION, coordinator), this.getAttribute(PRODUCT_NUMBER, coordinator), this.getIuantDeviceType(coordinator), this.getAttribute(SERIAL_NUMBER, coordinator), PRODUCTION_DATE_DEFAULT_VALUE};
        return new StructImpl(attributeNames, attributeValues);
    }

    private String getIuantDeviceType(Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        Integer iuantDeviceType = (Integer)this.getAttribute(IUANT_DEVICE_TYPE, coordinator);
        int typeValue = iuantDeviceType;
        return typeValue == 1 ? "RET" : (typeValue == 2 ? "TMA" : (typeValue == 17 ? "MA-RET" : "Undefined: " + typeValue));
    }

    protected void setLocalFilePath(String newPath) {
        this.localFilePath = newPath;
    }

    protected void registerValidators() {
    }

    public void setAttribute(String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttribute()");
        if (ADMINISTRATIVE_STATE_ATTR.equals(attributeName)) {
            int value = (Integer)attributeValue;
            if (value == 2) {
                super.setAttribute(ADMINISTRATIVE_STATE_ATTR, LOCK, coordinator);
            } else {
                super.setAttribute(attributeName, attributeValue, coordinator);
            }
        } else {
            super.setAttribute(attributeName, attributeValue, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setAttribute()");
    }

    public void setAttributes(String[] attributeNames, Object[] attributeValues, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttributes()");
        for (int i = 0; i < attributeNames.length; ++i) {
            if (ADMINISTRATIVE_STATE_ATTR.equals(attributeNames[i])) {
                this.setAttribute(attributeNames[i], attributeValues[i], coordinator);
                continue;
            }
            super.setAttribute(attributeNames[i], attributeValues[i], coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setAttributes()");
    }

    public void actionSendTmfConfigurationFile(String server, String path, String userName, String password, Coordinator coordinator) throws MoAccessException, NoConnectionWithUnitException, SendTmfConfigurationFileException {
        logger.traceEnter(THIS_CLASS, "actionSendTmfConfigurationFile(): server: " + server + ", path: " + path + ", username: " + userName);
        String fileName = new File(path).getName();
        String remoteFilePath = path;
        try {
            logger.traceDebug(THIS_CLASS, "Trying to download TMF configuration file from server...server= " + server + ", path= " + path);
            this.genericMaoContext.getFTPClientWrapperFactory().getFTPClientWrapper().get(server, userName, password, LOCAL_FILE_PATH + fileName, remoteFilePath);
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put(ARGUMENT_PATH, LOCAL_FILE_PATH + fileName);
            this.sendActionWithCfm(ACTION_SEND_TMF_CONFIGURATION_FILE, coordinator, treeMap);
        }
        catch (FTPException ftpe) {
            FtpFaultNumberTranslationHelper ftpFaultNumberTranslater = new FtpFaultNumberTranslationHelper();
            String errMsg = "FTP-error, Failed to retrieve \"" + remoteFilePath + "\" due to error: " + ftpFaultNumberTranslater.translateFtpFaultNumber(ftpe);
            logger.traceAbnormal(THIS_CLASS, errMsg);
            throw new SendTmfConfigurationFileException("AntennaNearUnit", errMsg);
        }
        catch (FroRequestFailedException frfe) {
            String exceptionVariables = frfe.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            int resultInt = Integer.parseInt(result.trim());
            if (1 == resultInt) {
                String msg = "Error when communicating with FRO. Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new SendTmfConfigurationFileException("AntennaNearUnit", msg);
            }
            if (0x1000006 == resultInt) {
                String msg = "No connection with unit. Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new NoConnectionWithUnitException("AntennaNearUnit", msg);
            }
            logger.traceAbnormal(THIS_CLASS, "Undefined exception recieved from FRO");
            throw frfe;
        }
        catch (Exception e) {
            String errMsg = "FTP-error, Failed to retrieve \"" + remoteFilePath + "\" due to error: " + e;
            logger.traceAbnormal(THIS_CLASS, errMsg);
            throw new SendTmfConfigurationFileException("AntennaNearUnit", errMsg);
        }
        logger.traceReturn(THIS_CLASS, "actionSendTmfConfigurationFile()");
    }

    private class ZipFileData {
        private String name = "";
        private long crcNo;

        private ZipFileData() {
        }

        private void setName(String newName) {
            this.name = newName;
        }

        private void setCrc(long newCrc) {
            this.crcNo = newCrc;
        }
    }
}

