/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.auxpluginunit;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class HwCompatibilityChecker {
    private static final List RADIO_COMPATIBILITYGROUP = new ArrayList(8);
    private static final List XMU_COMPATIBILITYGROUP = new ArrayList(1);
    private static final Class THIS_CLASS;
    private static final AbstractLogger logger;

    public static boolean checkHwIncompatibility(PiuTypeMo piuType1, PiuTypeMo piuType2, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "checkHwIncompatibility()");
        boolean result = false;
        if (piuType1 != null && piuType2 != null) {
            Struct piuType1ProductData = piuType1.getProductData(coordinator);
            String piuType1ProductName = (String)piuType1ProductData.getValue("productName");
            Struct piuType2ProductData = piuType2.getProductData(coordinator);
            String piuType2ProductName = (String)piuType2ProductData.getValue("productName");
            logger.traceGeneral(THIS_CLASS, "Verifying Hw compatibility, comparing: " + piuType1.getLocalDistinguishedName() + " with productName: " + piuType1ProductName + ", against: " + piuType2.getLocalDistinguishedName() + " with productName: " + piuType2ProductName);
            if (HwCompatibilityChecker.incompatibleProductNames(piuType1ProductName, piuType2ProductName)) {
                logger.traceGeneral(THIS_CLASS, "PiuTypes have incompatible productNames.");
                result = true;
            } else if (HwCompatibilityChecker.incompatibleXmuProducts(piuType1, piuType2, coordinator)) {
                logger.traceGeneral(THIS_CLASS, "PiuTypes are incompatible XMU products");
                result = true;
            } else {
                logger.traceGeneral(THIS_CLASS, "PiuTypes are compatible");
            }
        }
        logger.traceReturn(THIS_CLASS, "checkHwIncompatibility(" + result + ")");
        return result;
    }

    private static boolean incompatibleProductNames(String productName1, String productName2) {
        boolean product1IsRadio = RADIO_COMPATIBILITYGROUP.contains(productName1);
        boolean product1IsXmu = XMU_COMPATIBILITYGROUP.contains(productName1);
        boolean product2IsRadio = RADIO_COMPATIBILITYGROUP.contains(productName2);
        boolean product2IsXmu = XMU_COMPATIBILITYGROUP.contains(productName2);
        return product1IsRadio && product2IsXmu || product1IsXmu && product2IsRadio;
    }

    private static boolean incompatibleXmuProducts(PiuTypeMo piuType1, PiuTypeMo piuType2, Coordinator coordinator) throws MoAccessException {
        boolean incompatible = false;
        Struct piuType1ProductData = piuType1.getProductData(coordinator);
        String piuType1ProductName = (String)piuType1ProductData.getValue("productName");
        Struct piuType2ProductData = piuType2.getProductData(coordinator);
        String piuType2ProductName = (String)piuType2ProductData.getValue("productName");
        if (piuType1ProductName.equals("XMU") && piuType2ProductName.equals("XMU")) {
            logger.traceGeneral(THIS_CLASS, "Checking compatibility of Xmu products, comparing: " + piuType1.getLocalDistinguishedName() + ", with: " + piuType2.getLocalDistinguishedName());
            boolean piuType1IsXmu02 = HwCompatibilityChecker.isXmu02Config(piuType1, coordinator);
            boolean piuType2IsXmu02 = HwCompatibilityChecker.isXmu02Config(piuType2, coordinator);
            if (piuType1IsXmu02 != piuType2IsXmu02) {
                incompatible = true;
            }
        }
        return incompatible;
    }

    private static boolean isXmu02Config(PiuTypeMo piuType, Coordinator coordinator) throws MoAccessException {
        int noOfMoConfig = piuType.actionNumberOfMoConfigurations(coordinator);
        for (int i = 0; i < noOfMoConfig; ++i) {
            Struct moConfig = piuType.actionGetMoConfiguration(i, coordinator);
            String moId = (String)moConfig.getValue("identity");
            String moTypeName = (String)moConfig.getValue("moTypeNamea");
            if (!moTypeName.equals("RiPort") || !moId.equals("B1")) continue;
            logger.traceGeneral(THIS_CLASS, "RiPort B1 found in moConfiguration for piuType: " + piuType.getLocalDistinguishedName() + ". Therefore concluding XMU 02 configuration.");
            return true;
        }
        logger.traceGeneral(THIS_CLASS, "No RiPort B1 found in moConfiguration for piuType: " + piuType.getLocalDistinguishedName() + ". Therefore concluding XMU 03 configuration.");
        return false;
    }

    static {
        RADIO_COMPATIBILITYGROUP.add("RUL");
        RADIO_COMPATIBILITYGROUP.add("RUS");
        RADIO_COMPATIBILITYGROUP.add("RRUS");
        RADIO_COMPATIBILITYGROUP.add("RU");
        RADIO_COMPATIBILITYGROUP.add("RRU");
        RADIO_COMPATIBILITYGROUP.add("IRU");
        RADIO_COMPATIBILITYGROUP.add("RUW");
        RADIO_COMPATIBILITYGROUP.add("RRUW");
        XMU_COMPATIBILITYGROUP.add("XMU");
        THIS_CLASS = HwCompatibilityChecker.class;
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }
}

