/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.auxpluginunit;

import java.util.Locale;
import se.ericsson.cello.moframework.MoAccessException;

public class RevisionHolder {
    private static final String WILD_CARD_LETTER = "*";
    private String leadingRevisionLetters = "";
    private int leadingRevisionNumber = -1;
    private String revisionLetters = "";
    private String trailingRevisionLetters = "";
    private int trailingRevisionNumber = Integer.MAX_VALUE;
    private boolean slashed = false;
    private boolean slashedWithANumber = false;
    private boolean revisionMatchesAll = false;
    private boolean leadingRevisionNumberContainsWildCard = false;
    private boolean revisionLettersContainsWildCard = false;
    private boolean trailingRevisionLettersContainsWildCard = false;
    private boolean trailingRevisionNumberContainsWildCard = false;
    private final String productRevision;
    private final boolean includeSlashedNumbers;

    public RevisionHolder(String inputProductRevision) throws RevisionParseException {
        this(inputProductRevision, false);
    }

    public RevisionHolder(String inputProductRevision, boolean inputIncludeSlashedNumbers) throws RevisionParseException {
        this.productRevision = inputProductRevision;
        this.includeSlashedNumbers = inputIncludeSlashedNumbers;
        this.parse(this.productRevision);
    }

    public boolean isIncludeSlashedNumbers() {
        return this.includeSlashedNumbers;
    }

    public boolean matchesAll() {
        return this.revisionMatchesAll;
    }

    public boolean isLeadingRevisionNumberContainingWildCard() {
        return this.leadingRevisionNumberContainsWildCard;
    }

    public boolean isRevisionLettersContainingWildCard() {
        return this.revisionLettersContainsWildCard;
    }

    public boolean isTrailingRevisionLettersContainingWildCard() {
        return this.trailingRevisionLettersContainsWildCard;
    }

    public boolean isTrailingRevisionNumberContainingWildCard() {
        return this.trailingRevisionNumberContainsWildCard;
    }

    public String getProductRevision() {
        return this.productRevision;
    }

    private void parse(String localProductRevision) throws RevisionParseException {
        if (localProductRevision.equalsIgnoreCase(WILD_CARD_LETTER)) {
            this.revisionMatchesAll = true;
        } else {
            int index = 0;
            byte[] revBytes = localProductRevision.getBytes();
            index = this.parseLeadingRevisionLetters(0, revBytes);
            index = this.parseLeadingRevisionNumber(index, revBytes);
            if ((index = this.parseRevisionLetters(index, revBytes)) < revBytes.length) {
                if (revBytes[index] == 47) {
                    this.slashed = true;
                    ++index;
                }
                if ((index = this.parseTrailingRevisionLetters(index, revBytes)) < revBytes.length) {
                    this.parseTrailingRevisionNumbers(index, localProductRevision, revBytes);
                }
            }
        }
    }

    private int parseLeadingRevisionLetters(int startPos, byte[] revBytes) {
        int index = startPos;
        StringBuffer tmpBuf = new StringBuffer(20);
        for (int i = startPos; i < revBytes.length; ++i) {
            if (this.isNumber(revBytes[i])) {
                index = i;
                break;
            }
            tmpBuf.append((char)revBytes[i]);
            index = i + 1;
        }
        this.leadingRevisionLetters = tmpBuf.toString();
        return index;
    }

    private int parseLeadingRevisionNumber(int startPos, byte[] revBytes) {
        int index = startPos;
        StringBuffer tmpBuf = new StringBuffer(20);
        boolean containsWildCard = false;
        for (int i = startPos; i < revBytes.length; ++i) {
            if (this.isWildChar(revBytes[i])) {
                containsWildCard = true;
                break;
            }
            if (!this.isNumber(revBytes[i])) {
                index = i;
                break;
            }
            tmpBuf.append((char)revBytes[i]);
            index = i + 1;
        }
        try {
            if (tmpBuf.length() > 0) {
                this.leadingRevisionNumber = Integer.parseInt(tmpBuf.toString());
            } else if (containsWildCard) {
                ++index;
                this.leadingRevisionNumberContainsWildCard = true;
            }
        }
        catch (NumberFormatException nfe) {
            this.leadingRevisionNumber = -1;
        }
        return index;
    }

    private int parseRevisionLetters(int startPos, byte[] revBytes) {
        int index = startPos;
        StringBuffer tmpBuf = new StringBuffer(20);
        boolean containsWildCard = false;
        for (int i = startPos; i < revBytes.length; ++i) {
            if (this.isWildChar(revBytes[i])) {
                containsWildCard = true;
                break;
            }
            if (this.isNumber(revBytes[i]) || this.isSlash(revBytes[i])) {
                index = i;
                break;
            }
            tmpBuf.append((char)revBytes[i]);
            index = i + 1;
        }
        if (tmpBuf.length() > 0) {
            this.revisionLetters = tmpBuf.toString();
        } else if (containsWildCard) {
            ++index;
            this.revisionLettersContainsWildCard = true;
        }
        return index;
    }

    private boolean isSlash(byte revBytes) {
        return revBytes == 47;
    }

    private boolean isWildChar(byte revBytes) {
        return revBytes == 42;
    }

    private int parseTrailingRevisionLetters(int startPos, byte[] revBytes) {
        int index = startPos;
        StringBuffer tmpBuf = new StringBuffer(20);
        boolean containsWildCard = false;
        int i = startPos;
        while (i < revBytes.length) {
            if (this.isWildChar(revBytes[i])) {
                containsWildCard = true;
                break;
            }
            if (this.isNumber(revBytes[i])) break;
            tmpBuf.append((char)revBytes[i]);
            index = i++;
        }
        if (tmpBuf.length() > 0) {
            this.trailingRevisionLetters = tmpBuf.toString();
        } else if (containsWildCard) {
            ++index;
            this.trailingRevisionLettersContainsWildCard = true;
        }
        return index;
    }

    private int parseTrailingRevisionNumbers(int startPos, String localProductRevision, byte[] revBytes) throws RevisionParseException {
        int index = startPos;
        StringBuffer tmpBuf = new StringBuffer(20);
        boolean containsWildCard = false;
        for (int i = startPos; i < revBytes.length; ++i) {
            if (this.isWildChar(revBytes[i])) {
                containsWildCard = true;
                break;
            }
            if (!this.isNumber(revBytes[i])) break;
            tmpBuf.append((char)revBytes[i]);
        }
        if (tmpBuf.length() > 0) {
            try {
                this.trailingRevisionNumber = Integer.parseInt(tmpBuf.toString());
                this.slashedWithANumber = this.slashed;
            }
            catch (NumberFormatException nfe) {
                throw new RevisionParseException("Error parsing the trailing revision number from: \"" + localProductRevision + "\"", nfe);
            }
        } else if (containsWildCard) {
            this.trailingRevisionNumberContainsWildCard = true;
        }
        return index;
    }

    private boolean isNumber(byte revBytes) {
        return revBytes >= 48 && revBytes <= 57;
    }

    public int hashCode() {
        return this.productRevision.hashCode();
    }

    public boolean equals(Object otherObj) {
        boolean result = true;
        if (otherObj instanceof RevisionHolder) {
            RevisionHolder otherRevisionHolder = (RevisionHolder)otherObj;
            boolean leadingRevisionLettersMatch = this.leadingRevisionLetters.equalsIgnoreCase(otherRevisionHolder.getLeadingRevisionLetters());
            result = leadingRevisionLettersMatch;
            result = result && this.leadingRevisionNumbersMatch(otherRevisionHolder);
            result = result && this.revisionLettersMatch(otherRevisionHolder);
            result = result && this.trailingRevisionLettersMatch(otherRevisionHolder);
            result = result && this.slashedRevision(otherRevisionHolder);
            result = result || this.revisionMatchesAll || otherRevisionHolder.matchesAll();
        } else {
            result = super.equals(otherObj);
        }
        return result;
    }

    private boolean slashedRevision(RevisionHolder otherRevisionHolder) {
        boolean trailingRevisionNumberMatch;
        boolean result = true;
        boolean bl = trailingRevisionNumberMatch = this.trailingRevisionNumber == otherRevisionHolder.getTrailingRevisionNumber();
        if (!this.isTrailingRevisionNumberContainingWildCard() && !otherRevisionHolder.isTrailingRevisionNumberContainingWildCard()) {
            result = trailingRevisionNumberMatch;
            boolean slashedMatch = this.isSlashed() == otherRevisionHolder.isSlashed();
            result = result && slashedMatch;
            boolean slashedWithANumberMatch = this.isSlashedWithANumber() == otherRevisionHolder.isSlashedWithANumber();
            result = result && slashedWithANumberMatch;
        }
        return result;
    }

    private boolean trailingRevisionLettersMatch(RevisionHolder otherRevisionHolder) {
        boolean result = true;
        boolean trailingRevisionLettersMatch = this.trailingRevisionLetters.equalsIgnoreCase(otherRevisionHolder.getTrailingRevisionLetters());
        if (!this.isTrailingRevisionLettersContainingWildCard() && !otherRevisionHolder.isTrailingRevisionLettersContainingWildCard()) {
            result = trailingRevisionLettersMatch;
        }
        return result;
    }

    private boolean revisionLettersMatch(RevisionHolder otherRevisionHolder) {
        boolean result = true;
        boolean revisionLettersMatch = this.revisionLetters.equalsIgnoreCase(otherRevisionHolder.getRevisionLetters());
        if (!this.isRevisionLettersContainingWildCard() && !otherRevisionHolder.isRevisionLettersContainingWildCard()) {
            result = revisionLettersMatch;
        }
        return result;
    }

    private boolean leadingRevisionNumbersMatch(RevisionHolder otherRevisionHolder) {
        boolean leadingRevisionNumberMatch;
        boolean result = true;
        boolean bl = leadingRevisionNumberMatch = this.leadingRevisionNumber == otherRevisionHolder.getLeadingRevisionNumber();
        if (!this.isLeadingRevisionNumberContainingWildCard() && !otherRevisionHolder.isLeadingRevisionNumberContainingWildCard()) {
            result = leadingRevisionNumberMatch;
        }
        return result;
    }

    public boolean isGreaterThan(RevisionHolder otherRevisionHolder) {
        boolean result = true;
        boolean doNotIncludeSlashedNumbers = !this.includeSlashedNumbers && !otherRevisionHolder.isIncludeSlashedNumbers();
        result = doNotIncludeSlashedNumbers && (this.revisionMatchesAll || this.slashedWithANumber || otherRevisionHolder.isSlashedWithANumber()) ? false : this.getLeadingRevisionLettersResult(otherRevisionHolder);
        return result;
    }

    private boolean getLeadingRevisionLettersResult(RevisionHolder otherRevisionHolder) {
        boolean result = true;
        result = this.leadingRevisionLetters.toLowerCase(Locale.getDefault()).compareTo(otherRevisionHolder.getLeadingRevisionLetters().toLowerCase(Locale.getDefault())) > 0 ? true : (this.leadingRevisionLetters.toLowerCase(Locale.getDefault()).compareTo(otherRevisionHolder.getLeadingRevisionLetters().toLowerCase(Locale.getDefault())) < 0 ? false : this.getLeadingRevisionNumberResult(otherRevisionHolder));
        return result;
    }

    private boolean getLeadingRevisionNumberResult(RevisionHolder otherRevisionHolder) {
        boolean result = true;
        result = this.leadingRevisionNumberContainsWildCard || otherRevisionHolder.isLeadingRevisionNumberContainingWildCard() ? false : (this.leadingRevisionNumber > otherRevisionHolder.getLeadingRevisionNumber() ? true : (this.leadingRevisionNumber < otherRevisionHolder.getLeadingRevisionNumber() ? false : this.getRevisionLettersResult(otherRevisionHolder)));
        return result;
    }

    private boolean getRevisionLettersResult(RevisionHolder otherRevisionHolder) {
        boolean result = true;
        String revLetters = this.revisionLetters.toLowerCase(Locale.getDefault());
        String otherRevLetters = otherRevisionHolder.getRevisionLetters().toLowerCase(Locale.getDefault());
        result = this.revisionLettersContainsWildCard || otherRevisionHolder.isRevisionLettersContainingWildCard() ? false : (revLetters.length() < otherRevLetters.length() ? false : (revLetters.length() > otherRevLetters.length() ? true : (revLetters.compareTo(otherRevLetters) > 0 ? true : (revLetters.compareTo(otherRevLetters) < 0 ? false : this.getNonSlashedResult(otherRevisionHolder)))));
        return result;
    }

    private boolean getNonSlashedResult(RevisionHolder otherRevisionHolder) {
        boolean result = true;
        result = this.trailingRevisionNumberContainsWildCard || otherRevisionHolder.isTrailingRevisionNumberContainingWildCard() ? false : (this.slashed || otherRevisionHolder.isSlashed() ? this.getSlashedResult(otherRevisionHolder) : (this.trailingRevisionNumber > otherRevisionHolder.getTrailingRevisionNumber() ? true : (this.trailingRevisionNumber < otherRevisionHolder.getTrailingRevisionNumber() ? false : this.getSlashedResult(otherRevisionHolder))));
        return result;
    }

    private boolean getSlashedResult(RevisionHolder otherRevisionHolder) {
        boolean otherIsSlashed;
        boolean result = true;
        boolean doIncludeSlashedNumbers = this.includeSlashedNumbers || otherRevisionHolder.isIncludeSlashedNumbers();
        boolean allSlashedNumbers = doIncludeSlashedNumbers && this.slashedWithANumber && otherRevisionHolder.isSlashedWithANumber();
        boolean oneSlashedNumber = doIncludeSlashedNumbers && (this.slashedWithANumber && !otherRevisionHolder.isSlashedWithANumber() || !this.slashedWithANumber && otherRevisionHolder.isSlashedWithANumber());
        boolean thisIsSlashed = this.slashed && !otherRevisionHolder.isSlashed();
        boolean bl = otherIsSlashed = !this.slashed && otherRevisionHolder.isSlashed();
        result = this.trailingRevisionLettersContainsWildCard || otherRevisionHolder.isTrailingRevisionLettersContainingWildCard() ? false : (allSlashedNumbers ? this.trailingRevisionNumber > otherRevisionHolder.getTrailingRevisionNumber() : (oneSlashedNumber ? false : (thisIsSlashed ? !this.trailingRevisionLetters.equals("") : (otherIsSlashed ? otherRevisionHolder.getTrailingRevisionLetters().equals("") : this.trailingRevisionLetters.compareTo(otherRevisionHolder.getTrailingRevisionLetters()) > 0))));
        return result;
    }

    public boolean isLessThan(RevisionHolder otherRevisionHolder) {
        return otherRevisionHolder.isGreaterThan(this);
    }

    public String getLeadingRevisionLetters() {
        return this.leadingRevisionLetters;
    }

    public int getLeadingRevisionNumber() {
        return this.leadingRevisionNumber;
    }

    public String getRevisionLetters() {
        return this.revisionLetters;
    }

    public String getTrailingRevisionLetters() {
        return this.trailingRevisionLetters;
    }

    public int getTrailingRevisionNumber() {
        return this.trailingRevisionNumber;
    }

    public boolean isSlashed() {
        return this.slashed;
    }

    public boolean isSlashedWithANumber() {
        return this.slashedWithANumber;
    }

    public class RevisionParseException
    extends MoAccessException {
        private static final long serialVersionUID = 1L;

        public RevisionParseException(String errorMsg, Throwable throwable) {
            super(errorMsg);
            this.addVariableValue("Original Exception", throwable);
        }

        public String getMessage() {
            StringBuffer message = new StringBuffer(super.getReasonTag()).append("\nCaused by: ").append(this.getVariablesAsString());
            return message.toString();
        }
    }
}

