/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.devicegroup;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.pmapp.GenPmMao;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.devicegroup.DeviceGroupMao;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class DeviceGroupMaoImpl
extends GenericMao
implements DeviceGroupMao,
AvcSubscriber {
    private static final Class THIS_CLASS = DeviceGroupMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String TR_DEVICE_SET = "TrDeviceSet";
    private static final String XMU_DEVICE_SET = "XmuDeviceSet";
    private static final String RDIC_DEVICE_SET = "RdicDeviceSet";
    private static final String POSITION_REF_ATTR_NAME = "positionRef";
    private boolean m_subscribingAVC = false;

    public DeviceGroupMaoImpl(ManagedObject parent, AttrList attributes, String identity, GenericMaoContext aGenericMaoContext, Integer softwareRevision, Coordinator coordinator, InitialMaoContext initialmaocontext) throws MoAccessException {
        super(parent, attributes, identity, "DeviceGroup", aGenericMaoContext, softwareRevision, coordinator, initialmaocontext);
        this.setReadOnlyAttribute(POSITION_REF_ATTR_NAME, parent.getAttribute(POSITION_REF_ATTR_NAME, coordinator), coordinator);
    }

    public DeviceGroupMaoImpl(MoDataWrapper recoveredData, String moType, GenericMaoContext aGenericMaoContext, InitialMaoContext initialmaocontext) throws MoNameAlreadyTakenException, MoAccessException {
        super(recoveredData, moType, aGenericMaoContext, initialmaocontext);
        this.registerForAVCSubscription();
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(THIS_CLASS, "delete()");
        MoIterator childrenIter = this.getChildren();
        if (childrenIter != null) {
            while (childrenIter.hasMoreElements()) {
                ManagedObject child = childrenIter.nextMo();
                if (!TR_DEVICE_SET.equals(child.getType()) && !XMU_DEVICE_SET.equals(child.getType()) && !RDIC_DEVICE_SET.equals(child.getType())) continue;
                logger.traceDebug(THIS_CLASS, "Deleting MO: " + child);
                child.delete(coordinator);
            }
        }
        if (this.m_subscribingAVC) {
            logger.traceDebug(THIS_CLASS, "unregisterForAVCSubscription: MO:" + this + " MoType: " + this.getParent().getType() + " Attribute Name: " + POSITION_REF_ATTR_NAME);
            this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, this.getParent().getType(), POSITION_REF_ATTR_NAME);
        }
        super.delete(coordinator);
        logger.traceReturn(THIS_CLASS, "delete()");
    }

    public AttrList addFroParametersAtCreate(AttrList allAttributesList, AttrList notUsedList, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addFroParametersAtCreate()");
        ManagedObject myParent = this.getParent();
        int piuFroId = 1;
        if (myParent instanceof GenPmMao) {
            piuFroId = ((GenPmMao)myParent).getFroId(coordinator);
            logger.traceGeneral(THIS_CLASS, "PIU, piuFroId=" + piuFroId);
        } else if (myParent instanceof GenericMao) {
            piuFroId = ((GenericMao)myParent).getFroId(coordinator);
            logger.traceGeneral(THIS_CLASS, "AuxPIU, piuFroId=" + piuFroId);
        } else {
            logger.traceGeneral(THIS_CLASS, "OTHER (" + myParent.getClass() + "), piuFroId=" + piuFroId);
        }
        ((AttrListImpl)allAttributesList).addAttribute("piuFroId", (Object)new Integer(piuFroId));
        ((AttrListImpl)allAttributesList).addAttribute(POSITION_REF_ATTR_NAME, this.getParent().getAttribute(POSITION_REF_ATTR_NAME, coordinator));
        logger.traceDebug(THIS_CLASS, "registerForAVCSubscription()");
        this.registerForAVCSubscription();
        logger.traceReturn(THIS_CLASS, "addFroParametersAtCreate()");
        return super.addFroParametersAtCreate(allAttributesList, notUsedList, coordinator);
    }

    public void reportAvc(String ldn, String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "reportAvc, attributeName = " + attributeName);
        if (ldn.equalsIgnoreCase(this.getParent().getLocalDistinguishedName()) && attributeName.equalsIgnoreCase(POSITION_REF_ATTR_NAME)) {
            logger.traceDebug(THIS_CLASS, "setReadOnlyAttribute on DeviceGroup due to positionRef change from the parent MO.");
            super.setReadOnlyAttribute(POSITION_REF_ATTR_NAME, attributeValue, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "reportAvc()");
    }

    public void reportSubscriptionProblem(Coordinator coordinator) throws MoAccessException {
        logger.traceAbnormal(THIS_CLASS, "reportSubscriptionProblem() reported with subscription to positionRef.");
        this.setSubscribingAvc(false);
        this.registerForAVCSubscription();
        logger.traceReturn(THIS_CLASS, "reportSubscriptionProblem()");
    }

    private void registerForAVCSubscription() {
        logger.traceEnter(THIS_CLASS, "registerForAVCSubscription()");
        Runnable handler = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                DeviceGroupMaoImpl.this.startService();
            }
        };
        logger.traceDebug(THIS_CLASS, "Start new thread CRBS_lmCatOamLmU_PostionRef");
        Thread positionRefAVCThread = new Thread(handler, "CRBS_lmCatOamLmU_PostionRef");
        positionRefAVCThread.start();
        logger.traceReturn(THIS_CLASS, "registerForAVCSubscription()");
    }

    public void setSubscribingAvc(boolean isSubscribed) {
        this.m_subscribingAVC = isSubscribed;
    }

    public boolean getSubscribingAvc() {
        return this.m_subscribingAVC;
    }

    private void startService() {
        logger.traceEnter(THIS_CLASS, "startService()");
        while (true) {
            try {
                logger.traceDebug(THIS_CLASS, "Try registerForUpdate...");
                if (this == null) break;
                this.genericMaoContext.getAvcRegistratorFactory().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, this.getParent().getType(), POSITION_REF_ATTR_NAME);
            }
            catch (Exception e) {
                logger.traceDebug(THIS_CLASS, "Node not up, waiting..");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    logger.traceDebug(THIS_CLASS, "Interrupted during sleep");
                }
                continue;
            }
            break;
        }
        logger.traceDebug(THIS_CLASS, "setSubscribingAvc to true...");
        this.setSubscribingAvc(true);
        logger.traceReturn(THIS_CLASS, "startService()");
    }
}

