/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.ima.handler;

import java.io.CharArrayReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.cat.mao.ima.handler.AttributeHolder;
import se.ericsson.crbs.cat.mao.ima.handler.ImaHandlerException;
import se.ericsson.crbs.cat.mao.ima.handler.ImaRequestXmlHandler;
import se.ericsson.crbs.cat.mao.ima.signals.OmfMaoImaNcReadCfmSignal;
import se.ericsson.crbs.cat.mao.ima.signals.OmfMaoImaNcReadReqSignal;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.proxy.AbstractSignalConverter;
import se.ericsson.crbs.omf.common.proxy.SignalHandler;
import se.ericsson.crbs.omf.common.proxy.SignalObject;
import se.ericsson.crbs.omf.mao.genericmo.xml.XmlPack;
import se.ericsson.crbs.omf.mao.genericmo.xml.XmlPackFactoryFactory;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class ImaSignalHandler
implements SignalHandler {
    private static final Class THIS_CLASS = ImaSignalHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String CLASS_TAG = "class";
    public static final int NOT_USED_SERVERREF_VALUE = 43;
    public static final String IMA_VERSION = "R1A";
    private static final String BLANK_STRING = " ";
    private static final String EMPTY_STRING = "";
    private static final String VERSION = "version";
    private static final String LDN = "ldn";
    private static final AttributeHolder[] OMF_MANAGED_ELEMENT_ATTRS = new AttributeHolder[]{new AttributeHolder("logicalName", String.class), new AttributeHolder("userLabel", String.class)};
    private static final AttributeHolder[] OMF_UPGRADE_PACKAGE_ATTRS = new AttributeHolder[]{new AttributeHolder("upgradePackageDocumentId", String.class)};
    private static final AttributeHolder[] OMF_ENODEB_FUNCTION_ATTRS = new AttributeHolder[]{new AttributeHolder("eNBId", Integer.class), new AttributeHolder("eNodeBPlmnId", Struct.class)};
    private static final AttributeHolder[] OMF_CONFIGURATION_VERSION_ATTRS = new AttributeHolder[]{new AttributeHolder("currentUpgradePackage", String.class)};
    private static final AttributeHolder[] NC_MANAGED_ELEMENT_ATTRS = new AttributeHolder[]{new AttributeHolder("productName", String.class), new AttributeHolder("logicalName", String.class)};
    private static final AttributeHolder[] NC_UPGRADE_PACKAGE_ATTRS = OMF_UPGRADE_PACKAGE_ATTRS;
    private static final AttributeHolder[] NC_CONFIGURATION_VERSION_ATTRS = OMF_CONFIGURATION_VERSION_ATTRS;
    private static final AttributeHolder[] NC_EQUIPMENT_SUPPORT_FUNCTION_ATTRS = new AttributeHolder[]{new AttributeHolder("fullDistinguishedName", String.class)};
    private static final AttributeHolder[] UEH_MANAGED_ELEMENT_ATTRS = new AttributeHolder[]{new AttributeHolder("logicalName", String.class)};
    private static final String MANAGED_ELEMENT_LDN = "ManagedElement=1";
    protected static final String UPGRADE_PACKAGE_LDN = "ManagedElement=1,SwManagement=1,UpgradePackage=";
    private static final String CONFIGURATION_VERSION_LDN = "ManagedElement=1,SwManagement=1,ConfigurationVersion=1";
    private static final String ENODEB_FUNCTION_LDN = "ManagedElement=1,ENodeBFunction=1";
    private static final String EQUIPMENT_SUPPORT_FUNCTION_LDN = "ManagedElement=1,EquipmentSupportFunction=1";
    protected static final int NC_REQUEST = 0;
    protected static final int OMF_REQUEST = 1;
    protected static final int UEH_REQUEST = 2;
    protected static final int RAC_SUBSCRIBE_REQUEST = 3;
    protected static final String[] REQUESTER_NAME = new String[]{"NC", "OMF", "UEH", "RAC_SUBSCRIBE"};
    protected static final String[][] VALID_EQUALS_LDNS = new String[][]{{"ManagedElement=1", "ManagedElement=1,SwManagement=1,ConfigurationVersion=1", "ManagedElement=1,EquipmentSupportFunction=1"}, {"ManagedElement=1", "ManagedElement=1,SwManagement=1,ConfigurationVersion=1", "ManagedElement=1,ENodeBFunction=1"}, {"ManagedElement=1"}, {"ManagedElement=1", "ManagedElement=1,ENodeBFunction=1"}};
    private static final String[][] VALID_STARTS_WITH_LDNS = new String[][]{{"ManagedElement=1,SwManagement=1,UpgradePackage="}, {"ManagedElement=1,SwManagement=1,UpgradePackage="}, new String[0], new String[0]};
    private static final String IMA = "ima";
    private final MoRepositoryWrapper moRepositoryWrapper;
    private static final Map[] REQUEST_LDN_ATTRIBUTES_ARRAY = new Map[REQUESTER_NAME.length];

    public ImaSignalHandler(AbstractSignalConverter inputSignalConverter, MoRepositoryWrapper inputMoRepositoryWrapper) {
        this.moRepositoryWrapper = inputMoRepositoryWrapper;
        inputSignalConverter.addSignalHandler((SignalObject)new OmfMaoImaNcReadReqSignal(), (SignalHandler)this);
    }

    public SignalObject request(SignalObject requestSignalObj) {
        logger.traceGeneral(THIS_CLASS, "Received new request signal: " + requestSignalObj);
        SignalObject confirmSignal = null;
        String requestName = "Not set yet";
        try {
            int signalNumber = requestSignalObj.getSignalNumber();
            switch (signalNumber) {
                case 24379908: {
                    requestName = "OMF_MAO_IMA_NC_READ_REQ";
                    confirmSignal = this.handleNcReadRequest(requestSignalObj);
                    break;
                }
                default: {
                    logger.traceAbnormal(THIS_CLASS, "Ignoring unknown signal " + signalNumber);
                    break;
                }
            }
        }
        catch (MoAccessException mae) {
            logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)("Failed to created request: " + requestName), (Throwable)mae));
        }
        return confirmSignal;
    }

    protected SignalObject handleNcReadRequest(SignalObject requestSignalObj) throws MoAccessException {
        OmfMaoImaNcReadReqSignal req = (OmfMaoImaNcReadReqSignal)requestSignalObj;
        OmfMaoImaNcReadCfmSignal cfm = new OmfMaoImaNcReadCfmSignal();
        String xml = this.createResponseXml(0, req.getXml());
        cfm.setXml(xml);
        cfm.setClientRef(req.getClientRef());
        cfm.setServerRef(req.getServerRef());
        return cfm;
    }

    protected String createResponseXml(int requester, String xmlIn) throws MoAccessException {
        logger.traceGeneral(THIS_CLASS, "handleGenericRequest [" + xmlIn + "] from " + requester);
        XmlPack xmlPack = XmlPackFactoryFactory.getXmlPackFactory().getXmlPack();
        Document document = xmlPack.createDocument();
        Element topElement = ImaSignalHandler.createTopElement(document);
        Set ldns = ImaSignalHandler.parseInput(xmlIn);
        ImaSignalHandler.filterLdns(requester, ldns);
        Iterator ldnIter = ldns.iterator();
        while (ldnIter.hasNext()) {
            String ldn = ImaSignalHandler.trimLdn((String)ldnIter.next());
            this.addResponseData(topElement, requester, xmlPack, document, this.moRepositoryWrapper, ldn);
        }
        String retValue = this.createResponse(xmlPack, document);
        logger.traceGeneral(THIS_CLASS, "handleGenericRequest returning [" + retValue + "]");
        return retValue;
    }

    private String createResponse(XmlPack xmlPack, Document document) throws MoAccessException {
        String response = xmlPack.transformDocument(document, false);
        response = StringHelper.replaceInString((String)response, (String)"\n", (String)EMPTY_STRING);
        return response;
    }

    private void addResponseData(Element topElement, int requester, XmlPack xmlPack, Document document, MoRepositoryWrapper moRepositoryWrapper, String ldn) {
        try {
            ManagedObject managedObject = moRepositoryWrapper.lookup(ldn);
            if (managedObject == null) {
                logger.traceError(THIS_CLASS, "Failed " + REQUESTER_NAME[requester] + " request. Mo does not exist for the specified LDN: \"" + ldn + "\"");
            } else {
                AttributeHolder[] attributes = this.getResponseAttributes(requester, ldn);
                this.addResponse(attributes, topElement, managedObject, xmlPack, document);
            }
        }
        catch (MoAccessException mae) {
            logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)("Failed " + REQUESTER_NAME[requester] + " request. Could not get data for LDN, \"" + ldn), (Throwable)mae));
        }
        catch (ImaHandlerException ihe) {
            logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)("Failed " + REQUESTER_NAME[requester] + " request. Could not get data for LDN, \"" + ldn), (Throwable)ihe));
        }
    }

    private AttributeHolder[] getResponseAttributes(int requester, String ldn) {
        Map ldnAttrMap = REQUEST_LDN_ATTRIBUTES_ARRAY[requester];
        Iterator entryIterator = ldnAttrMap.entrySet().iterator();
        AttributeHolder[] attributes = null;
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            String typeLdn = (String)entry.getKey();
            if ((!typeLdn.endsWith("=") || !ldn.startsWith(typeLdn)) && !ldn.equals(typeLdn)) continue;
            attributes = (AttributeHolder[])entry.getValue();
            break;
        }
        return attributes;
    }

    private void addResponse(AttributeHolder[] attributeHolders, Element topElement, ManagedObject managedObject, XmlPack xmlPack, Document document) throws MoAccessException, ImaHandlerException {
        String[] attributeNames = this.getAttributeNames(attributeHolders);
        Element typeElement = ImaSignalHandler.createTypeElement(CLASS_TAG, managedObject.getLocalDistinguishedName(), document);
        topElement.appendChild(typeElement);
        Object[] attrObjects = this.getAttributes(attributeNames, managedObject);
        if (attrObjects != null && attrObjects.length > 0) {
            for (int i = 0; i < attrObjects.length; ++i) {
                if (attrObjects[i] instanceof ManagedObject) {
                    ManagedObject referredManagedObject = (ManagedObject)attrObjects[i];
                    ImaSignalHandler.packHolder(typeElement, xmlPack, document, new AttributeHolder(attributeHolders[i].attributeName, class$java$lang$String == null ? ImaSignalHandler.class$("java.lang.String") : class$java$lang$String), referredManagedObject.getLocalDistinguishedName());
                    continue;
                }
                ImaSignalHandler.packHolder(typeElement, xmlPack, document, attributeHolders[i], attrObjects[i]);
            }
        }
    }

    private String[] getAttributeNames(AttributeHolder[] attributeHolders) {
        String[] attributeNames = new String[attributeHolders.length];
        for (int i = 0; i < attributeHolders.length; ++i) {
            attributeNames[i] = attributeHolders[i].attributeName;
        }
        return attributeNames;
    }

    protected static void packHolder(Element typeElement, XmlPack xmlPack, Document document, AttributeHolder attributeHolder, Object attrObject) throws ImaHandlerException, MoAccessException {
        if (String.class.equals(attributeHolder.attributeClass)) {
            ImaSignalHandler.packString(typeElement, xmlPack, document, attributeHolder.attributeName, attrObject);
        } else if (Integer.class.equals(attributeHolder.attributeClass)) {
            ImaSignalHandler.packInt(typeElement, xmlPack, document, attributeHolder.attributeName, attrObject);
        } else if (Struct.class.equals(attributeHolder.attributeClass)) {
            ImaSignalHandler.packStruct(typeElement, xmlPack, document, attributeHolder.attributeName, attrObject);
        }
    }

    public static void filterLdns(int requester, Set ldns) {
        Iterator ldnsIter = ldns.iterator();
        ArrayList<String> tmpLdns = new ArrayList<String>();
        switch (requester) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                while (ldnsIter.hasNext()) {
                    String receivedLdn = ImaSignalHandler.trimLdn((String)ldnsIter.next());
                    String[] valid_equals_ldns = VALID_EQUALS_LDNS[requester];
                    for (int i = 0; i < valid_equals_ldns.length; ++i) {
                        if (!receivedLdn.equals(valid_equals_ldns[i])) continue;
                        tmpLdns.add(receivedLdn);
                    }
                    String[] valid_starts_with_ldns = VALID_STARTS_WITH_LDNS[requester];
                    for (int i = 0; i < valid_starts_with_ldns.length; ++i) {
                        if (!receivedLdn.startsWith(valid_starts_with_ldns[i])) continue;
                        tmpLdns.add(receivedLdn);
                    }
                }
                break;
            }
            default: {
                logger.traceAbnormal(THIS_CLASS, "Can't filter LDNs for unknown requester " + requester);
            }
        }
        ldns.clear();
        ldns.addAll(tmpLdns);
    }

    public static Set parseInput(String xml) {
        logger.traceEnter(THIS_CLASS, "parseInput()");
        HashSet result = new HashSet();
        Set ldns = null;
        if (xml == null) {
            logger.traceError(THIS_CLASS, "XML parse exception: xml document is null");
        } else {
            try {
                CharArrayReader reader = new CharArrayReader(xml.trim().toCharArray());
                InputSource input = new InputSource(reader);
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                SAXParser saxParser = saxParserFactory.newSAXParser();
                XMLReader parser = saxParser.getXMLReader();
                ImaRequestXmlHandler handler = new ImaRequestXmlHandler();
                parser.setContentHandler(handler);
                parser.setErrorHandler(handler);
                parser.parse(input);
                ldns = handler.getLdns();
                result.addAll(ldns);
            }
            catch (Exception e) {
                logger.traceError(THIS_CLASS, "XML parse exception: " + e.toString());
            }
        }
        logger.traceReturn(THIS_CLASS, "parseInput()");
        return result;
    }

    protected Object getAttribute(String attrName, ManagedObject managedObject) throws MoAccessException, ImaHandlerException {
        Object attrObject = managedObject.getAttribute(attrName, null);
        if (attrObject == null) {
            throw new ImaHandlerException("Attribute, " + attrName + ", not found");
        }
        return attrObject;
    }

    protected Object[] getAttributes(String[] attrNames, ManagedObject managedObject) throws MoAccessException, ImaHandlerException {
        Object[] attrObjects = managedObject.getAttributes(attrNames, null);
        if (attrObjects == null) {
            ArrayList<String> toStringList = new ArrayList<String>();
            toStringList.addAll(Arrays.asList(attrNames));
            throw new ImaHandlerException("Attributes, " + toStringList + ", not found");
        }
        if (attrObjects.length == attrNames.length) {
            for (int i = 0; i < attrObjects.length; ++i) {
                if (attrObjects[i] != null) continue;
                throw new ImaHandlerException("Attribute, [" + attrNames[i] + "], not found");
            }
        } else {
            throw new ImaHandlerException("Data inconsistent. Asked for " + attrNames.length + " but got " + attrObjects.length + " attributes from getAttributes()");
        }
        return attrObjects;
    }

    protected static void packInt(Element typeElement, XmlPack xmlPack, Document document, String attrName, Object objToBeConverted) throws ImaHandlerException, MoAccessException {
        if (!(objToBeConverted instanceof Integer)) {
            throw new ImaHandlerException(attrName + " is not an Integer");
        }
        Element element = xmlPack.packInt(attrName, objToBeConverted, document);
        typeElement.appendChild(element);
    }

    protected static void packString(Element typeElement, XmlPack xmlPack, Document document, String attrName, Object objToBeConverted) throws ImaHandlerException, MoAccessException {
        if (!(objToBeConverted instanceof String)) {
            throw new ImaHandlerException(attrName + " is not a String");
        }
        Element element = xmlPack.packString(attrName, objToBeConverted, document);
        typeElement.appendChild(element);
    }

    protected static void packStruct(Element typeElement, XmlPack xmlPack, Document document, String attrName, Object objToBeConverted) throws ImaHandlerException, MoAccessException {
        if (!(objToBeConverted instanceof Struct)) {
            throw new ImaHandlerException(attrName + " is not a Struct");
        }
        Element element = xmlPack.packStruct(attrName, (Struct)objToBeConverted, document);
        typeElement.appendChild(element);
    }

    protected static Element createTopElement(Document document) {
        Element topElement = document.createElement(IMA);
        topElement.setAttribute(VERSION, IMA_VERSION);
        document.appendChild(topElement);
        return topElement;
    }

    protected static Element createTypeElement(String type, String ldn, Document document) {
        Element typeElement = document.createElement(type);
        typeElement.setAttribute(LDN, ldn);
        return typeElement;
    }

    protected UpgradePackageMo convertAttributeToUpgradePackageMo(String attrName, Object objToBeConverted) throws ImaHandlerException {
        if (objToBeConverted instanceof UpgradePackageMo) {
            return (UpgradePackageMo)objToBeConverted;
        }
        throw new ImaHandlerException(attrName + " is not an UpgradePackageMo");
    }

    protected static String trimLdn(String ldnToBeTrimmed) {
        return StringHelper.replaceInString((String)ldnToBeTrimmed, (String)BLANK_STRING, (String)EMPTY_STRING);
    }

    static {
        HashMap<String, AttributeHolder[]> ncMap = new HashMap<String, AttributeHolder[]>();
        ncMap.put(MANAGED_ELEMENT_LDN, NC_MANAGED_ELEMENT_ATTRS);
        ncMap.put(CONFIGURATION_VERSION_LDN, NC_CONFIGURATION_VERSION_ATTRS);
        ncMap.put(UPGRADE_PACKAGE_LDN, NC_UPGRADE_PACKAGE_ATTRS);
        ncMap.put(EQUIPMENT_SUPPORT_FUNCTION_LDN, NC_EQUIPMENT_SUPPORT_FUNCTION_ATTRS);
        HashMap<String, AttributeHolder[]> omfMap = new HashMap<String, AttributeHolder[]>();
        omfMap.put(MANAGED_ELEMENT_LDN, OMF_MANAGED_ELEMENT_ATTRS);
        omfMap.put(CONFIGURATION_VERSION_LDN, OMF_CONFIGURATION_VERSION_ATTRS);
        omfMap.put(ENODEB_FUNCTION_LDN, OMF_ENODEB_FUNCTION_ATTRS);
        omfMap.put(UPGRADE_PACKAGE_LDN, OMF_UPGRADE_PACKAGE_ATTRS);
        HashMap<String, AttributeHolder[]> uehMap = new HashMap<String, AttributeHolder[]>();
        uehMap.put(MANAGED_ELEMENT_LDN, UEH_MANAGED_ELEMENT_ATTRS);
        HashMap<String, AttributeHolder[]> racMap = new HashMap<String, AttributeHolder[]>();
        racMap.put(MANAGED_ELEMENT_LDN, OMF_MANAGED_ELEMENT_ATTRS);
        racMap.put(ENODEB_FUNCTION_LDN, OMF_ENODEB_FUNCTION_ATTRS);
        ImaSignalHandler.REQUEST_LDN_ATTRIBUTES_ARRAY[0] = ncMap;
        ImaSignalHandler.REQUEST_LDN_ATTRIBUTES_ARRAY[1] = omfMap;
        ImaSignalHandler.REQUEST_LDN_ATTRIBUTES_ARRAY[2] = uehMap;
        ImaSignalHandler.REQUEST_LDN_ATTRIBUTES_ARRAY[3] = racMap;
    }
}

