/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.ima.signals;

import enea.ose.io.SignalInputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class AbstractOmfMaoImaReadReqOseSignal
extends UnlinkedSignal {
    private static final Class THIS_CLASS = AbstractOmfMaoImaReadReqOseSignal.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected String data;
    protected int clientRef;
    protected int serverRef;

    public AbstractOmfMaoImaReadReqOseSignal(int inputSigNo) {
        super(inputSigNo);
    }

    protected void initReceive() {
        SignalInputStream sis = this.getTheSignalInputStream();
        try {
            int toRead;
            int noOfReadBytes;
            this.clientRef = sis.readS32();
            this.serverRef = sis.readS32();
            int sizeOfData = sis.readS32();
            byte[] buffer = new byte[sizeOfData];
            int offset = 0;
            for (toRead = sizeOfData; toRead > 0; toRead -= noOfReadBytes) {
                noOfReadBytes = sis.read(buffer, offset, toRead);
                if (noOfReadBytes == -1) {
                    logger.traceError(THIS_CLASS, toRead + " bytes left to read from signal data but got EOF");
                    break;
                }
                offset += noOfReadBytes;
            }
            if (toRead <= 0) {
                this.data = new String(buffer, 0, offset);
                logger.traceGeneral(THIS_CLASS, "Read data [" + this.data + "]");
            } else {
                logger.traceError(THIS_CLASS, "Read only " + offset + " bytes of requested " + sizeOfData);
            }
        }
        catch (IOException e) {
            logger.traceError(THIS_CLASS, "Can't read signal data" + e.toString());
        }
    }

    protected SignalInputStream getTheSignalInputStream() {
        return super.getSignalInputStream();
    }

    protected void initSend() {
        logger.traceError(THIS_CLASS, "initSend is not implemented");
    }

    public String getData() {
        return this.data;
    }

    public int getClientRef() {
        return this.clientRef;
    }

    public int getServerRef() {
        return this.serverRef;
    }

    public void setServerRef(int inputServerRef) {
        this.serverRef = inputServerRef;
    }
}

