/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import se.ericsson.cello.equipment.GenericProgramBase;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.LoadModuleMo;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.auxpluginunit.AuxPlugInUnitMao;
import se.ericsson.crbs.cat.mao.auxpluginunit.CompatibilityListSwMatcher;
import se.ericsson.crbs.cat.mao.auxpluginunit.HwCompatibilityChecker;
import se.ericsson.crbs.cat.mao.auxpluginunit.RevisionHolder;
import se.ericsson.crbs.cat.mao.auxpluginunit.SwMatchingException;
import se.ericsson.crbs.cat.mao.mohandler.program.RuProgramMoHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuIncompatibleHwHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuIncompatibleHwHandlerFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuIncorrectCompatibilityListHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuIncorrectCompatibilityListHandlerFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuNoMatchHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuNoMatchHandlerFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuPreInstalledSwHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuPreInstalledSwHandlerFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuRunningSwHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuRunningSwHandlerFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuSwOnDuHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuSwOnDuHandlerFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.SwAllocationHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.SwAllocationHandlerFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.LoadModuleHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.LoadModuleHelperFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.PiuTypeHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.PiuTypeHelperFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.ProductNumberHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.XpProgramHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.XpProgramHelperFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.LmcListHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RuDataHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.SwCompatibilityListHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.SwCompatibilityListXmlParser;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class RuProgramMoHandlerImpl
implements RuProgramMoHandler {
    private static final Class THIS_CLASS = RuProgramMoHandlerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String SIMPLE_DATE_STRING = "yyyyMMdd";
    private final AuxPlugInUnitMao auxPlugInUnitMao;
    private final GenericMaoContext genericMaoContext;
    private LoadModuleMoSU_Access loadModuleMo = null;
    private GenericProgramBase xpProgramMo = null;
    private int ruSwResult = 1;
    private boolean preInstalledUsed = false;
    private boolean runningSwIndicated = false;
    private boolean runningSwUsed = false;
    private String lmFilePath = "";
    private final PiuTypeHelper piuTypeHelper;
    private final LoadModuleHelper loadModuleHelper;
    private final XpProgramHelper xpProgramHelper;
    private final RuHandlersHolder ruHandlersHolder;

    public RuProgramMoHandlerImpl(AuxPlugInUnitMao theAuxPlugInUnitMao, GenericMaoContext theGenericMaoContext) {
        logger.traceDebug(THIS_CLASS, "ProgramMoHandler(" + theAuxPlugInUnitMao + ")");
        this.auxPlugInUnitMao = theAuxPlugInUnitMao;
        this.genericMaoContext = theGenericMaoContext;
        this.ruHandlersHolder = new RuHandlersHolder(theAuxPlugInUnitMao, theGenericMaoContext);
        this.piuTypeHelper = PiuTypeHelperFactory.getInstance().getPiuTypeHelper();
        this.loadModuleHelper = LoadModuleHelperFactory.getInstance().getLoadModuleHelper(theAuxPlugInUnitMao, theGenericMaoContext);
        this.xpProgramHelper = XpProgramHelperFactory.getInstance().getXpProgramHelper(theAuxPlugInUnitMao, theGenericMaoContext);
    }

    public int getRuSwResult() {
        logger.traceGeneral(THIS_CLASS, "getRuSwResult() returned: " + RuProgramMoHandler.RU_SW_RESULT_STRINGS[this.ruSwResult]);
        return this.ruSwResult;
    }

    public String getLmFilePath() {
        logger.traceGeneral(THIS_CLASS, "getLmFilePath() returned: \"" + this.lmFilePath + "\"");
        return this.lmFilePath;
    }

    public boolean isPreInstalledUsed() {
        logger.traceGeneral(THIS_CLASS, "preInstalled = \"" + this.preInstalledUsed + "\"");
        return this.preInstalledUsed;
    }

    public boolean isRunningSwUsed() {
        logger.traceGeneral(THIS_CLASS, "runningSw = \"" + this.runningSwUsed + "\"");
        return this.runningSwUsed;
    }

    protected boolean isRunningSwIndicated() {
        return this.runningSwIndicated;
    }

    public LoadModuleMoSU_Access getLoadModuleMo() {
        return this.loadModuleMo;
    }

    public GenericProgramBase getXpProgramMo() {
        return this.xpProgramMo;
    }

    public PiuTypeMoSU_Access reconfigurePrograms(PiuTypeAccess currentPiuType, boolean triggeredFromNodeControl, RuDataHolder ruDataHolder, String swCompatibilityListXml, String runningLmcInfoXml, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "reconfigurePrograms()");
        boolean needToReconfigurePrograms = true;
        this.lmFilePath = "";
        this.preInstalledUsed = false;
        this.runningSwUsed = false;
        this.runningSwIndicated = this.isRunningLmcInfoSpecified(runningLmcInfoXml, swCompatibilityListXml, ruDataHolder, coordinator);
        logger.traceGeneral(THIS_CLASS, "runningSwIndicated: " + this.runningSwIndicated);
        PiuTypeMoSU_Access piuTypeMo = this.piuTypeHelper.getPiuTypeForHwPid(ruDataHolder, this.genericMaoContext);
        while (needToReconfigurePrograms) {
            needToReconfigurePrograms = false;
            if (piuTypeMo == null) {
                logger.traceGeneral(THIS_CLASS, "No PiuType found for RU HW PID: " + ruDataHolder.getHwPidString());
                logger.traceGeneral(THIS_CLASS, "Will look for a genric PiuType instead");
                piuTypeMo = this.tryGenericPiuType(currentPiuType, ruDataHolder, swCompatibilityListXml, runningLmcInfoXml, coordinator);
                continue;
            }
            if (HwCompatibilityChecker.checkHwIncompatibility((PiuTypeMo)currentPiuType, (PiuTypeMo)piuTypeMo, coordinator)) {
                logger.traceGeneral(THIS_CLASS, "Incompatible PiuTypes detected for known PiuType.");
                this.makeSureSwAllocationAndRepertoireAreAvailable(coordinator, piuTypeMo);
                this.handleIncompatiblePiuTypes(ruDataHolder, coordinator);
                piuTypeMo = (PiuTypeMoSU_Access)currentPiuType;
                continue;
            }
            if (this.inExceptionList(ruDataHolder) || swCompatibilityListXml.equals("NoCoMpAtIbIlItYlIsTsPeCiFiEd")) {
                this.makeSureSwAllocationAndRepertoireAreAvailable(coordinator, piuTypeMo);
                LoadModuleMoSU_Access localLoadModuleMo = this.loadModuleHelper.getInstalledLoadModuleMo(piuTypeMo, coordinator);
                this.ruSwResult = triggeredFromNodeControl ? 1 : 0;
                this.ruHandlersHolder.getRuSwOnDuHandler().handleSwOnDu(localLoadModuleMo, ruDataHolder, coordinator);
                this.loadModuleMo = this.ruHandlersHolder.getRuSwOnDuHandler().getLoadModuleMo();
                this.xpProgramMo = this.ruHandlersHolder.getRuSwOnDuHandler().getXpProgramMo();
                this.preInstalledUsed = this.ruHandlersHolder.getRuSwOnDuHandler().isPreInstalledUsed();
                continue;
            }
            if (this.runningSwIndicated) {
                this.makeSureSwAllocationAndRepertoireAreAvailable(coordinator, piuTypeMo);
                needToReconfigurePrograms = this.handleRunningLmcInfo(piuTypeMo, ruDataHolder, swCompatibilityListXml, runningLmcInfoXml, coordinator);
                continue;
            }
            this.makeSureSwAllocationAndRepertoireAreAvailable(coordinator, piuTypeMo);
            this.handleCompatibilityList(ruDataHolder, swCompatibilityListXml, coordinator, piuTypeMo);
        }
        if (this.isLmFilePathNeeded()) {
            this.lmFilePath = this.loadModuleMo.getRealLoadModuleFilePath(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "reconfigurePrograms()");
        return piuTypeMo;
    }

    private boolean inExceptionList(RuDataHolder ruDataHolder) {
        List temp;
        HashMap<String, List> products = new HashMap<String, List>();
        products.put("KRC11865/1", this.addExceptionalProductRevisions(new String[]{"R1F/", "R1D/"}));
        products.put("KRC11866/1", this.addExceptionalProductRevisions(new String[]{"R1B/"}));
        products.put("KRC11873/1", this.addExceptionalProductRevisions(new String[]{"R1D/"}));
        products.put("KRC11877/1", this.addExceptionalProductRevisions(new String[]{"R1F/", "R1H/"}));
        products.put("KRC11891/1", this.addExceptionalProductRevisions(new String[]{"R1C/"}));
        products.put("KRC161241/1", this.addExceptionalProductRevisions(new String[]{"R1F/", "R2A/"}));
        products.put("KRC161253/1", this.addExceptionalProductRevisions(new String[]{"R1G/", "R1A/"}));
        boolean hit = false;
        if (products.containsKey(ruDataHolder.getProductNumber()) && (temp = (List)products.get(ruDataHolder.getProductNumber())) != null && temp.size() != 0 && temp.contains(ruDataHolder.getProductRevision())) {
            hit = true;
        }
        return hit;
    }

    private List addExceptionalProductRevisions(String[] strings) {
        List<String> temp = Arrays.asList(strings);
        return temp;
    }

    private boolean isLmFilePathNeeded() {
        return this.loadModuleMo != null && "".equalsIgnoreCase(this.lmFilePath) && this.ruSwResult != 3;
    }

    private PiuTypeMoSU_Access tryGenericPiuType(PiuTypeAccess currentPiuType, RuDataHolder ruDataHolder, String swCompatibilityListXml, String runningLmcInfoXml, Coordinator coordinator) throws MoAccessException {
        PiuTypeMoSU_Access piuTypeMo;
        this.ruSwResult = 1;
        PiuTypeMoSU_Access genericPiuTypeMo = this.piuTypeHelper.getGenericPiuTypeForHwPid(ruDataHolder, this.genericMaoContext);
        if (genericPiuTypeMo == null) {
            this.ruHandlersHolder.getRuNoMatchHandler().handleNoMatch(ruDataHolder, coordinator);
            this.loadModuleMo = this.ruHandlersHolder.getRuNoMatchHandler().getLoadModuleMo();
            this.xpProgramMo = this.ruHandlersHolder.getRuNoMatchHandler().getXpProgramMo();
            this.preInstalledUsed = this.ruHandlersHolder.getRuNoMatchHandler().isPreInstalledUsed();
            piuTypeMo = (PiuTypeMoSU_Access)currentPiuType;
        } else {
            piuTypeMo = this.handleGenericPiuType((PiuTypeMoSU_Access)currentPiuType, genericPiuTypeMo, ruDataHolder, runningLmcInfoXml, swCompatibilityListXml, coordinator);
        }
        return piuTypeMo;
    }

    private boolean isRunningLmcInfoSpecified(String runningLmcInfoXml, String swCompatibilityListXml, RuDataHolder ruDataHolder, Coordinator coordinator) throws SwMatchingException, MoAccessException {
        boolean compListPresent;
        boolean isRunningLmcInfoSpecified = false;
        boolean runningSwPresent = !"NoRuNnInGLmCiNfOsPeCiFiEd".equals(runningLmcInfoXml);
        boolean bl = compListPresent = !swCompatibilityListXml.equals("NoCoMpAtIbIlItYlIsTsPeCiFiEd");
        if (runningSwPresent && compListPresent) {
            SwCompatibilityListXmlParser swCompatibilityListXmlParser = new SwCompatibilityListXmlParser();
            swCompatibilityListXmlParser.parse(swCompatibilityListXml);
            SwCompatibilityListHolder swCompatibilityListHolder = swCompatibilityListXmlParser.getSwCompatibilityListHolder();
            if (swCompatibilityListHolder.isCompatibilityListCorrect()) {
                LmcListHolder runningLmcListHolder = swCompatibilityListHolder.getRunningSw(runningLmcInfoXml);
                String runningProductNumber = ProductNumberHelper.normalize(runningLmcListHolder.getProductNumber());
                String runningProductRevision = ProductNumberHelper.normalize(runningLmcListHolder.getProductRevision());
                LmcListHolder preinstalledLmcListHolder = swCompatibilityListHolder.getPreInstalledSw();
                isRunningLmcInfoSpecified = true;
                if (preinstalledLmcListHolder != null) {
                    String preinstalledProductNumber = ProductNumberHelper.normalize(preinstalledLmcListHolder.getProductNumber());
                    String preinstalledProductRevision = ProductNumberHelper.normalize(preinstalledLmcListHolder.getProductRevision());
                    boolean runningSameAsPreinstalled = runningProductNumber.equalsIgnoreCase(preinstalledProductNumber) && runningProductRevision.equalsIgnoreCase(preinstalledProductRevision);
                    isRunningLmcInfoSpecified = !runningSameAsPreinstalled && runningSwPresent;
                }
            } else {
                this.ruSwResult = 2;
                logger.traceGeneral(THIS_CLASS, "Compatibility list is faulty: \"" + swCompatibilityListXml + "\"");
                this.ruHandlersHolder.getRuIncorrectCompatibilityListHandler().handleIncorrectCompatibilityList(ruDataHolder, coordinator);
                this.loadModuleMo = this.ruHandlersHolder.getRuIncorrectCompatibilityListHandler().getLoadModuleMo();
                this.xpProgramMo = this.ruHandlersHolder.getRuIncorrectCompatibilityListHandler().getXpProgramMo();
                this.preInstalledUsed = this.ruHandlersHolder.getRuIncorrectCompatibilityListHandler().isPreInstalledUsed();
            }
        }
        return isRunningLmcInfoSpecified;
    }

    private void handleCompatibilityList(RuDataHolder ruDataHolder, String swCompatibilityListXml, Coordinator coordinator, PiuTypeMoSU_Access piuTypeMo) throws MoAccessException {
        SwCompatibilityListXmlParser swCompatibilityListXmlParser = new SwCompatibilityListXmlParser();
        swCompatibilityListXmlParser.parse(swCompatibilityListXml);
        SwCompatibilityListHolder swCompatibilityListHolder = swCompatibilityListXmlParser.getSwCompatibilityListHolder();
        if (swCompatibilityListHolder.isCompatibilityListCorrect()) {
            this.ruSwResult = 1;
            this.handleCorrectCompatibilityList(piuTypeMo, swCompatibilityListHolder, ruDataHolder, coordinator);
        } else {
            this.ruSwResult = 2;
            logger.traceGeneral(THIS_CLASS, "Compatibility list is faulty: \"" + swCompatibilityListXml + "\"");
            this.ruHandlersHolder.getRuIncorrectCompatibilityListHandler().handleIncorrectCompatibilityList(ruDataHolder, coordinator);
            this.loadModuleMo = this.ruHandlersHolder.getRuIncorrectCompatibilityListHandler().getLoadModuleMo();
            this.xpProgramMo = this.ruHandlersHolder.getRuIncorrectCompatibilityListHandler().getXpProgramMo();
            this.preInstalledUsed = this.ruHandlersHolder.getRuIncorrectCompatibilityListHandler().isPreInstalledUsed();
        }
    }

    private void handleIncompatiblePiuTypes(RuDataHolder ruDataHolder, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleIncompatiblePiuTypes()");
        this.ruSwResult = 2;
        this.ruHandlersHolder.getRuIncompatibleHwHandler().handleIncompatibleHw(ruDataHolder, coordinator);
        this.loadModuleMo = this.ruHandlersHolder.getRuIncompatibleHwHandler().getLoadModuleMo();
        this.xpProgramMo = this.ruHandlersHolder.getRuIncompatibleHwHandler().getXpProgramMo();
        logger.traceReturn(THIS_CLASS, "handleIncompatiblePiuTypes()");
    }

    public void removeDisabledPrograms(boolean readLockNeeded, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "removeDisabledPrograms()");
        this.xpProgramHelper.deleteDisabledPrograms(readLockNeeded, localCoordinator);
        logger.traceReturn(THIS_CLASS, "removeDisabledPrograms()");
    }

    private PiuTypeMoSU_Access handleGenericPiuType(PiuTypeMoSU_Access currentPiuType, PiuTypeMoSU_Access genericPiuType, RuDataHolder ruDataHolder, String runningLmcInfoXml, String swCompatibilityListXml, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleGenericPiuType()");
        PiuTypeMoSU_Access piuType = genericPiuType;
        this.makeSureSwAllocationAndRepertoireAreAvailable(localCoordinator, genericPiuType);
        SwCompatibilityListXmlParser swCompatibilityListXmlParser = new SwCompatibilityListXmlParser();
        swCompatibilityListXmlParser.parse(swCompatibilityListXml);
        SwCompatibilityListHolder swCompatibilityListHolder = swCompatibilityListXmlParser.getSwCompatibilityListHolder();
        boolean compatibilityListCorrect = swCompatibilityListXmlParser.getSwCompatibilityListHolder().isCompatibilityListCorrect();
        if (HwCompatibilityChecker.checkHwIncompatibility((PiuTypeMo)currentPiuType, (PiuTypeMo)genericPiuType, localCoordinator)) {
            logger.traceGeneral(THIS_CLASS, "Incompatible PiuTypes detected for Generic PiuType");
            this.handleIncompatiblePiuTypes(ruDataHolder, localCoordinator);
            piuType = currentPiuType;
        } else if (compatibilityListCorrect && this.runningSwIndicated) {
            logger.traceGeneral(THIS_CLASS, "Running SW indicated for Generic PiuType");
            LmcListHolder runningLmcListHolder = swCompatibilityListHolder.getRunningSw(runningLmcInfoXml);
            this.ruHandlersHolder.getRuRunningSwHandler().handleRunningSwLikePreInstalledSw(runningLmcListHolder, ruDataHolder, localCoordinator);
            this.loadModuleMo = this.ruHandlersHolder.getRuRunningSwHandler().getLoadModuleMo();
            this.xpProgramMo = this.ruHandlersHolder.getRuRunningSwHandler().getXpProgramMo();
            this.preInstalledUsed = false;
            this.runningSwUsed = true;
        } else if (compatibilityListCorrect && swCompatibilityListHolder.isPreInstalledSupported()) {
            logger.traceGeneral(THIS_CLASS, "Pre-installed SW indicated for Generic PiuType");
            LmcListHolder preInstalledLmcListHolder = swCompatibilityListHolder.getPreInstalledSw();
            this.ruHandlersHolder.getRuPreInstalledSwHandler().handlePreInstalledSw(true, preInstalledLmcListHolder, ruDataHolder, localCoordinator);
            this.loadModuleMo = this.ruHandlersHolder.getRuPreInstalledSwHandler().getLoadModuleMo();
            this.xpProgramMo = this.ruHandlersHolder.getRuPreInstalledSwHandler().getXpProgramMo();
            this.preInstalledUsed = this.ruHandlersHolder.getRuPreInstalledSwHandler().isPreInstalledUsed();
            this.runningSwUsed = false;
        } else if (compatibilityListCorrect) {
            logger.traceGeneral(THIS_CLASS, "Generic PiuType, but no running nor pre-installed SW available");
            this.ruHandlersHolder.getRuNoMatchHandler().handleNoMatch(ruDataHolder, localCoordinator);
            this.loadModuleMo = this.ruHandlersHolder.getRuNoMatchHandler().getLoadModuleMo();
            this.xpProgramMo = this.ruHandlersHolder.getRuNoMatchHandler().getXpProgramMo();
            this.preInstalledUsed = this.ruHandlersHolder.getRuNoMatchHandler().isPreInstalledUsed();
            this.runningSwUsed = false;
        } else {
            this.ruSwResult = 2;
            logger.traceGeneral(THIS_CLASS, "Compatibility list is faulty: \"" + swCompatibilityListXml + "\"");
            this.ruHandlersHolder.getRuIncorrectCompatibilityListHandler().handleIncorrectCompatibilityList(ruDataHolder, localCoordinator);
            this.loadModuleMo = this.ruHandlersHolder.getRuIncorrectCompatibilityListHandler().getLoadModuleMo();
            this.xpProgramMo = this.ruHandlersHolder.getRuIncorrectCompatibilityListHandler().getXpProgramMo();
            this.preInstalledUsed = this.ruHandlersHolder.getRuIncorrectCompatibilityListHandler().isPreInstalledUsed();
            this.runningSwUsed = false;
        }
        logger.traceReturn(THIS_CLASS, "handleGenericPiuType()");
        return piuType;
    }

    private void handleCorrectCompatibilityList(PiuTypeMoSU_Access piuTypeMo, SwCompatibilityListHolder swCompatibilityListHolder, RuDataHolder ruDataHolder, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleCorrectCompatibilityList()");
        if (swCompatibilityListHolder.isPreInstalledSupported()) {
            LmcListHolder preInstalledLmcListHolder = swCompatibilityListHolder.getPreInstalledSw();
            this.handleKnownPiuTypePreInstalled(piuTypeMo, preInstalledLmcListHolder, ruDataHolder, localCoordinator);
        } else {
            LoadModuleMoSU_Access localLoadModuleMo = this.loadModuleHelper.getInstalledLoadModuleMo(piuTypeMo, localCoordinator);
            this.ruHandlersHolder.getRuSwOnDuHandler().handleSwOnDu(localLoadModuleMo, ruDataHolder, localCoordinator);
            this.loadModuleMo = this.ruHandlersHolder.getRuSwOnDuHandler().getLoadModuleMo();
            this.xpProgramMo = this.ruHandlersHolder.getRuSwOnDuHandler().getXpProgramMo();
            this.preInstalledUsed = this.ruHandlersHolder.getRuSwOnDuHandler().isPreInstalledUsed();
        }
        logger.traceReturn(THIS_CLASS, "handleCorrectCompatibilityList()");
    }

    private void handleKnownPiuTypePreInstalled(PiuTypeMoSU_Access piuTypeMo, LmcListHolder preInstalledLmcListHolder, RuDataHolder ruDataHolder, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleKnownPiuTypePreInstalled()");
        piuTypeMo.getProgramConfiguration(localCoordinator);
        LoadModuleMoSU_Access localLoadModuleMo = this.loadModuleHelper.getInstalledLoadModuleMo(piuTypeMo, localCoordinator);
        Struct loadModuleProductData = localLoadModuleMo.getProductData(localCoordinator);
        int matchingResult = CompatibilityListSwMatcher.matchAgainstLm(loadModuleProductData, preInstalledLmcListHolder);
        this.preInstalledUsed = false;
        this.runningSwUsed = false;
        switch (matchingResult) {
            case 1: {
                this.preInstalledUsed = true;
                this.ruHandlersHolder.getRuPreInstalledSwHandler().handlePreInstalledSw(false, preInstalledLmcListHolder, ruDataHolder, localCoordinator);
                this.loadModuleMo = this.ruHandlersHolder.getRuPreInstalledSwHandler().getLoadModuleMo();
                this.xpProgramMo = this.ruHandlersHolder.getRuPreInstalledSwHandler().getXpProgramMo();
                this.preInstalledUsed = this.ruHandlersHolder.getRuPreInstalledSwHandler().isPreInstalledUsed();
                break;
            }
            case 2: {
                this.ruHandlersHolder.getRuSwOnDuHandler().handleSwOnDu(localLoadModuleMo, ruDataHolder, localCoordinator);
                this.loadModuleMo = this.ruHandlersHolder.getRuSwOnDuHandler().getLoadModuleMo();
                this.xpProgramMo = this.ruHandlersHolder.getRuSwOnDuHandler().getXpProgramMo();
                this.preInstalledUsed = this.ruHandlersHolder.getRuSwOnDuHandler().isPreInstalledUsed();
                break;
            }
            case 0: {
                this.ruHandlersHolder.getRuNoMatchHandler().handleNoMatch(ruDataHolder, localCoordinator);
                this.loadModuleMo = this.ruHandlersHolder.getRuNoMatchHandler().getLoadModuleMo();
                this.xpProgramMo = this.ruHandlersHolder.getRuNoMatchHandler().getXpProgramMo();
                this.preInstalledUsed = this.ruHandlersHolder.getRuNoMatchHandler().isPreInstalledUsed();
                break;
            }
            default: {
                logger.traceError(THIS_CLASS, "Unknown matching result: " + matchingResult);
            }
        }
        logger.traceReturn(THIS_CLASS, "handleKnownPiuTypePreInstalled()");
    }

    private boolean handleRunningLmcInfo(PiuTypeMoSU_Access piuTypeMo, RuDataHolder ruDataHolder, String swCompatibilityListXml, String runningLmcInfoXml, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleRunningLmcInfo()");
        boolean needToRecofigurePrograms = false;
        LmcListHolder runningLmcListHolder = null;
        SwCompatibilityListXmlParser swCompatibilityListXmlParser = new SwCompatibilityListXmlParser();
        swCompatibilityListXmlParser.parse(swCompatibilityListXml);
        SwCompatibilityListHolder swCompatibilityListHolder = swCompatibilityListXmlParser.getSwCompatibilityListHolder();
        try {
            runningLmcListHolder = swCompatibilityListHolder.getRunningSw(runningLmcInfoXml);
            this.handleFoundRunningLmcInfo(runningLmcListHolder, piuTypeMo, ruDataHolder, swCompatibilityListHolder, localCoordinator);
        }
        catch (SwMatchingException sme) {
            this.runningSwIndicated = false;
            needToRecofigurePrograms = true;
            logger.traceGeneral(THIS_CLASS, "The compability list did not match the running LMC. The running LMC info will be removed.");
            logger.traceGeneral(THIS_CLASS, "runningSwIndicated: " + this.runningSwIndicated);
        }
        logger.traceReturn(THIS_CLASS, "handleRunningLmcInfo()");
        return needToRecofigurePrograms;
    }

    private void handleFoundRunningLmcInfo(LmcListHolder runningLmcListHolder, PiuTypeMoSU_Access piuTypeMo, RuDataHolder ruDataHolder, SwCompatibilityListHolder swCompatibilityListHolder, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleFoundRunningLmcInfo()");
        piuTypeMo.getProgramConfiguration(localCoordinator);
        LoadModuleMoSU_Access localLoadModuleMo = this.loadModuleHelper.getInstalledLoadModuleMo(piuTypeMo, localCoordinator);
        Struct loadModuleProductData = localLoadModuleMo.getProductData(localCoordinator);
        String runningProductNumber = ProductNumberHelper.convertProductNumber(runningLmcListHolder.getProductNumber());
        String runningProductRevision = runningLmcListHolder.getProductRevision();
        String swOnDuProductNumber = ProductNumberHelper.convertProductNumber(loadModuleProductData.getValue("productNumber").toString());
        String swOnDuProductRevison = loadModuleProductData.getValue("productRevision").toString();
        LmcListHolder duSwLmcListHolder = this.ruLmOnDuPresentInCompatibilityList(swOnDuProductNumber, swOnDuProductRevison, swCompatibilityListHolder);
        boolean duSwPresentInCompatibilityList = duSwLmcListHolder != null;
        boolean isProductNumberSame = runningProductNumber.equalsIgnoreCase(swOnDuProductNumber);
        this.runningSwUsed = false;
        this.lmFilePath = "";
        logger.traceDebug(THIS_CLASS, "Handling radio with already running software. \nRunning Software on RU:  " + runningProductNumber + "-" + runningProductRevision + "\n" + "Delieved Software on DU: " + swOnDuProductNumber + "-" + swOnDuProductRevison);
        if (isProductNumberSame) {
            this.handleRunningWithSameProductNumber(runningLmcListHolder, ruDataHolder, localCoordinator, localLoadModuleMo, loadModuleProductData, duSwLmcListHolder, duSwPresentInCompatibilityList);
        } else {
            this.handleRunningWithOtherProductNumber(runningLmcListHolder, ruDataHolder, localCoordinator, localLoadModuleMo, loadModuleProductData, duSwLmcListHolder, duSwPresentInCompatibilityList);
        }
        logger.traceReturn(THIS_CLASS, "handleFoundRunningLmcInfo()");
    }

    private void handleRunningWithOtherProductNumber(LmcListHolder runningLmcListHolder, RuDataHolder ruDataHolder, Coordinator localCoordinator, LoadModuleMoSU_Access localLoadModuleMo, Struct loadModuleProductData, LmcListHolder duSwLmcListHolder, boolean duSwPresentInCompatibilityList) throws MoAccessException {
        logger.traceDebug(THIS_CLASS, "Product numbers differ between RU and DU.");
        String runningProductNumber = ProductNumberHelper.convertProductNumber(runningLmcListHolder.getProductNumber());
        String runningProductRevision = runningLmcListHolder.getProductRevision();
        String swOnDuProductNumber = ProductNumberHelper.convertProductNumber(loadModuleProductData.getValue("productNumber").toString());
        String swOnDuProductRevison = loadModuleProductData.getValue("productRevision").toString();
        RuHandler ruHandlerUsed = null;
        if (CompatibilityListSwMatcher.isProductNumberAndRevisonCompatibleWithLmc(swOnDuProductNumber, swOnDuProductRevison, runningLmcListHolder)) {
            logger.traceDebug(THIS_CLASS, "Software on RU is compatible with DU, keeping the running SW.");
            logger.info(THIS_CLASS, "For the radio with LDN \"" + ruDataHolder.getLdn() + "\", the running radio software " + runningProductNumber + "_" + runningProductRevision + " is compatible with the system desired one " + swOnDuProductNumber + "_" + swOnDuProductRevison);
            this.ruHandlersHolder.getRuRunningSwHandler().handleRunningSwChangedProductNumber(true, ruDataHolder, runningLmcListHolder, localCoordinator);
            ruHandlerUsed = this.ruHandlersHolder.getRuRunningSwHandler();
            this.ruSwResult = 1;
            this.runningSwUsed = true;
        } else {
            logger.traceDebug(THIS_CLASS, "Software on RU is NOT compatible with DU; inspecting SW on DU.");
            logger.info(THIS_CLASS, "For the radio with LDN \"" + ruDataHolder.getLdn() + "\", the running radio software " + runningProductNumber + "_" + runningProductRevision + " is NOT compatible with the system desired one " + swOnDuProductNumber + "_" + swOnDuProductRevison);
            if (duSwPresentInCompatibilityList) {
                logger.traceDebug(THIS_CLASS, "Compatibility list for DU is known.");
                if (CompatibilityListSwMatcher.isProductNumberAndRevisonCompatibleWithLmc(runningProductNumber, runningProductRevision, duSwLmcListHolder)) {
                    logger.traceDebug(THIS_CLASS, "SW on DU is compatible with running SW on DU, using SW on DU.");
                    logger.info(THIS_CLASS, "For the radio with LDN \"" + ruDataHolder.getLdn() + "\", the system desired radio software " + swOnDuProductNumber + "_" + swOnDuProductRevison + " is compatible with the running one " + runningProductNumber + "_" + runningProductRevision);
                    this.setLoadModuleUserLabel(localLoadModuleMo, localCoordinator);
                    this.ruHandlersHolder.getRuSwOnDuHandler().handleSwOnDu(localLoadModuleMo, ruDataHolder, localCoordinator);
                    ruHandlerUsed = this.ruHandlersHolder.getRuSwOnDuHandler();
                    this.ruSwResult = 1;
                } else {
                    logger.traceDebug(THIS_CLASS, "SW on DU is incompatible with current SW on RU.");
                    this.ruHandlersHolder.getRuRunningSwHandler().handleIncompatibleSw(ruDataHolder, localCoordinator);
                    ruHandlerUsed = this.ruHandlersHolder.getRuRunningSwHandler();
                    this.ruSwResult = 2;
                }
            } else {
                logger.traceDebug(THIS_CLASS, "Compatibility list for DU is NOT known; requesting preload with INCONCLUSIVE answer.");
                this.lmFilePath = this.ruHandlersHolder.getRuRunningSwHandler().handleRunningSwWithPreLoad(localLoadModuleMo, localCoordinator);
                ruHandlerUsed = this.ruHandlersHolder.getRuRunningSwHandler();
                this.ruSwResult = 3;
            }
        }
        this.loadModuleMo = ruHandlerUsed.getLoadModuleMo();
        this.xpProgramMo = ruHandlerUsed.getXpProgramMo();
        this.preInstalledUsed = ruHandlerUsed.isPreInstalledUsed();
    }

    private void handleRunningWithSameProductNumber(LmcListHolder runningLmcListHolder, RuDataHolder ruDataHolder, Coordinator localCoordinator, LoadModuleMoSU_Access localLoadModuleMo, Struct loadModuleProductData, LmcListHolder duSwLmcListHolder, boolean duSwPresentInCompatibilityList) throws MoAccessException, RevisionHolder.RevisionParseException {
        RuHandler ruHandlerUsed = null;
        String runningProductNumber = ProductNumberHelper.convertProductNumber(runningLmcListHolder.getProductNumber());
        String runningProductRevision = runningLmcListHolder.getProductRevision();
        String swOnDuProductRevison = loadModuleProductData.getValue("productRevision").toString();
        logger.traceDebug(THIS_CLASS, "Product numbers for SW on RU and DU are equal: " + runningProductNumber);
        if (runningProductRevision.equalsIgnoreCase(swOnDuProductRevison)) {
            logger.traceDebug(THIS_CLASS, "Product revisions for SW on RU and DU equal: " + runningProductRevision);
            logger.info(THIS_CLASS, "For the radio with LDN \"" + ruDataHolder.getLdn() + "\", the running radio software " + runningProductNumber + "_" + runningProductRevision + " is compatible with the system desired one " + runningProductNumber + "_" + swOnDuProductRevison);
            this.ruHandlersHolder.getRuSwOnDuHandler().handleSwOnDu(localLoadModuleMo, ruDataHolder, localCoordinator);
            ruHandlerUsed = this.ruHandlersHolder.getRuSwOnDuHandler();
            this.ruSwResult = 1;
        } else if (CompatibilityListSwMatcher.isGreaterThan(swOnDuProductRevison, runningProductRevision, true)) {
            logger.traceDebug(THIS_CLASS, "SW on DU is newer than on RU: " + swOnDuProductRevison + " > " + runningProductRevision);
            logger.info(THIS_CLASS, "For the radio with LDN \"" + ruDataHolder.getLdn() + "\", the running radio software " + runningProductNumber + "_" + runningProductRevision + " is NOT compatible with the system desired one " + runningProductNumber + "_" + swOnDuProductRevison);
            if (duSwPresentInCompatibilityList) {
                logger.traceDebug(THIS_CLASS, "Compatibility list for SW on DU is available.");
                this.setLoadModuleUserLabel(localLoadModuleMo, localCoordinator);
                this.ruSwResult = this.ruHandlersHolder.getRuRunningSwHandler().handleRunningSwDuSwNewer(ruDataHolder, duSwLmcListHolder, runningLmcListHolder, localLoadModuleMo, localCoordinator);
                ruHandlerUsed = this.ruHandlersHolder.getRuRunningSwHandler();
                if (this.ruSwResult == 1) {
                    logger.info(THIS_CLASS, "For the radio with LDN \"" + ruDataHolder.getLdn() + "\", the system desired radio software " + runningProductNumber + "_" + swOnDuProductRevison + " is compatible with the running one " + runningProductNumber + "_" + runningProductRevision);
                }
            } else {
                logger.traceDebug(THIS_CLASS, "Compatibility list for SW on DU is NOT available. Requesting preload with INCONCLUSIVE answer.");
                this.lmFilePath = this.ruHandlersHolder.getRuRunningSwHandler().handleRunningSwWithPreLoad(localLoadModuleMo, localCoordinator);
                ruHandlerUsed = this.ruHandlersHolder.getRuRunningSwHandler();
                this.ruSwResult = 3;
            }
        } else {
            logger.traceDebug(THIS_CLASS, "SW on RU is newer than on DU: " + runningProductRevision + " > " + swOnDuProductRevison);
            this.ruSwResult = this.ruHandlersHolder.getRuRunningSwHandler().handleDuSwOlderThanRunningSw(ruDataHolder, loadModuleProductData, runningLmcListHolder, localCoordinator);
            ruHandlerUsed = this.ruHandlersHolder.getRuRunningSwHandler();
            boolean bl = this.runningSwUsed = this.ruSwResult == 1;
            if (this.ruSwResult == 1) {
                logger.info(THIS_CLASS, "For the radio with LDN \"" + ruDataHolder.getLdn() + "\", the running radio software " + runningProductNumber + "_" + runningProductRevision + " is compatible with the system desired one " + runningProductNumber + "_" + swOnDuProductRevison);
            }
        }
        this.loadModuleMo = ruHandlerUsed.getLoadModuleMo();
        this.xpProgramMo = ruHandlerUsed.getXpProgramMo();
        this.preInstalledUsed = ruHandlerUsed.isPreInstalledUsed();
    }

    private void setLoadModuleUserLabel(LoadModuleMoSU_Access localLoadModuleMoAccess, Coordinator localCoordinator) throws MoAccessException {
        LoadModuleMo localLoadModuleMo = (LoadModuleMo)localLoadModuleMoAccess;
        localLoadModuleMo.setUserLabel("DoReAlLyUsErAaLfIlPaTh", localCoordinator);
        logger.traceGeneral(THIS_CLASS, "Set userLabel to indicate that real LM file path should be used");
    }

    private void makeSureSwAllocationAndRepertoireAreAvailable(Coordinator coordinator, PiuTypeMoSU_Access piuTypeMo) throws MoAccessException {
        SwAllocationHandler swAllocationHandler = SwAllocationHandlerFactory.getInstance().getSwAllocationHandler(this.genericMaoContext);
        swAllocationHandler.makeSureSwAllocationAndRepertoireAreAvailable(piuTypeMo, coordinator);
    }

    private LmcListHolder ruLmOnDuPresentInCompatibilityList(String swOnDuProductNumber, String swOnDuProductRevision, SwCompatibilityListHolder swCompatibilityListHolder) {
        LmcListHolder duSwLmcListHolder = null;
        LmcListHolder[] lmcListHolders = swCompatibilityListHolder.getLmcListHolders();
        for (int i = 0; i < lmcListHolders.length; ++i) {
            String productNumber = ProductNumberHelper.convertProductNumber(lmcListHolders[i].getProductNumber());
            String productRevision = lmcListHolders[i].getProductRevision();
            if (!productNumber.equalsIgnoreCase(swOnDuProductNumber) || !productRevision.equalsIgnoreCase(swOnDuProductRevision)) continue;
            duSwLmcListHolder = lmcListHolders[i];
            break;
        }
        return duSwLmcListHolder;
    }

    public String toString() {
        return "\n\tUpgradeable Plug In Unit: " + this.auxPlugInUnitMao;
    }

    private static class RuHandlersHolder {
        private final RuNoMatchHandler ruNoMatchHandler;
        private final RuIncorrectCompatibilityListHandler ruIncorrectCompatibilityListHandler;
        private final RuPreInstalledSwHandler ruPreInstalledSwHandler;
        private final RuSwOnDuHandler ruSwOnDuHandler;
        private final RuRunningSwHandler ruRunningSwHandler;
        private final RuIncompatibleHwHandler ruIncompatibleHwHandler;

        public RuHandlersHolder(AuxPlugInUnitMao theAuxPlugInUnitMao, GenericMaoContext theGenericMaoContext) {
            this.ruNoMatchHandler = RuNoMatchHandlerFactory.getInstance().getRuNoMatchHandler(theAuxPlugInUnitMao, theGenericMaoContext);
            this.ruIncorrectCompatibilityListHandler = RuIncorrectCompatibilityListHandlerFactory.getInstance().getRuIncorrectCompatibilityListHandler(theAuxPlugInUnitMao, theGenericMaoContext);
            this.ruPreInstalledSwHandler = RuPreInstalledSwHandlerFactory.getInstance().getRuPreInstalledSwHandler(theAuxPlugInUnitMao, theGenericMaoContext);
            this.ruSwOnDuHandler = RuSwOnDuHandlerFactory.getInstance().getRuSwOnDuHandler(theAuxPlugInUnitMao, theGenericMaoContext);
            this.ruRunningSwHandler = RuRunningSwHandlerFactory.getInstance().getRuRunningSwHandler(theAuxPlugInUnitMao, theGenericMaoContext);
            this.ruIncompatibleHwHandler = RuIncompatibleHwHandlerFactory.getInstance().getRuIncompatibleHwHandler(theAuxPlugInUnitMao, theGenericMaoContext);
        }

        public RuNoMatchHandler getRuNoMatchHandler() {
            return this.ruNoMatchHandler;
        }

        public RuIncompatibleHwHandler getRuIncompatibleHwHandler() {
            return this.ruIncompatibleHwHandler;
        }

        public RuIncorrectCompatibilityListHandler getRuIncorrectCompatibilityListHandler() {
            return this.ruIncorrectCompatibilityListHandler;
        }

        public RuPreInstalledSwHandler getRuPreInstalledSwHandler() {
            return this.ruPreInstalledSwHandler;
        }

        public RuSwOnDuHandler getRuSwOnDuHandler() {
            return this.ruSwOnDuHandler;
        }

        public RuRunningSwHandler getRuRunningSwHandler() {
            return this.ruRunningSwHandler;
        }
    }
}

