/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program.handler;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.auxpluginunit.AuxPlugInUnitMao;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.AbstractRuHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuIncompatibleHwHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.LoadModuleHelperImpl;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.XpProgramMoHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RuDataHolder;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class RuIncompatibleHwHandlerImpl
extends AbstractRuHandler
implements RuIncompatibleHwHandler {
    private static final Class THIS_CLASS = RuIncompatibleHwHandlerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String SIMPLE_DATE_STRING = "yyyyMMdd";

    public RuIncompatibleHwHandlerImpl(AuxPlugInUnitMao auxPlugInUnitMao, GenericMaoContext genericMaoContext) {
        super(auxPlugInUnitMao, genericMaoContext);
    }

    public void handleIncompatibleHw(RuDataHolder ruDataHolder, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleIncompatibleHw()");
        boolean xpProgramCreated = this.createLoadModuleAndXpProgram(ruDataHolder, localCoordinator);
        if (xpProgramCreated) {
            logger.traceGeneral(THIS_CLASS, "Created XpProgram MO: \"" + this.xpProgramMo + "\" for incompatible HW");
        } else {
            logger.traceGeneral(THIS_CLASS, "Retrieved existing XpProgram MO: \"" + this.xpProgramMo + "\" for incompatible HW");
        }
        logger.traceReturn(THIS_CLASS, "handleIncompatibleHw()");
    }

    private boolean createLoadModuleAndXpProgram(RuDataHolder ruDataHolder, Coordinator localCoordinator) throws MoAccessException {
        this.preInstalledUsed = false;
        String filePath = "incompHW/ProductNamesIncomp";
        String productNumber = "ProductNamesIncomp";
        String productInfo = "incompHW";
        String productionDate = DateTimeHelper.dateToString((long)System.currentTimeMillis(), (String)SIMPLE_DATE_STRING);
        String productName = ruDataHolder.getProductName();
        String productRevision = "-";
        Struct loadModuleProductData = this.createLoadModuleProductDataStruct("incompHW", productionDate, productName, productNumber, "-");
        LoadModuleHelperImpl.LoadModuleHolder loadModuleHolder = this.loadModuleHelper.getOrCreateLoadModuleMo(ruDataHolder, filePath, loadModuleProductData, localCoordinator);
        this.loadModuleMo = loadModuleHolder.loadModuleMo;
        XpProgramMoHolder xpProgramMoHolder = this.xpProgramHelper.getOrCreateXpProgramMo(this.loadModuleMo, ruDataHolder, localCoordinator);
        this.xpProgramMo = xpProgramMoHolder.xpProgramMo;
        return xpProgramMoHolder.isCreated;
    }
}

