/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program.handler;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.auxpluginunit.AuxPlugInUnitMao;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.AbstractRuHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuNoMatchHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.LoadModuleHelperImpl;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.XpProgramMoHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RuDataHolder;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class RuNoMatchHandlerImpl
extends AbstractRuHandler
implements RuNoMatchHandler {
    private static final Class THIS_CLASS = RuNoMatchHandlerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String SIMPLE_DATE_STRING = "yyyyMMdd";

    public RuNoMatchHandlerImpl(AuxPlugInUnitMao auxPlugInUnitMao, GenericMaoContext genericMaoContext) {
        super(auxPlugInUnitMao, genericMaoContext);
    }

    public void handleNoMatch(RuDataHolder ruDataHolder, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleNoMatch()");
        logger.traceError(THIS_CLASS, "No match found for RU HW PID: " + ruDataHolder.getHwPidString());
        this.preInstalledUsed = false;
        String productInfo = "incompSW";
        String productionDate = DateTimeHelper.dateToString((long)System.currentTimeMillis(), (String)SIMPLE_DATE_STRING);
        String productName = ruDataHolder.getProductName();
        String productNumber = "NoMatch";
        String productRevision = "-";
        Struct loadModuleProductData = this.createLoadModuleProductDataStruct("incompSW", productionDate, productName, "NoMatch", "-");
        String filePath = "incompSW/NoMatchingSwFound";
        LoadModuleHelperImpl.LoadModuleHolder loadModuleHolder = this.loadModuleHelper.getOrCreateLoadModuleMo(ruDataHolder, "incompSW/NoMatchingSwFound", loadModuleProductData, localCoordinator);
        this.loadModuleMo = loadModuleHolder.loadModuleMo;
        XpProgramMoHolder xpProgramMoHolder = this.xpProgramHelper.getOrCreateXpProgramMo(this.loadModuleMo, ruDataHolder, localCoordinator);
        this.xpProgramMo = xpProgramMoHolder.xpProgramMo;
        if (xpProgramMoHolder.isCreated) {
            logger.traceGeneral(THIS_CLASS, "Created XpProgram MO: \"" + this.xpProgramMo + "\" for PiuType with No Match");
        } else {
            logger.traceGeneral(THIS_CLASS, "Retrieved existing XpProgram MO: \"" + this.xpProgramMo + "\" for PiuType with No Match");
        }
        logger.traceReturn(THIS_CLASS, "handleNoMatch()");
    }
}

