/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program.handler;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.auxpluginunit.AuxPlugInUnitMao;
import se.ericsson.crbs.cat.mao.auxpluginunit.CompatibilityListSwMatcher;
import se.ericsson.crbs.cat.mao.auxpluginunit.SwMatchingException;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.AbstractRuHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.RuRunningSwHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.LoadModuleHelperImpl;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.ProductNumberHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.XpProgramMoHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.LmcListHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RuDataHolder;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class RuRunningSwHandlerImpl
extends AbstractRuHandler
implements RuRunningSwHandler {
    public static final String SIMPLE_DATE_STRING = "yyyyMMdd";
    private static final Class THIS_CLASS = RuRunningSwHandlerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public RuRunningSwHandlerImpl(AuxPlugInUnitMao auxPlugInUnitMao, GenericMaoContext genericMaoContext) {
        super(auxPlugInUnitMao, genericMaoContext);
    }

    public void handleRunningSwLikePreInstalledSw(LmcListHolder runningLmcListHolder, RuDataHolder ruDataHolder, Coordinator localCoordinator) throws MoAccessException, SwMatchingException {
        logger.traceEnter(THIS_CLASS, "handleRunningSwLikePreInstalledSw()");
        this.preInstalledUsed = true;
        String productInfo = "runningSW";
        String tmpProductionDate = runningLmcListHolder.getProductionDate();
        String productionDate = tmpProductionDate == null || tmpProductionDate.equalsIgnoreCase("") ? DateTimeHelper.dateToString((long)System.currentTimeMillis(), (String)SIMPLE_DATE_STRING) : StringHelper.replaceInString((String)tmpProductionDate, (String)"-", (String)"");
        String productName = ruDataHolder.getProductName();
        String productNumber = runningLmcListHolder.getProductNumber();
        String productRevision = runningLmcListHolder.getProductRevision();
        Struct loadModuleProductData = this.createLoadModuleProductDataStruct("runningSW", productionDate, productName, productNumber, productRevision);
        String productNumberWithoutSlash = ProductNumberHelper.convertSlashToPercent(productNumber);
        String productRevisionWithoutSlash = ProductNumberHelper.convertSlashToPercent(productRevision);
        String filePath = "runningSW/" + productNumberWithoutSlash + "_" + productRevisionWithoutSlash;
        LoadModuleHelperImpl.LoadModuleHolder loadModuleHolder = this.loadModuleHelper.getOrCreateLoadModuleMo(ruDataHolder, filePath, loadModuleProductData, localCoordinator);
        this.loadModuleMo = loadModuleHolder.loadModuleMo;
        XpProgramMoHolder xpProgramMoHolder = this.xpProgramHelper.getOrCreateXpProgramMo(this.loadModuleMo, ruDataHolder, localCoordinator);
        this.xpProgramMo = xpProgramMoHolder.xpProgramMo;
        if (xpProgramMoHolder.isCreated) {
            logger.traceGeneral(THIS_CLASS, "Created XpProgram MO: \"" + this.xpProgramMo + "\" for generic PiuType - running SW");
        } else {
            logger.traceGeneral(THIS_CLASS, "Retrieved existing XpProgram MO: \"" + this.xpProgramMo + "\" for generic PiuType - running SW");
        }
        logger.traceReturn(THIS_CLASS, "handleRunningSwLikePreInstalledSw()");
    }

    public int handleDuSwOlderThanRunningSw(RuDataHolder ruDataHolder, Struct loadModuleProductData, LmcListHolder runningLmcListHolder, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleDuSwOlderThanRunningSw()");
        int ruSwResult = 0;
        String loadModuleProdNo = "";
        String loadModuleProdRev = "";
        try {
            String tmpLoadModuleProdNo = loadModuleProductData.getValue("productNumber").toString();
            loadModuleProdNo = ProductNumberHelper.convertProductNumber(tmpLoadModuleProdNo);
            loadModuleProdRev = loadModuleProductData.getValue("productRevision").toString();
        }
        catch (Exception e) {
            throw new SwMatchingException("Failed to retrieve load module product data, when matching SW", e);
        }
        if (CompatibilityListSwMatcher.isProductNumberAndRevisonCompatibleWithLmc(loadModuleProdNo, loadModuleProdRev, runningLmcListHolder)) {
            this.handleCompatibleNewerRunningSw(ruDataHolder, runningLmcListHolder, localCoordinator);
            ruSwResult = 1;
        } else {
            this.handleIncompatibleSw(ruDataHolder, localCoordinator);
            ruSwResult = 2;
        }
        this.preInstalledUsed = false;
        logger.traceReturn(THIS_CLASS, "handleDuSwOlderThanRunningSw()");
        return ruSwResult;
    }

    public void handleRunningSwChangedProductNumber(boolean compatible, RuDataHolder ruDataHolder, LmcListHolder runningLmcListHolder, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleRunningSwChangedProductNumber()");
        if (compatible) {
            this.handleCompatibleNewerRunningSw(ruDataHolder, runningLmcListHolder, localCoordinator);
        } else {
            this.handleIncompatibleSw(ruDataHolder, localCoordinator);
        }
        this.preInstalledUsed = false;
        logger.traceReturn(THIS_CLASS, "handleRunningSwChangedProductNumber()");
    }

    public String handleRunningSwWithPreLoad(LoadModuleMoSU_Access localLoadModuleMo, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleRunningSwWithPreLoad()");
        String lmFilePath = localLoadModuleMo.getRealLoadModuleFilePath(localCoordinator);
        boolean empty = "".equalsIgnoreCase(lmFilePath);
        boolean preInstalledSw = lmFilePath.startsWith("preinsSW");
        boolean runningSw = lmFilePath.startsWith("runningSW");
        if (empty || preInstalledSw || runningSw) {
            lmFilePath = LoadModuleHelperImpl.getLoadModuleFilePath(localLoadModuleMo, localCoordinator);
        }
        logger.traceGeneral(THIS_CLASS, "LM, for RU, with file path " + lmFilePath + " will be sent to NC for pre-loading");
        this.preInstalledUsed = false;
        logger.traceReturn(THIS_CLASS, "handleRunningSwWithPreLoad()");
        return lmFilePath;
    }

    public int handleRunningSwDuSwNewer(RuDataHolder ruDataHolder, LmcListHolder duSwLmcListHolder, LmcListHolder runningLmcListHolder, LoadModuleMoSU_Access localLoadModuleMo, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleRunningSwDuSwNewer()");
        int ruSwResult = 0;
        if (CompatibilityListSwMatcher.isProductNumberAndRevisonCompatibleWithLmc(runningLmcListHolder.getProductNumber(), runningLmcListHolder.getProductRevision(), duSwLmcListHolder)) {
            this.handleCompatibleNewerDesiredSw(ruDataHolder, localLoadModuleMo, localCoordinator);
            ruSwResult = 1;
        } else {
            this.handleIncompatibleSw(ruDataHolder, localCoordinator);
            ruSwResult = 2;
        }
        this.preInstalledUsed = false;
        logger.traceReturn(THIS_CLASS, "handleRunningSwDuSwNewer()");
        return ruSwResult;
    }

    private void handleCompatibleNewerRunningSw(RuDataHolder ruDataHolder, LmcListHolder runningLmcListHolder, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleCompatibleNewerRunningSw()");
        logger.traceGeneral(THIS_CLASS, "The running SW is newer than the SW on the DU, but compatible - let it run");
        String productInfo = "runningSW";
        String tmpProductionDate = runningLmcListHolder.getProductionDate();
        String productionDate = tmpProductionDate == null || tmpProductionDate.equalsIgnoreCase("") ? DateTimeHelper.dateToString((long)System.currentTimeMillis(), (String)SIMPLE_DATE_STRING) : StringHelper.replaceInString((String)tmpProductionDate, (String)"-", (String)"");
        String productName = ruDataHolder.getProductName();
        String productNumber = runningLmcListHolder.getProductNumber();
        String productRevision = runningLmcListHolder.getProductRevision();
        Struct runningLmProductData = this.createLoadModuleProductDataStruct("runningSW", productionDate, productName, productNumber, productRevision);
        String productNumberWithoutSlash = ProductNumberHelper.convertSlashToPercent(productNumber);
        String productRevisionWithoutSlash = ProductNumberHelper.convertSlashToPercent(productRevision);
        String filePath = "runningSW/" + productNumberWithoutSlash + "_" + productRevisionWithoutSlash;
        LoadModuleHelperImpl.LoadModuleHolder loadModuleHolder = this.loadModuleHelper.getOrCreateLoadModuleMo(ruDataHolder, filePath, runningLmProductData, localCoordinator);
        this.loadModuleMo = loadModuleHolder.loadModuleMo;
        XpProgramMoHolder xpProgramMoHolder = this.xpProgramHelper.getOrCreateXpProgramMo(this.loadModuleMo, ruDataHolder, localCoordinator);
        this.xpProgramMo = xpProgramMoHolder.xpProgramMo;
        if (xpProgramMoHolder.isCreated) {
            logger.traceGeneral(THIS_CLASS, "Created XpProgram MO: \"" + this.xpProgramMo + "\" for compatible running SW");
        } else {
            logger.traceGeneral(THIS_CLASS, "Retrieved existing XpProgram MO: \"" + this.xpProgramMo + "\" for compatible running SW");
        }
        this.preInstalledUsed = false;
        logger.traceReturn(THIS_CLASS, "handleCompatibleNewerRunningSw()");
    }

    private void handleCompatibleNewerDesiredSw(RuDataHolder ruDataHolder, LoadModuleMoSU_Access localLoadModuleMo, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleCompatibleNewerDesiredSw()");
        logger.traceGeneral(THIS_CLASS, "The running SW is older than the SW on the DU. Will upgrade since they are compatible.");
        this.preInstalledUsed = false;
        XpProgramMoHolder xpProgramMoHolder = this.xpProgramHelper.getOrCreateXpProgramMo(localLoadModuleMo, ruDataHolder, localCoordinator);
        this.loadModuleMo = localLoadModuleMo;
        this.xpProgramMo = xpProgramMoHolder.xpProgramMo;
        if (xpProgramMoHolder.isCreated) {
            logger.traceGeneral(THIS_CLASS, "Created XpProgram MO: \"" + this.xpProgramMo + "\" for PiuType for SW on DU");
        } else {
            logger.traceGeneral(THIS_CLASS, "Retrieved existing XpProgram MO: \"" + this.xpProgramMo + "\" for PiuType with SW on DU");
        }
        logger.traceReturn(THIS_CLASS, "handleCompatibleNewerDesiredSw()");
    }

    public void handleIncompatibleSw(RuDataHolder ruDataHolder, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handleIncompatibleSw()");
        logger.traceGeneral(THIS_CLASS, "Running SW and SW on DU are incompatible. Will reject configuration.");
        this.preInstalledUsed = false;
        String productInfo = "incompSW";
        String productionDate = DateTimeHelper.dateToString((long)System.currentTimeMillis(), (String)SIMPLE_DATE_STRING);
        String productName = ruDataHolder.getProductName();
        String productNumber = "NoMatch";
        String productRevision = "-";
        Struct loadModuleProductData = this.createLoadModuleProductDataStruct("incompSW", productionDate, productName, "NoMatch", "-");
        String filePath = "incompSW/NoMatchingSwFound";
        LoadModuleHelperImpl.LoadModuleHolder loadModuleHolder = this.loadModuleHelper.getOrCreateLoadModuleMo(ruDataHolder, "incompSW/NoMatchingSwFound", loadModuleProductData, localCoordinator);
        this.loadModuleMo = loadModuleHolder.loadModuleMo;
        XpProgramMoHolder xpProgramMoHolder = this.xpProgramHelper.getOrCreateXpProgramMo(this.loadModuleMo, ruDataHolder, localCoordinator);
        this.xpProgramMo = xpProgramMoHolder.xpProgramMo;
        if (xpProgramMoHolder.isCreated) {
            logger.traceGeneral(THIS_CLASS, "Created XpProgram MO: \"" + this.xpProgramMo + "\" for incompatible running SW");
        } else {
            logger.traceGeneral(THIS_CLASS, "Retrieved existing XpProgram MO: \"" + this.xpProgramMo + "\" for incompatible running SW");
        }
        logger.traceReturn(THIS_CLASS, "handleIncompatibleSw()");
    }
}

