/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program.handler;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.mohandler.program.RuProgramMoHandlerException;
import se.ericsson.crbs.cat.mao.mohandler.program.handler.SwAllocationHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SwAllocationHandlerImpl
implements SwAllocationHandler {
    private static final Class THIS_CLASS = SwAllocationHandlerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String RBS_RRU_NAME = "RBS_RRU";
    public static final String RBS_RU_NAME = "RBS_RU";
    protected static final String SW_MANAGEMENT_MO_LDN = "ManagedElement=1,SwManagement=1";
    private static final String SWALLOCATION_LDN_BASE = "ManagedElement=1,SwManagement=1,SwAllocation=";
    private static final String SWALLOCATION_ROLE = "role";
    private static final String SWALLOCATION_TYPE = "SwAllocation";
    private static final String REPERTOIRE_TYPE = "Repertoire";
    private final GenericMaoContext genericMaoContext;

    public SwAllocationHandlerImpl(GenericMaoContext theGenericMaoContext) {
        this.genericMaoContext = theGenericMaoContext;
    }

    public void makeSureSwAllocationAndRepertoireAreAvailable(PiuTypeMoSU_Access piuTypeMo, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "makeSureSwAllocationAndRepertoireAreAvailable()");
        SwAllocationMo swAllocationMo = this.findOrCreateSwAllocationMo(RBS_RU_NAME, localCoordinator);
        if (swAllocationMo != null) {
            this.addRepertoiresToSwa(piuTypeMo, swAllocationMo, localCoordinator);
        }
        logger.traceReturn(THIS_CLASS, "makeSureSwAllocationAndRepertoireAreAvailable()");
    }

    private final SwAllocationMo findOrCreateSwAllocationMo(String identity, Coordinator localCoordinator) throws RuProgramMoHandlerException {
        logger.traceEnter(THIS_CLASS, "findOrCreateSwAllocationMo()");
        MoRepositoryWrapper moRepository = this.genericMaoContext.getMoRepositoryWrapper();
        MoFactoryMgrWrapper moFactoryMgr = this.genericMaoContext.getMoFactoryMgrWrapper();
        SwAllocationMo swa = (SwAllocationMo)moRepository.lookup(SWALLOCATION_LDN_BASE + identity);
        if (swa == null) {
            ManagedObject swManagement = moRepository.lookup(SW_MANAGEMENT_MO_LDN);
            if (swManagement == null) {
                String msg = "Could not find the system created MO: ManagedElement=1,SwManagement=1";
                throw new RuProgramMoHandlerException("Could not find the system created MO: ManagedElement=1,SwManagement=1");
            }
            try {
                MoFactory swAllocationMoFactory = moFactoryMgr.lookup(SWALLOCATION_TYPE);
                AttrListImpl attrList = new AttrListImpl(moRepository);
                attrList.addElement(SWALLOCATION_ROLE, (Object)identity);
                swa = (SwAllocationMo)swAllocationMoFactory.createMo(swManagement, (AttrList)attrList, identity, null, localCoordinator);
                logger.traceGeneral(THIS_CLASS, "Created SwAllocation MO: " + swa);
            }
            catch (MoAccessException mae) {
                String msg = "Failed to create the MO: ManagedElement=1,SwManagement=1,SwAllocation=" + identity;
                throw new RuProgramMoHandlerException(msg + " Original message: " + mae.getVariablesAsString(), mae);
            }
        }
        logger.traceReturn(THIS_CLASS, "findOrCreateSwAllocationMo(): " + swa);
        return swa;
    }

    private final void addRepertoiresToSwa(PiuTypeMoSU_Access piuTypeMo, SwAllocationMo swAllocationMo, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addRepertoiresToSwa()");
        if (piuTypeMo != null) {
            ManagedObject[] ruReservedBy = (ManagedObject[])piuTypeMo.getAttribute("reservedBy", localCoordinator);
            if (ruReservedBy == null) {
                String errorMessage = "The PiuType with role RU has not been reserved";
                throw new RuProgramMoHandlerException("The PiuType with role RU has not been reserved");
            }
            ManagedObject repertoireMo = null;
            for (int i = 0; i < ruReservedBy.length; ++i) {
                if (!REPERTOIRE_TYPE.equalsIgnoreCase(ruReservedBy[i].getType())) continue;
                repertoireMo = ruReservedBy[i];
                break;
            }
            if (repertoireMo == null) {
                logger.traceDebug(THIS_CLASS, "Repertoire for RU not found!");
            } else {
                swAllocationMo.actionAddRepertoire(repertoireMo, localCoordinator);
                logger.traceGeneral(THIS_CLASS, "Added repertoire, " + repertoireMo + ", to SwAllocation: " + swAllocationMo);
            }
        }
        logger.traceReturn(THIS_CLASS, "addRepertoiresToSwa()");
    }
}

