/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.su.mom.ConfigurationVersion;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.swmanagement.RepertoireMo;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.cello.util.library.Lib;
import se.ericsson.crbs.cat.mao.auxpluginunit.AuxPlugInUnitMao;
import se.ericsson.crbs.cat.mao.mohandler.program.RuProgramMoHandlerException;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.FileHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.FileHelperFactory;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.LoadModuleHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.LoadModuleRecoverer;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.ProductNumberHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RuDataHolder;
import se.ericsson.crbs.cat.mao.xpprogram.XpProgramMaoImpl;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class LoadModuleHelperImpl
implements LoadModuleHelper {
    private static final Class THIS_CLASS = LoadModuleHelperImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String EMPTY_STRING = "";
    public static final String TAG = "tag";
    public static final String LOAD_MODULE_DN = "loadModuleDN";
    private final AuxPlugInUnitMao auxPlugInUnitMao;
    private final GenericMaoContext genericMaoContext;

    public LoadModuleHelperImpl(AuxPlugInUnitMao inputAuxPlugInUnitMao, GenericMaoContext inputGenericMaoContext) {
        this.auxPlugInUnitMao = inputAuxPlugInUnitMao;
        this.genericMaoContext = inputGenericMaoContext;
    }

    public static String getLoadModuleFilePath(LoadModuleMoSU_Access localLoadModuleMo, Coordinator localCoordinator) throws MoAccessException {
        String lmFilePath = localLoadModuleMo.getRealLoadModuleFilePath(localCoordinator);
        String productNumber = localLoadModuleMo.getProductNumber(localCoordinator).toUpperCase(Locale.getDefault());
        productNumber = ProductNumberHelper.convertSlashToPercent(productNumber);
        String productRevision = localLoadModuleMo.getProductRevision(localCoordinator).toUpperCase(Locale.getDefault());
        productRevision = ProductNumberHelper.convertSlashToPercent(productRevision);
        String filePath = "/c/loadmodules_norepl/" + productNumber + "_" + productRevision;
        FileHelper fileHelper = FileHelperFactory.getInstance().getFileHelper();
        boolean pointsOutLm = fileHelper.filePathExists(filePath);
        if (pointsOutLm && !lmFilePath.equalsIgnoreCase(filePath)) {
            lmFilePath = filePath;
            logger.traceDebug(THIS_CLASS, "The LoadModule MO file path updated as the file exisits: \"" + lmFilePath + "\"");
        }
        return lmFilePath;
    }

    public LoadModuleMoSU_Access getInstalledLoadModuleMo(PiuTypeMoSU_Access piuTypeMo, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getInstalledLoadModuleMo()");
        HashSet loadModuleLdnSet = new HashSet();
        ManagedObject[] repertoires = null;
        SwAllocationMoSU_Access swAllocation = (SwAllocationMoSU_Access)this.auxPlugInUnitMao.getSwAllocation(localCoordinator);
        if (swAllocation == null) {
            String errorMsg = "No SwAllocation found for the AuxPlugInUnit MO: \"" + this.auxPlugInUnitMao + "\"";
            logger.traceError(THIS_CLASS, errorMsg);
            throw new RuProgramMoHandlerException(errorMsg);
        }
        logger.traceDebug(THIS_CLASS, "This plug in unit is connected to SwAllocation MO: " + swAllocation.getRole(localCoordinator));
        repertoires = swAllocation.getRepertoireList(localCoordinator);
        if (repertoires == null || repertoires.length == 0) {
            String errorMsg = "No Repertoires for the SwAllocation MO: \"" + swAllocation + "\"";
            logger.traceError(THIS_CLASS, errorMsg);
            throw new RuProgramMoHandlerException(errorMsg);
        }
        for (int i = 0; i < repertoires.length; ++i) {
            logger.traceDebug(THIS_CLASS, "Repertoire: " + repertoires[i]);
            RepertoireMoSU_Access repertoireMo = (RepertoireMoSU_Access)repertoires[i];
            Set ldnSet = this.collectLoadModuleLdns(repertoireMo, piuTypeMo, localCoordinator);
            loadModuleLdnSet.addAll(ldnSet);
        }
        LoadModuleMoSU_Access localLoadModuleMo = null;
        if (loadModuleLdnSet.isEmpty()) {
            logger.traceGeneral(THIS_CLASS, "No load module was found for the PiuType: \"" + piuTypeMo + "\"");
        } else {
            Iterator ldnIterator = loadModuleLdnSet.iterator();
            String loadModuleLdn = (String)ldnIterator.next();
            MoRepositoryWrapper repositoryWrapper = this.genericMaoContext.getMoRepositoryWrapper();
            localLoadModuleMo = (LoadModuleMoSU_Access)repositoryWrapper.lookup(loadModuleLdn);
            logger.traceGeneral(THIS_CLASS, "Load module found: " + loadModuleLdn);
        }
        logger.traceReturn(THIS_CLASS, "getInstalledLoadModuleMo()");
        return localLoadModuleMo;
    }

    public LoadModuleHolder getOrCreateLoadModuleMo(RuDataHolder ruDataHolder, String filePath, Struct lmProductData, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getOrCreateLoadModuleMo()");
        String identity = ruDataHolder.getProductNumber() + "_" + ruDataHolder.getProductRevision();
        String lmFilePathToBeUsed = this.getDesiredLmFilePath(lmProductData.getValue("productNumber").toString(), lmProductData.getValue("productRevision").toString());
        boolean filePathExists = FileHelperFactory.getInstance().getFileHelper().filePathExists(lmFilePathToBeUsed);
        if (!filePathExists) {
            lmFilePathToBeUsed = filePath;
        }
        AttrListImpl attributes = new AttrListImpl();
        attributes.addElement("loaderType", (Object)new Integer(99));
        attributes.addElement("loadModuleFilePath", (Object)lmFilePathToBeUsed);
        attributes.addElement("userLabel", (Object)("Load module for: " + identity));
        attributes.addElement("productData", (Object)lmProductData);
        LoadModuleHolder loadModuleHolder = this.getExistingLoadModuleMo(lmFilePathToBeUsed, ruDataHolder, lmProductData, localCoordinator);
        String attrForDebug = Lib.toString((AttrList)attributes);
        LoadModuleMoSU_Access localLoadModuleMo = loadModuleHolder.loadModuleMo;
        if (loadModuleHolder.loadModuleAvailable) {
            logger.traceGeneral(THIS_CLASS, "Retrieved existing LoadModule MO: \"" + localLoadModuleMo + "\" with\nattributes:\n\t" + attrForDebug);
        } else {
            MoFactory moFactory = this.genericMaoContext.getMoFactoryMgrWrapper().lookup("LoadModule");
            MoRepositoryWrapper repositoryWrapper = this.genericMaoContext.getMoRepositoryWrapper();
            ManagedObject swManagementMo = repositoryWrapper.lookup("ManagedElement=1,SwManagement=1");
            LoadModuleRecoverer.getInstance().saveLoadModuleData(loadModuleHolder.suggestedIdentity, attributes);
            localLoadModuleMo = (LoadModuleMoSU_Access)moFactory.createMo(swManagementMo, (AttrList)attributes, loadModuleHolder.suggestedIdentity, null, localCoordinator);
            localLoadModuleMo.reserve(localCoordinator);
            loadModuleHolder.setLoadModule(localLoadModuleMo);
            logger.traceGeneral(THIS_CLASS, "Created LoadModule MO: \"" + localLoadModuleMo + "\" with\nattributes:\n\t" + attrForDebug);
        }
        logger.traceReturn(THIS_CLASS, "getOrCreateLoadModuleMo(" + localLoadModuleMo + ")");
        return loadModuleHolder;
    }

    public LoadModuleMoSU_Access recreateLoadModuleMo(String lmIdentity, RuDataHolder ruDataHolder, String filePath, Struct productData, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "recreateLoadModuleMo()");
        String auxIdentity = ruDataHolder.getProductNumber() + "_" + ruDataHolder.getProductRevision();
        AttrListImpl attributes = new AttrListImpl();
        attributes.addElement("loaderType", (Object)new Integer(99));
        attributes.addElement("loadModuleFilePath", (Object)filePath);
        attributes.addElement("userLabel", (Object)("Load module for: " + auxIdentity));
        attributes.addElement("productData", (Object)productData);
        ManagedObject lmObj = this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1,SwManagement=1,LoadModule=" + lmIdentity);
        LoadModuleMoSU_Access localLoadModuleMo = null;
        if (lmObj == null) {
            MoFactory moFactory = this.genericMaoContext.getMoFactoryMgrWrapper().lookup("LoadModule");
            String attrForDebug = Lib.toString((AttrList)attributes);
            MoRepositoryWrapper repositoryWrapper = this.genericMaoContext.getMoRepositoryWrapper();
            ManagedObject swManagementMo = repositoryWrapper.lookup("ManagedElement=1,SwManagement=1");
            localLoadModuleMo = (LoadModuleMoSU_Access)moFactory.createMo(swManagementMo, (AttrList)attributes, lmIdentity, null, localCoordinator);
            localLoadModuleMo.reserve(localCoordinator);
            logger.traceGeneral(THIS_CLASS, "Created LoadModule MO: \"" + localLoadModuleMo + "\" with\nattributes:\n\t" + attrForDebug);
        } else {
            localLoadModuleMo = (LoadModuleMoSU_Access)lmObj;
            logger.traceGeneral(THIS_CLASS, "Reused LoadModule MO: \"" + localLoadModuleMo + "\"");
        }
        logger.traceReturn(THIS_CLASS, "recreateLoadModuleMo(" + localLoadModuleMo + ")");
        return localLoadModuleMo;
    }

    public void deleteOwnCreatedLoadModuleIfNotUsed(LoadModuleMoSU_Access loadModuleMo, String xpProgramLdn, Coordinator coordinator) throws MoAccessException {
        Struct productData = loadModuleMo.getProductData(null);
        String productInfo = (String)productData.getValue("productInfo");
        String lmFilePath = loadModuleMo.getRealLoadModuleFilePath(coordinator);
        boolean filePointingAtHardDisk = lmFilePath.startsWith("/c/loadmodules_norepl/");
        if (!filePointingAtHardDisk && this.isLoadModuleMoCreatedByOmf(productInfo)) {
            MoIterator xpProgramIter = this.genericMaoContext.getMoRepositoryWrapper().lookupType("XpProgram");
            boolean referedFromOtherXpProgram = false;
            while (xpProgramIter.hasMoreElements()) {
                ManagedObject referedLoadModule;
                XpProgramMaoImpl currentXpProgram = (XpProgramMaoImpl)xpProgramIter.nextMo();
                if (currentXpProgram.getLocalDistinguishedName().equals(xpProgramLdn) || !(referedLoadModule = currentXpProgram.getLoadModule(coordinator)).getLocalDistinguishedName().equals(loadModuleMo.getLocalDistinguishedName())) continue;
                referedFromOtherXpProgram = true;
                break;
            }
            if (!referedFromOtherXpProgram) {
                loadModuleMo.deleteMO(coordinator);
            }
        }
    }

    private boolean isLoadModuleMoCreatedByOmf(String productInfo) {
        return productInfo.equalsIgnoreCase("RECOVERED") || productInfo.equalsIgnoreCase("compLstFault") || productInfo.equalsIgnoreCase("preinsSW") || productInfo.equalsIgnoreCase("incompSW") || productInfo.equalsIgnoreCase("incompHW");
    }

    private LoadModuleHolder getExistingLoadModuleMo(String filePath, RuDataHolder ruDataHolder, Struct lmProductData, Coordinator localCoordinator) {
        logger.traceEnter(THIS_CLASS, "getExistingLoadModuleMo()");
        LoadModuleMoSU_Access localLoadModuleMo = null;
        ArrayList<Object> availableIdentitiesList = new ArrayList<Object>();
        String userLabelPart = ruDataHolder.getProductNumber() + "_" + ruDataHolder.getProductRevision();
        userLabelPart = userLabelPart.toLowerCase(Locale.getDefault());
        try {
            LoadModuleMoSU_Access[] loadModuleMos = this.getLoadModuleMos(localCoordinator);
            for (int i = 0; i < loadModuleMos.length; ++i) {
                LoadModuleMoSU_Access tmpLoadModuleMo = loadModuleMos[i];
                availableIdentitiesList.add(this.getIdentityFromLdn(tmpLoadModuleMo.getLocalDistinguishedName()));
                if (!this.isLoadModuleOkToBeUsed(tmpLoadModuleMo, lmProductData, localCoordinator)) continue;
                localLoadModuleMo = tmpLoadModuleMo;
                availableIdentitiesList.clear();
                logger.traceGeneral(THIS_CLASS, "Returning existing LoadModule MO:  \"" + localLoadModuleMo + "\"");
                break;
            }
        }
        catch (MoAccessException mae) {
            logger.traceDebug(THIS_CLASS, "Failed to find existing LoadModule MO for filePath: \"" + filePath + "\", and to be used for RU with id: " + StringHelper.doubleQuote((String)userLabelPart));
        }
        boolean loadModuleAvailable = localLoadModuleMo != null;
        String suggestedIdentity = EMPTY_STRING;
        if (!loadModuleAvailable) {
            suggestedIdentity = this.getSuggestedIdentity(ruDataHolder, lmProductData, availableIdentitiesList);
        }
        LoadModuleHolder loadModuleHolder = new LoadModuleHolder(loadModuleAvailable, suggestedIdentity, localLoadModuleMo);
        logger.traceReturn(THIS_CLASS, "getExistingLoadModuleMo(" + loadModuleHolder.loadModuleMo + ")");
        return loadModuleHolder;
    }

    private String getSuggestedIdentity(RuDataHolder theRuDataHolder, Struct theLmProductData, List theAvailableIdentitiesList) {
        String suggestedIdentity = EMPTY_STRING;
        if (this.isRealLoadModuleAvailable(theLmProductData)) {
            suggestedIdentity = this.generateRealLmIdentity(theLmProductData);
        }
        if (EMPTY_STRING.equalsIgnoreCase(suggestedIdentity)) {
            String productName = StringHelper.replaceInString((String)theRuDataHolder.getProductName().toLowerCase(Locale.getDefault()), (String)" ", (String)"_");
            for (int i = 0; i < 100 && theAvailableIdentitiesList.contains(suggestedIdentity = productName + "_" + (i + 1)); ++i) {
                suggestedIdentity = EMPTY_STRING;
            }
        }
        return suggestedIdentity;
    }

    private String generateRealLmIdentity(Struct desiredLmProductData) {
        String result = EMPTY_STRING;
        try {
            String desiredLmProductNumber = this.trimAndConvert((String)desiredLmProductData.getValue("productNumber"));
            String desiredLmProductRevision = this.trimAndConvert((String)desiredLmProductData.getValue("productRevision"));
            result = ProductNumberHelper.convertPercentToSlash(desiredLmProductNumber) + "_" + ProductNumberHelper.convertPercentToSlash(desiredLmProductRevision);
        }
        catch (Exception e) {
            result = EMPTY_STRING;
        }
        return result;
    }

    private boolean isRealLoadModuleAvailable(Struct desiredLmProductData) {
        boolean result = false;
        try {
            String desiredLmProductNumber = this.trimAndConvert((String)desiredLmProductData.getValue("productNumber"));
            String desiredLmProductRevision = this.trimAndConvert((String)desiredLmProductData.getValue("productRevision"));
            String desiredLmFilePath = this.getDesiredLmFilePath(desiredLmProductNumber, desiredLmProductRevision);
            FileHelper fileHelper = FileHelperFactory.getInstance().getFileHelper();
            result = fileHelper.filePathExists(desiredLmFilePath);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public LoadModuleMoSU_Access[] getLoadModuleMos(Coordinator localCoordinator) throws MoAccessException {
        ConfigurationVersion configurationVersionMo;
        ManagedObject executingUpMo;
        UpgradePackageMo executingUpgradePackageMo = null;
        MoIterator cvIt = this.genericMaoContext.getMoRepositoryWrapper().lookupType("ConfigurationVersion");
        if (cvIt != null && cvIt.hasMoreElements() && (executingUpMo = (configurationVersionMo = (ConfigurationVersion)cvIt.nextMo()).getCurrentUpgradePackage(localCoordinator)) != null && executingUpMo instanceof UpgradePackageMo) {
            executingUpgradePackageMo = (UpgradePackageMo)executingUpMo;
        }
        UpgradePackageMo[] nonExecutingUpgradePackages = this.getNonExecutingUpgradePackages(executingUpgradePackageMo);
        LoadModuleMoSU_Access[] installedLoadModuleMos = this.getInstalledLoadModules(nonExecutingUpgradePackages, localCoordinator);
        LoadModuleMoSU_Access[] loadModuleMos = this.getSelfCreatedAndExecutingUpsLoadModules(installedLoadModuleMos, executingUpgradePackageMo, localCoordinator);
        return loadModuleMos;
    }

    private UpgradePackageMo[] getNonExecutingUpgradePackages(UpgradePackageMo executingUpgradePackageMo) {
        ArrayList<ManagedObject> nonExecutingUpgradePackagesList = new ArrayList<ManagedObject>();
        MoIterator upgradePackageIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType("UpgradePackage");
        if (executingUpgradePackageMo != null && upgradePackageIterator != null) {
            while (upgradePackageIterator.hasMoreElements()) {
                ManagedObject tmpMo = upgradePackageIterator.nextMo();
                if (tmpMo == null || !(tmpMo instanceof UpgradePackageMo) || tmpMo.getLocalDistinguishedName().equals(executingUpgradePackageMo.getLocalDistinguishedName())) continue;
                nonExecutingUpgradePackagesList.add(tmpMo);
            }
        }
        UpgradePackageMo[] result = new UpgradePackageMo[nonExecutingUpgradePackagesList.size()];
        nonExecutingUpgradePackagesList.toArray(result);
        return result;
    }

    private LoadModuleMoSU_Access[] getSelfCreatedAndExecutingUpsLoadModules(LoadModuleMoSU_Access[] installedLoadModuleMos, UpgradePackageMo executingUpgradePackageMo, Coordinator localCoordinator) throws MoAccessException {
        ArrayList<ManagedObject> loadModulesToBeUsedList = new ArrayList<ManagedObject>();
        ManagedObject[] executingLmMos = executingUpgradePackageMo.getLoadModuleList(localCoordinator);
        MoIterator loadModuleIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType("LoadModule");
        if (loadModuleIterator != null) {
            while (loadModuleIterator.hasMoreElements()) {
                ManagedObject tmpMo = loadModuleIterator.nextMo();
                if (this.existsInInstalledUps(tmpMo, installedLoadModuleMos) && this.doesNotExistsInExecutinUp(tmpMo, executingLmMos)) {
                    logger.traceGeneral(THIS_CLASS, "LoadModule MO, " + tmpMo + ", exists in installed UP only - not in executing one");
                    continue;
                }
                loadModulesToBeUsedList.add(tmpMo);
            }
        }
        LoadModuleMoSU_Access[] loadModuleMos = new LoadModuleMoSU_Access[loadModulesToBeUsedList.size()];
        loadModulesToBeUsedList.toArray(loadModuleMos);
        return loadModuleMos;
    }

    private boolean existsInInstalledUps(ManagedObject loadModuleMo, LoadModuleMoSU_Access[] installedLoadModuleMos) {
        boolean found = false;
        for (int i = 0; i < installedLoadModuleMos.length; ++i) {
            if (loadModuleMo == null || !loadModuleMo.getLocalDistinguishedName().equals(installedLoadModuleMos[i].getLocalDistinguishedName())) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean doesNotExistsInExecutinUp(ManagedObject loadModuleMo, ManagedObject[] executingLmMos) {
        boolean found = false;
        for (int i = 0; i < executingLmMos.length; ++i) {
            if (loadModuleMo == null || !loadModuleMo.getLocalDistinguishedName().equals(executingLmMos[i].getLocalDistinguishedName())) continue;
            found = true;
            break;
        }
        return !found;
    }

    private LoadModuleMoSU_Access[] getInstalledLoadModules(UpgradePackageMo[] nonExecutingUpgradePackages, Coordinator localCoordinator) throws MoAccessException {
        HashMap<String, ManagedObject> tmpMap = new HashMap<String, ManagedObject>();
        for (int i = 0; i < nonExecutingUpgradePackages.length; ++i) {
            UpgradePackageMo upgradePackageMo = nonExecutingUpgradePackages[i];
            ManagedObject[] loadModuleMos = upgradePackageMo.getLoadModuleList(localCoordinator);
            for (int j = 0; j < loadModuleMos.length; ++j) {
                tmpMap.put(loadModuleMos[i].getLocalDistinguishedName(), loadModuleMos[i]);
            }
        }
        ArrayList tmpList = new ArrayList();
        tmpList.addAll(tmpMap.values());
        LoadModuleMoSU_Access[] result = new LoadModuleMoSU_Access[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    private boolean isLoadModuleOkToBeUsed(LoadModuleMoSU_Access loadModuleMo, Struct desiredLmProductData, Coordinator localCoordinator) throws MoAccessException {
        Struct lmProductData = loadModuleMo.getProductData(localCoordinator);
        String lmProductNumber = this.trimAndConvert((String)lmProductData.getValue("productNumber"));
        String lmProductRevision = this.trimAndConvert((String)lmProductData.getValue("productRevision"));
        String desiredLmProductNumber = this.trimAndConvert((String)desiredLmProductData.getValue("productNumber"));
        String desiredLmProductRevision = this.trimAndConvert((String)desiredLmProductData.getValue("productRevision"));
        boolean loadModulecanBeUsed = desiredLmProductNumber.equalsIgnoreCase(lmProductNumber) && desiredLmProductRevision.equalsIgnoreCase(lmProductRevision);
        return loadModulecanBeUsed;
    }

    private String getDesiredLmFilePath(String desiredLmProductNumber, String desiredLmProductRevision) {
        String desiredLmFilePath = "/c/loadmodules_norepl/" + ProductNumberHelper.convertSlashToPercent(desiredLmProductNumber) + "_" + ProductNumberHelper.convertSlashToPercent(desiredLmProductRevision);
        return desiredLmFilePath;
    }

    private String trimAndConvert(String inputString) {
        return ProductNumberHelper.convertSlashToPercent(ProductNumberHelper.convertProductNumber(inputString.trim()));
    }

    private Object getIdentityFromLdn(String localDistinguishedName) {
        int index = localDistinguishedName.lastIndexOf("=") + 1;
        return localDistinguishedName.substring(index);
    }

    private Set collectLoadModuleLdns(RepertoireMoSU_Access repertoireMo, PiuTypeMoSU_Access piuTypeMo, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "collectLoadModuleLdns()");
        Struct[] programConfigurationsInPiuType = piuTypeMo.getProgramConfiguration(localCoordinator);
        logger.traceDebug(THIS_CLASS, "programConfigurationsInPiuType: " + Lib.toString((Struct[])programConfigurationsInPiuType) + "\n\trepertoireMo: " + repertoireMo.getName(localCoordinator) + "\n\tpiuTypeMo: " + piuTypeMo + "\n\tcoordinator: " + Lib.toString((Coordinator)localCoordinator));
        HashSet<String> loadModuleLdns = new HashSet<String>();
        RepertoireMo tmpRepertoireMo = (RepertoireMo)repertoireMo;
        Struct[] loadModulesDataInRepertoire = tmpRepertoireMo.getLMData((PiuTypeMo)piuTypeMo, localCoordinator);
        if (loadModulesDataInRepertoire == null || loadModulesDataInRepertoire.length == 0) {
            logger.traceGeneral(THIS_CLASS, "No Load Module Data in Repertoire: " + repertoireMo.getName(localCoordinator) + "\n\tupgradeablePlugInUnit: " + this.auxPlugInUnitMao + "\n\tprogramConfigurationsInPiuType: " + Lib.toString((Struct[])programConfigurationsInPiuType) + "\n\trepertoireMo: " + repertoireMo.getName(localCoordinator) + "\n\tcoordinator: " + Lib.toString((Coordinator)localCoordinator));
        } else {
            logger.traceDebug(THIS_CLASS, "The load module information held by the Repertoire are: " + repertoireMo.getName(localCoordinator) + "\n\trepertoireMo: " + repertoireMo.getName(localCoordinator) + "\n\tLoad Module Information: " + Lib.toString((Struct[])loadModulesDataInRepertoire));
            for (int i = 0; i < loadModulesDataInRepertoire.length; ++i) {
                String tag = (String)loadModulesDataInRepertoire[i].getValue(TAG);
                String loadModuleLdn = (String)loadModulesDataInRepertoire[i].getValue(LOAD_MODULE_DN);
                if (!this.loadModuleExistsInUp(loadModuleLdn, localCoordinator) || !this.isTagInProgramConfigurationInPiuType(tag, programConfigurationsInPiuType)) continue;
                loadModuleLdns.add(loadModuleLdn);
                logger.traceDebug(THIS_CLASS, "Added LoadModule MO: \"" + loadModuleLdn + "\"");
            }
        }
        logger.traceReturn(THIS_CLASS, "collectLoadModuleLdns()");
        return loadModuleLdns;
    }

    private boolean loadModuleExistsInUp(String loadModuleLdn, Coordinator localCoordinator) throws MoAccessException {
        String lmFilePath = EMPTY_STRING;
        try {
            if (loadModuleLdn != null) {
                ManagedObject managedObject = this.genericMaoContext.getMoRepositoryWrapper().lookup(loadModuleLdn);
                if (managedObject == null) {
                    managedObject = LoadModuleRecoverer.getInstance().restoreLoadModuleFromLdn(loadModuleLdn, this.genericMaoContext, localCoordinator);
                }
                if (managedObject != null) {
                    LoadModuleMoSU_Access loadModule = (LoadModuleMoSU_Access)managedObject;
                    lmFilePath = loadModule.getRealLoadModuleFilePath(localCoordinator);
                }
            }
        }
        catch (Exception e) {
            lmFilePath = EMPTY_STRING;
        }
        boolean loadModuleMoInUcf = this.lmFilePathPointsOutLoadModuleOnDu(loadModuleLdn, lmFilePath, localCoordinator);
        logger.traceGeneral(THIS_CLASS, loadModuleLdn + " exists in UCF: " + loadModuleMoInUcf);
        return loadModuleMoInUcf;
    }

    private boolean lmFilePathPointsOutLoadModuleOnDu(String loadModuleLdn, String lmFilePath, Coordinator localCoordinator) throws MoAccessException {
        boolean pointsOutLm;
        logger.traceEnter(THIS_CLASS, "lmFilePathPointsOutLoadModuleOnDu() loadModuleLdn: " + loadModuleLdn + " lmFilePath: " + lmFilePath);
        boolean incompatibleSw = lmFilePath.startsWith("incompSW");
        boolean faultyCompatibilityList = lmFilePath.startsWith("compLstFault");
        boolean incompatibleHw = lmFilePath.startsWith("incompHW");
        boolean empty = EMPTY_STRING.equalsIgnoreCase(lmFilePath);
        boolean preInstalledSw = lmFilePath.startsWith("preinsSW");
        boolean runningSw = lmFilePath.startsWith("runningSW");
        boolean bl = pointsOutLm = !incompatibleSw && !faultyCompatibilityList && !incompatibleHw;
        if (empty || preInstalledSw || runningSw) {
            MoRepositoryWrapper repositoryWrapper = this.genericMaoContext.getMoRepositoryWrapper();
            LoadModuleMoSU_Access localLoadModuleMo = (LoadModuleMoSU_Access)repositoryWrapper.lookup(loadModuleLdn);
            String theLmFilePath = LoadModuleHelperImpl.getLoadModuleFilePath(localLoadModuleMo, localCoordinator);
            pointsOutLm = theLmFilePath.startsWith("/c/loadmodules_norepl/");
        }
        logger.traceReturn(THIS_CLASS, "lmFilePathPointsOutLoadModuleOnDu() return: " + pointsOutLm);
        return pointsOutLm;
    }

    private boolean isTagInProgramConfigurationInPiuType(String tag, Struct[] programConfigurationsInPiuType) throws MoAccessException {
        logger.traceGeneral(THIS_CLASS, "tag: " + tag + "\n\tprogramConfigurationsInPiuType: " + Lib.toString((Struct[])programConfigurationsInPiuType));
        return this.getProgramConfigurationIndex(tag, programConfigurationsInPiuType) != -1;
    }

    private int getProgramConfigurationIndex(String tag, Struct[] programConfigurationsInPiuType) throws MoAccessException {
        int result = -1;
        logger.traceEnter(THIS_CLASS, "getProgramConfigurationIndex()");
        logger.traceGeneral(THIS_CLASS, "tag: " + tag + "\n\tprogramConfigurationsInPiuType: " + Lib.toString((Struct[])programConfigurationsInPiuType));
        for (int i = 0; i < programConfigurationsInPiuType.length; ++i) {
            if (!tag.equals(programConfigurationsInPiuType[i].getValue(TAG))) continue;
            result = i;
            break;
        }
        if (result == -1) {
            logger.traceGeneral(THIS_CLASS, "The tag '" + tag + "' was NOT found.");
        } else {
            logger.traceGeneral(THIS_CLASS, "The tag '" + tag + "' was found at index '" + result + "'.");
        }
        logger.traceReturn(THIS_CLASS, "getProgramConfigurationIndex()");
        return result;
    }

    public static class LoadModuleHolder {
        public boolean loadModuleCreated = false;
        public final boolean loadModuleAvailable;
        public final String suggestedIdentity;
        public LoadModuleMoSU_Access loadModuleMo = null;

        public LoadModuleHolder(boolean inputLoadModuleAvailable, String inputSuggestedIdentity, LoadModuleMoSU_Access inputLoadModuleMo) {
            this.loadModuleAvailable = inputLoadModuleAvailable;
            this.suggestedIdentity = inputSuggestedIdentity;
            this.loadModuleMo = inputLoadModuleMo;
        }

        public void setLoadModule(LoadModuleMoSU_Access inputLoadModuleMo) {
            this.loadModuleMo = inputLoadModuleMo;
            this.loadModuleCreated = inputLoadModuleMo != null;
        }
    }
}

