/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program.helper;

import java.util.Locale;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.util.library.Lib;
import se.ericsson.crbs.cat.mao.auxpluginunit.RevisionHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.PiuTypeHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.ProductNumberHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RuDataHolder;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class PiuTypeHelperImpl
implements PiuTypeHelper {
    private static final Class THIS_CLASS = PiuTypeHelperImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public PiuTypeMoSU_Access getPiuTypeForHwPid(RuDataHolder ruDataHolder, GenericMaoContext genericMaoContext) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getPiuTypeForHwPid()");
        PiuTypeMoSU_Access result = null;
        MoIterator piuTypeIterator = genericMaoContext.getMoRepositoryWrapper().lookupType("PiuType");
        if (piuTypeIterator == null || piuTypeIterator.size() == 0) {
            logger.traceDebug(THIS_CLASS, "No \"PiuType\" found.");
        } else {
            while (piuTypeIterator.hasMoreElements()) {
                PiuTypeMoSU_Access piuTypeMo = (PiuTypeMoSU_Access)piuTypeIterator.nextMo();
                Struct piuTypeProductData = piuTypeMo.getProductData(null);
                if (!this.piuTypeMatchesHwPid(piuTypeProductData, ruDataHolder)) continue;
                result = piuTypeMo;
                break;
            }
        }
        if (result == null) {
            logger.traceGeneral(THIS_CLASS, "Found no match for HW PID: " + ruDataHolder.getHwPidString());
        } else {
            logger.traceGeneral(THIS_CLASS, "Found PiuType, \"" + result.getLocalDistinguishedName() + "\" that matches the HW PID: " + ruDataHolder.getHwPidString());
        }
        logger.traceReturn(THIS_CLASS, "getPiuTypeForHwPid(" + result + ")");
        return result;
    }

    public PiuTypeMoSU_Access getGenericPiuTypeForHwPid(RuDataHolder ruDataHolder, GenericMaoContext genericMaoContext) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getGenericPiuTypeForHwPid()");
        PiuTypeMoSU_Access result = null;
        MoIterator piuTypeIterator = genericMaoContext.getMoRepositoryWrapper().lookupType("PiuType");
        if (piuTypeIterator == null || piuTypeIterator.size() == 0) {
            logger.traceDebug(THIS_CLASS, "No \"PiuType\" found when looking for a generic PiuType.");
        } else {
            while (piuTypeIterator.hasMoreElements()) {
                PiuTypeMoSU_Access piuType = (PiuTypeMoSU_Access)piuTypeIterator.nextMo();
                Struct piuTypeProductData = piuType.getProductData(null);
                if (!this.productNameMatchesHwPid(piuTypeProductData, ruDataHolder)) continue;
                result = piuType;
                break;
            }
        }
        if (result == null) {
            logger.traceGeneral(THIS_CLASS, "Found no match for HW PID: " + ruDataHolder.getHwPidString());
        } else {
            logger.traceGeneral(THIS_CLASS, "Found Generic PiuType, \"" + result.getLocalDistinguishedName() + "\" that matches the HW PID: " + ruDataHolder.getHwPidString());
        }
        logger.traceReturn(THIS_CLASS, "getGenericPiuTypeForHwPid(" + result + ")");
        return result;
    }

    private boolean piuTypeMatchesHwPid(Struct piuTypeProductData, RuDataHolder ruDataHolder) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "piuTypeMatchesHwPid()");
        String ruProductNumber = ruDataHolder.getProductNumber();
        String piuTypeProductNumber = (String)piuTypeProductData.getValue("productNumber");
        piuTypeProductNumber = ProductNumberHelper.convertProductNumber(piuTypeProductNumber);
        String ruProductRevision = ruDataHolder.getProductRevision();
        String piuTypeProductRevision = (String)piuTypeProductData.getValue("productRevision");
        boolean result = this.productNumbersMatch(ruProductNumber, piuTypeProductNumber) && this.productRevisionsMatch(ruProductRevision, piuTypeProductRevision);
        logger.traceReturn(THIS_CLASS, "piuTypeMatchesHwPid(" + result + ")");
        return result;
    }

    private boolean productNameMatchesHwPid(Struct piuTypeProductData, RuDataHolder ruDataHolder) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "productNameMatchesHwPid()");
        logger.traceDebug(THIS_CLASS, "PiuType product data: " + Lib.toString((Struct)piuTypeProductData));
        logger.traceDebug(THIS_CLASS, "RU data: " + ruDataHolder);
        String ruProductName = ruDataHolder.getProductName();
        String piuTypeProductName = (String)piuTypeProductData.getValue("productName");
        String piuTypeProductNumber = (String)piuTypeProductData.getValue("productNumber");
        piuTypeProductNumber = ProductNumberHelper.convertProductNumber(piuTypeProductNumber);
        String piuTypeProductRevision = (String)piuTypeProductData.getValue("productRevision");
        String genericProductNumber = piuTypeProductName + "preInstalledSW";
        boolean result = this.productNamesMatch(ruProductName, piuTypeProductName) && this.productNumbersMatch(piuTypeProductNumber, genericProductNumber) && "*".equalsIgnoreCase(piuTypeProductRevision);
        logger.traceReturn(THIS_CLASS, "productNameMatchesHwPid(" + result + ")");
        return result;
    }

    private boolean productNamesMatch(String inputPuProductName, String inputPiuTypeProductName) {
        boolean result = false;
        if (inputPuProductName.length() > 3 && inputPiuTypeProductName.length() > 3) {
            String inputPuProductNameFirstThreeLetters = inputPuProductName.substring(0, 3);
            String inputPiuTypeProductNameFirstThreeLetters = inputPiuTypeProductName.substring(0, 3);
            result = inputPuProductNameFirstThreeLetters.toLowerCase(Locale.getDefault()).startsWith(inputPiuTypeProductNameFirstThreeLetters.toLowerCase(Locale.getDefault()));
        } else {
            result = inputPuProductName.toLowerCase(Locale.getDefault()).startsWith(inputPiuTypeProductName.toLowerCase(Locale.getDefault()));
        }
        return result;
    }

    protected boolean productNumbersMatch(String productNumberOne, String productNumberTwo) {
        String localProductNumberOne = ProductNumberHelper.convertProductNumber(productNumberOne);
        String localProductNumberTwo = ProductNumberHelper.convertProductNumber(productNumberTwo);
        boolean result = localProductNumberOne.equalsIgnoreCase(localProductNumberTwo);
        return result;
    }

    protected boolean productRevisionsMatch(String productRevisionOne, String productRevisionTwo) {
        boolean match = false;
        if (productRevisionOne.equalsIgnoreCase(productRevisionTwo)) {
            match = true;
        } else {
            try {
                RevisionHolder revisionOne = new RevisionHolder(productRevisionOne);
                RevisionHolder revisionTwo = new RevisionHolder(productRevisionTwo);
                match = revisionOne.equals(revisionTwo);
            }
            catch (RevisionHolder.RevisionParseException rpe) {
                match = false;
            }
        }
        return match;
    }
}

