/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program.helper;

import java.util.ArrayList;
import java.util.Locale;
import se.ericsson.cello.equipment.GenericProgramBase;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.swmanagement.LoadModuleMo;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.util.library.Lib;
import se.ericsson.crbs.cat.mao.auxpluginunit.AuxPlugInUnitMao;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.ProductNumberHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.StructHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.XpProgramHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.XpProgramMoHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RuDataHolder;
import se.ericsson.crbs.cat.mao.xpprogram.XpProgramMaoImpl;
import se.ericsson.crbs.common.LdnHelper;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class XpProgramHelperImpl
implements XpProgramHelper {
    private static final String TOGGLE_SUFFIX = "_1";
    private static final String EMPTY_STRING = "";
    private static final Class THIS_CLASS = XpProgramHelperImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final AuxPlugInUnitMao auxPlugInUnitMao;
    private final GenericMaoContext genericMaoContext;

    public XpProgramHelperImpl(AuxPlugInUnitMao inputAuxPlugInUnitMao, GenericMaoContext inputGenericMaoContext) {
        this.auxPlugInUnitMao = inputAuxPlugInUnitMao;
        this.genericMaoContext = inputGenericMaoContext;
    }

    public XpProgramMoHolder getOrCreateXpProgramMo(LoadModuleMoSU_Access localLoadModuleMo, RuDataHolder ruDataHolder, Coordinator localCoordinator) throws MoAccessException {
        XpProgramMoHolder xpProgramMoHolder;
        logger.traceEnter(THIS_CLASS, "getOrCreateXpProgramMo()");
        XpProgramMaoImpl xpProgramMaoImpl = this.getXpProgramMo(localLoadModuleMo, ruDataHolder, localCoordinator);
        if (xpProgramMaoImpl == null) {
            logger.traceGeneral(THIS_CLASS, "NO matching XpProgram found for LoadModule MO: " + localLoadModuleMo);
            xpProgramMaoImpl = this.createXpProgramMo(localLoadModuleMo, ruDataHolder, localCoordinator);
            logger.traceGeneral(THIS_CLASS, "Created XpProgram " + xpProgramMaoImpl + " for LoadModule MO: " + localLoadModuleMo);
            xpProgramMoHolder = new XpProgramMoHolder(true, (GenericProgramBase)xpProgramMaoImpl);
        } else {
            logger.traceGeneral(THIS_CLASS, "Matched XpProgram " + xpProgramMaoImpl + " for LoadModule MO: " + localLoadModuleMo);
            xpProgramMoHolder = new XpProgramMoHolder(false, (GenericProgramBase)xpProgramMaoImpl);
        }
        logger.traceReturn(THIS_CLASS, "getOrCreateXpProgramMo(" + xpProgramMoHolder + ")");
        return xpProgramMoHolder;
    }

    public boolean loadModuleReferencedFromXpProgram(boolean runningSwProvided, LoadModuleMoSU_Access localLoadModuleMo, XpProgramMaoImpl xpProgramMaoImpl, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "loadModuleReferencedFromXpProgram()");
        Struct xpProgramLmProductData = this.getXpProgramLoadModuleData(xpProgramMaoImpl);
        boolean result = false;
        LoadModuleMoSU_Access existingLoadModule = (LoadModuleMoSU_Access)xpProgramMaoImpl.getLoadModule(localCoordinator);
        String existingLoadModuleFilePath = existingLoadModule.getRealLoadModuleFilePath(localCoordinator);
        String inputLoadModuleFilePath = localLoadModuleMo.getRealLoadModuleFilePath(localCoordinator);
        Struct existingLoadModuleProductData = existingLoadModule.getProductData(localCoordinator);
        Struct inputLoadModuleProductData = localLoadModuleMo.getProductData(localCoordinator);
        if (!this.lmFilePathIncompatibleWithRunningSw(runningSwProvided, existingLoadModuleFilePath) && this.doesXpProgramProductDataMatch(xpProgramLmProductData, inputLoadModuleProductData) && existingLoadModuleFilePath.equalsIgnoreCase(inputLoadModuleFilePath) && StructHelper.areIdentical(existingLoadModuleProductData, inputLoadModuleProductData) && this.isEnabled(xpProgramMaoImpl, localCoordinator)) {
            result = true;
        }
        logger.traceDebug(THIS_CLASS, "loadModuleReferencedFromXpProgram(" + localLoadModuleMo + ", " + xpProgramMaoImpl + ") returned: " + result);
        logger.traceReturn(THIS_CLASS, "loadModuleReferencedFromXpProgram(" + result + ")");
        return result;
    }

    private boolean lmFilePathIncompatibleWithRunningSw(boolean runningSwProvided, String existingLoadModuleFilePath) {
        boolean result = false;
        if (!runningSwProvided) {
            result = existingLoadModuleFilePath.startsWith("runningSW");
        }
        return result;
    }

    private boolean doesXpProgramProductDataMatch(Struct xpProgramLmProductData, Struct existingLoadModuleProductData) {
        boolean result = true;
        try {
            if (xpProgramLmProductData != null) {
                String xpProgramProductNumber = xpProgramLmProductData.getValue("productNumber").toString();
                xpProgramProductNumber = ProductNumberHelper.convertSlashToPercent(xpProgramProductNumber);
                xpProgramProductNumber = ProductNumberHelper.convertProductNumber(xpProgramProductNumber);
                logger.traceDebug(THIS_CLASS, "xpProgramProductNumber: " + xpProgramProductNumber);
                String xpProgramProductRevision = xpProgramLmProductData.getValue("productRevision").toString();
                xpProgramProductRevision = ProductNumberHelper.convertSlashToPercent(xpProgramProductRevision);
                logger.traceDebug(THIS_CLASS, "xpProgramProductRevision: " + xpProgramProductRevision);
                String loadModuleProductNumber = existingLoadModuleProductData.getValue("productNumber").toString();
                logger.traceDebug(THIS_CLASS, "loadModuleProductNumber: " + loadModuleProductNumber);
                loadModuleProductNumber = ProductNumberHelper.convertSlashToPercent(loadModuleProductNumber);
                loadModuleProductNumber = ProductNumberHelper.convertProductNumber(loadModuleProductNumber);
                String loadModuleProductRevision = existingLoadModuleProductData.getValue("productRevision").toString();
                loadModuleProductRevision = ProductNumberHelper.convertSlashToPercent(loadModuleProductRevision);
                logger.traceDebug(THIS_CLASS, "loadModuleProductRevision: " + loadModuleProductRevision);
                result = loadModuleProductNumber.equalsIgnoreCase(xpProgramProductNumber) && loadModuleProductRevision.equalsIgnoreCase(xpProgramProductRevision);
                logger.traceDebug(THIS_CLASS, "result: " + result);
            }
        }
        catch (Exception e) {
            logger.traceDebug(THIS_CLASS, "Not possible to get product data: " + e);
        }
        return result;
    }

    private Struct getXpProgramLoadModuleData(XpProgramMaoImpl xpProgramMaoImpl) {
        StructImpl result = null;
        try {
            String xpProgramIdentity = this.getXpProgramIdentity(xpProgramMaoImpl);
            if (!EMPTY_STRING.equals(xpProgramIdentity)) {
                int index = xpProgramIdentity.indexOf(95);
                String productNumber = xpProgramIdentity.substring(0, index);
                String remainingPart = xpProgramIdentity.substring(index + 1);
                index = remainingPart.indexOf(95);
                String productRevision = remainingPart.substring(0, index);
                String[] structNames = new String[]{"productNumber", "productRevision"};
                Object[] structValues = new String[]{ProductNumberHelper.convertSlashToPercent(productNumber), productRevision};
                result = new StructImpl(structNames, structValues);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private String getXpProgramIdentity(XpProgramMaoImpl xpProgramMaoImpl) {
        String identity = EMPTY_STRING;
        String ldn = xpProgramMaoImpl.getLocalDistinguishedName();
        int index = ldn.lastIndexOf(61);
        if (index > -1) {
            identity = ldn.substring(index + 1);
        }
        return identity;
    }

    public void deleteDisabledPrograms(boolean readLockNeeded, Coordinator localCoordinator) throws MoAccessException {
        this.deleteDisabledPrograms(this.auxPlugInUnitMao, readLockNeeded, localCoordinator);
    }

    private XpProgramMaoImpl getXpProgramMo(LoadModuleMoSU_Access localLoadModuleMo, RuDataHolder ruDataHolder, Coordinator localCoordinator) {
        logger.traceEnter(THIS_CLASS, "getXpProgramMo()");
        XpProgramMaoImpl localXpProgramMo = null;
        String runningLmcInfo = this.auxPlugInUnitMao.getRunningLmcInfo();
        boolean runningSwProvided = !"NoRuNnInGLmCiNfOsPeCiFiEd".equalsIgnoreCase(runningLmcInfo);
        try {
            ManagedObject[] children = this.getChildren(this.auxPlugInUnitMao);
            for (int i = 0; i < children.length; ++i) {
                if (!"DeviceGroup".equalsIgnoreCase(children[i].getType())) continue;
                MoIterator grandChildIterator = children[i].getChildren();
                localXpProgramMo = this.getXpProgramMoUnderDeviceGroupMo(localLoadModuleMo, ruDataHolder, runningSwProvided, grandChildIterator, localCoordinator);
                break;
            }
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "Failed to retrieve existing XpProgram MO for LoadModule MO: " + StringHelper.doubleQuote((String)localLoadModuleMo.toString()), (Throwable)mae);
        }
        if (!runningSwProvided && localLoadModuleMo instanceof LoadModuleMo) {
            LoadModuleMo tmpLoadModule = (LoadModuleMo)localLoadModuleMo;
            try {
                tmpLoadModule.setUserLabel("DoReAlLyUsErAaLfIlPaTh", localCoordinator);
            }
            catch (MoAccessException ignore) {
                logger.traceError(THIS_CLASS, "Failed to set userLabel on LoadModule MO: " + tmpLoadModule.getLocalDistinguishedName());
            }
        }
        logger.traceReturn(THIS_CLASS, "getXpProgramMo(" + localXpProgramMo + ")");
        return localXpProgramMo;
    }

    private XpProgramMaoImpl getXpProgramMoUnderDeviceGroupMo(LoadModuleMoSU_Access localLoadModuleMo, RuDataHolder ruDataHolder, boolean runningSwProvided, MoIterator grandChildIterator, Coordinator localCoordinator) throws MoAccessException {
        XpProgramMaoImpl localXpProgramMo = null;
        while (grandChildIterator.hasMoreElements()) {
            ManagedObject grandChild = grandChildIterator.nextMo();
            if (!this.checkGrandChildAndSerialNumber(grandChild, ruDataHolder) || !this.loadModuleReferencedFromXpProgram(runningSwProvided, localLoadModuleMo, (XpProgramMaoImpl)grandChild, localCoordinator)) continue;
            localXpProgramMo = (XpProgramMaoImpl)grandChild;
            break;
        }
        return localXpProgramMo;
    }

    private boolean checkGrandChildAndSerialNumber(ManagedObject grandChild, RuDataHolder ruDataHolder) {
        String ldn = grandChild.getLocalDistinguishedName();
        String ldnNoCaps = ldn.toLowerCase(Locale.getDefault());
        String ruSerialNoCaps = ruDataHolder.getSerialNumber().toLowerCase(Locale.getDefault());
        return grandChild instanceof XpProgramMaoImpl && (ldnNoCaps.endsWith(ruSerialNoCaps) || ldnNoCaps.endsWith(ruSerialNoCaps + TOGGLE_SUFFIX));
    }

    private ManagedObject[] getChildren(AuxPlugInUnitMao anAuxPlugInUnitMao) {
        ArrayList<ManagedObject> childrensList = new ArrayList<ManagedObject>();
        MoIterator childIterator = anAuxPlugInUnitMao.getChildren();
        if (childIterator != null) {
            while (childIterator.hasMoreElements()) {
                childrensList.add(childIterator.nextMo());
            }
        }
        ManagedObject[] children = new ManagedObject[childrensList.size()];
        childrensList.toArray(children);
        return children;
    }

    private boolean isEnabled(XpProgramMaoImpl xpProgramMo, Coordinator localCoordinator) throws MoAccessException {
        Integer startState = (Integer)xpProgramMo.getAttribute("startState", localCoordinator);
        boolean enabled = startState == 1;
        logger.traceGeneral(THIS_CLASS, "isEnabled(" + xpProgramMo + ") returned: " + enabled);
        return enabled;
    }

    protected XpProgramMaoImpl createXpProgramMo(LoadModuleMoSU_Access localLoadModuleMo, RuDataHolder ruDataHolder, Coordinator localCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createXpProgramMo()");
        Struct loadModuleStruct = localLoadModuleMo.getProductData(localCoordinator);
        String loadModuleProductNumber = (String)loadModuleStruct.getValue("productNumber");
        String loadModuleProductRevision = (String)loadModuleStruct.getValue("productRevision");
        String desiredIdentity = loadModuleProductNumber + "_" + loadModuleProductRevision + "_" + ruDataHolder.getSerialNumber();
        MoIterator auxPlugInUnitMoIterator = this.auxPlugInUnitMao.getChildren();
        ManagedObject deviceGroupMo = null;
        String deviceGroupIdentity = ruDataHolder.getProductName().toLowerCase().trim().substring(0, 2);
        while (auxPlugInUnitMoIterator.hasMoreElements()) {
            ManagedObject childObject = auxPlugInUnitMoIterator.nextMo();
            if (!"DeviceGroup".equals(childObject.getType())) continue;
            deviceGroupMo = childObject;
            logger.traceGeneral(THIS_CLASS, "We found a DeviceGroup MO: \"" + deviceGroupMo + "\"");
            break;
        }
        int cardinality = 0;
        XpProgramMaoImpl childProgramMo = null;
        if (deviceGroupMo == null) {
            logger.traceDebug(THIS_CLASS, "No child of type DeviceGroup found for: " + this.auxPlugInUnitMao.getLocalDistinguishedName());
            AttrListImpl attributes = new AttrListImpl();
            MoFactory moFactory = this.genericMaoContext.getMoFactoryMgrWrapper().lookup("DeviceGroup");
            deviceGroupMo = moFactory.createMo((ManagedObject)this.auxPlugInUnitMao, (AttrList)attributes, deviceGroupIdentity, null, localCoordinator);
            logger.traceGeneral(THIS_CLASS, "Created DeviceGroup MO: \"" + deviceGroupMo + "\"");
        } else {
            logger.traceDebug(THIS_CLASS, "Found child of type DeviceGroup for: " + this.auxPlugInUnitMao.getLocalDistinguishedName());
            MoIterator deviceGroupMoIterator = deviceGroupMo.getChildren();
            while (deviceGroupMoIterator.hasMoreElements()) {
                ManagedObject childObject = deviceGroupMoIterator.nextMo();
                if (!(childObject instanceof XpProgramMaoImpl)) continue;
                childProgramMo = (XpProgramMaoImpl)childObject;
                ++cardinality;
                childProgramMo.setStartState(0, localCoordinator);
                this.deleteXpProgramWithSameName(desiredIdentity, childProgramMo, localCoordinator);
            }
        }
        if (cardinality > 1) {
            logger.traceError(THIS_CLASS, "The cardinality is already reached for this DeviceGroup: " + deviceGroupMo);
        }
        String userLabel = "XpProgram for RU: " + ruDataHolder.getProductNumber() + "_" + ruDataHolder.getProductRevision();
        String newXpProgramIdentity = this.createXpProgramIdentity(childProgramMo, desiredIdentity);
        AttrListImpl attributes = new AttrListImpl();
        attributes.addElement("loadModule", (Object)localLoadModuleMo);
        attributes.addElement("userLabel", (Object)userLabel);
        MoFactory moFactory = this.genericMaoContext.getMoFactoryMgrWrapper().lookup("XpProgram");
        XpProgramMaoImpl xpProgram = (XpProgramMaoImpl)moFactory.createMo(deviceGroupMo, (AttrList)attributes, newXpProgramIdentity, null, localCoordinator);
        logger.traceGeneral(THIS_CLASS, "Created XpProgram MO: \"" + xpProgram + "\" with\nattributes:\n\t" + Lib.toString((AttrList)attributes));
        logger.traceReturn(THIS_CLASS, "createXpProgramMo(" + xpProgram + ")");
        return xpProgram;
    }

    private void deleteXpProgramWithSameName(String desiredIdentity, XpProgramMaoImpl childProgramMo, Coordinator localCoordinator) throws MoAccessException {
        if (LdnHelper.getRdnAttributeValue((String)childProgramMo.getLocalDistinguishedName()).equalsIgnoreCase(desiredIdentity)) {
            childProgramMo.delete(localCoordinator);
        }
    }

    private String createXpProgramIdentity(XpProgramMaoImpl existingXpProgramMo, String desiredIdentity) {
        String existingIdentity;
        logger.traceEnter(THIS_CLASS, "createXpProgramIdentity()");
        String identity = desiredIdentity;
        if (existingXpProgramMo != null && desiredIdentity.equalsIgnoreCase(existingIdentity = this.getXpProgramIdentity(existingXpProgramMo))) {
            identity = identity + TOGGLE_SUFFIX;
        }
        logger.traceReturn(THIS_CLASS, "createXpProgramIdentity(" + identity + ")");
        return identity;
    }

    private void deleteDisabledPrograms(ManagedObject parent, boolean readLockNeeded, Coordinator localCoordinator) throws MoAccessException {
        ManagedObject xpProgram;
        logger.traceEnter(THIS_CLASS, "deleteDisabledPrograms()");
        ArrayList<ManagedObject> xpProgramsToBeDeleted = new ArrayList<ManagedObject>();
        MoIterator children = parent.getChildren();
        if (children != null) {
            while (children.hasMoreElements()) {
                ManagedObject childMo = children.nextMo();
                this.deleteDisabledPrograms(childMo, readLockNeeded, localCoordinator);
                if (!(childMo instanceof GenericProgramBase) || (xpProgram = (GenericProgramBase)childMo).getStartState((Coordinator)(readLockNeeded ? localCoordinator : null)) != 0) continue;
                xpProgramsToBeDeleted.add(childMo);
            }
        }
        for (int i = 0; i < xpProgramsToBeDeleted.size(); ++i) {
            xpProgram = (ManagedObject)xpProgramsToBeDeleted.get(i);
            logger.traceGeneral(THIS_CLASS, "Deleting disabled program: \"" + xpProgram.getLocalDistinguishedName() + "\" under parent: \"" + parent.getLocalDistinguishedName() + "\"");
            xpProgram.delete(localCoordinator);
            logger.traceDebug(THIS_CLASS, "Deleted disabled program: \"" + xpProgram.getLocalDistinguishedName() + "\" under parent: \"" + parent.getLocalDistinguishedName() + "\"");
        }
        logger.traceReturn(THIS_CLASS, "deleteDisabledPrograms()");
    }
}

