/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program.parser;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.ProductNumberHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RunningLmcInfoHolder;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class RunningLmcParser
extends DefaultHandler {
    public static final String RUNNING_LMC_INFO_TAG = "RunningLmcInfo";
    private static final Class THIS_CLASS = RunningLmcParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final RunningLmcInfoHolder runningLmcInfoHolder = new RunningLmcInfoHolder();
    private StringBuffer cxcNumberAndRevision = null;

    public RunningLmcInfoHolder getRunningLmcInfoHolder() {
        return this.runningLmcInfoHolder;
    }

    public void parse(String xmlString) {
        logger.traceEnter(THIS_CLASS, "parse(xmlString)");
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
            InputSource input = new InputSource(bais);
            logger.traceGeneral(THIS_CLASS, "xmlString: \"" + xmlString + "\"");
            saxParser.parse(input, (DefaultHandler)this);
        }
        catch (Exception e) {
            this.runningLmcInfoHolder.setRunningLmcInfoCorrupt();
            logger.traceError(THIS_CLASS, "Failed to parse the compatibility list: \"" + xmlString + "\". Reason: " + e.getMessage(), (Throwable)e);
        }
        logger.traceReturn(THIS_CLASS, "parse(xmlString)");
    }

    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        if (RUNNING_LMC_INFO_TAG.equals(qName)) {
            this.cxcNumberAndRevision = new StringBuffer(100);
        }
    }

    public void endElement(String namespaceUri, String localName, String qName) throws SAXException {
        if (RUNNING_LMC_INFO_TAG.equals(qName)) {
            int separatorIndex = this.cxcNumberAndRevision.toString().indexOf(95);
            String cxcNumber = this.cxcNumberAndRevision.toString().substring(0, separatorIndex);
            String cxcRevision = this.cxcNumberAndRevision.toString().substring(separatorIndex + 1);
            this.runningLmcInfoHolder.setProductNumber(ProductNumberHelper.convertPercentToSlash(cxcNumber));
            this.runningLmcInfoHolder.setProductRevision(ProductNumberHelper.convertPercentToSlash(cxcRevision));
        }
    }

    public void characters(char[] charArray, int start, int length) throws SAXException {
        String dataStr = new String(charArray, start, length);
        this.cxcNumberAndRevision.append(dataStr);
    }

    public void fatalError(SAXParseException saxParseException) throws SAXException {
        String msg = "fatalError()";
        logger.traceEnter(THIS_CLASS, "fatalError()");
        logger.traceAbnormal(THIS_CLASS, saxParseException.getMessage());
        logger.traceReturn(THIS_CLASS, "fatalError()");
    }
}

