/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.ericsson.crbs.cat.mao.auxpluginunit.SwMatchingException;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.LmcListHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.RunningLmcParser;
import se.ericsson.crbs.common.StringHelper;

public class SwCompatibilityListHolder {
    private boolean compatibilityListIsCorrect = true;
    private final List lmcListHolderList = new ArrayList();

    public void setCompatibilityListCorrupt() {
        this.compatibilityListIsCorrect = false;
    }

    public boolean isCompatibilityListCorrect() {
        boolean correct = this.compatibilityListIsCorrect;
        if (this.isPreInstalledSupported()) {
            correct = correct && this.isCompatiblityListContainingListItems();
        }
        return correct;
    }

    public LmcListHolder getRunningSw(String runningLmcInfoXml) throws SwMatchingException {
        RunningLmcParser runningLmcParser = new RunningLmcParser();
        runningLmcParser.parse(runningLmcInfoXml);
        String productNumber = runningLmcParser.getRunningLmcInfoHolder().getProductNumber();
        String productRevision = runningLmcParser.getRunningLmcInfoHolder().getProductRevision();
        LmcListHolder runningSw = null;
        LmcListHolder[] lmcListHolders = this.getLmcListHolders();
        for (int i = 0; i < lmcListHolders.length; ++i) {
            if (!lmcListHolders[i].getProductNumber().equalsIgnoreCase(productNumber) || !lmcListHolders[i].getProductRevision().equalsIgnoreCase(productRevision)) continue;
            runningSw = lmcListHolders[i];
            break;
        }
        if (runningSw == null) {
            throw new SwMatchingException("No LMC found in compatibility list matching the running LMC info tag: " + StringHelper.doubleQuote((String)runningLmcInfoXml));
        }
        return runningSw;
    }

    public LmcListHolder getPreInstalledSw() {
        LmcListHolder preInstalledSw = null;
        LmcListHolder[] lmcListHolders = this.getLmcListHolders();
        for (int i = 0; i < lmcListHolders.length; ++i) {
            if (!lmcListHolders[i].isPreInstalled()) continue;
            preInstalledSw = lmcListHolders[i];
            break;
        }
        return preInstalledSw;
    }

    public boolean isPreInstalledSupported() {
        boolean preInstalledSupported = false;
        LmcListHolder[] lmcListHolders = this.getLmcListHolders();
        for (int i = 0; i < lmcListHolders.length; ++i) {
            if (!lmcListHolders[i].isPreInstalled()) continue;
            preInstalledSupported = true;
            break;
        }
        return preInstalledSupported;
    }

    public boolean isCompatiblityListContainingListItems() {
        LmcListHolder preInstalledLmcList = this.getPreInstalledSw();
        return preInstalledLmcList == null ? false : preInstalledLmcList.getSwListItems().length > 0;
    }

    public LmcListHolder[] getLmcListHolders() {
        Object[] lmcListHolders = new LmcListHolder[this.lmcListHolderList.size()];
        this.lmcListHolderList.toArray(lmcListHolders);
        Arrays.sort(lmcListHolders);
        return lmcListHolders;
    }

    public void addLmcListHolder(LmcListHolder lmcListHolder) {
        this.lmcListHolderList.add(lmcListHolder);
    }

    public void resetMatchingCriteria() {
        for (int i = 0; i < this.lmcListHolderList.size(); ++i) {
            LmcListHolder lmcListHolder = (LmcListHolder)this.lmcListHolderList.get(i);
            lmcListHolder.resetMatchingCriteria();
        }
    }

    public String toString() {
        StringBuffer contents = new StringBuffer(5000);
        for (int i = 0; i < this.lmcListHolderList.size(); ++i) {
            LmcListHolder lmcListHolder = (LmcListHolder)this.lmcListHolderList.get(i);
            contents.append(lmcListHolder.toString());
            if (i >= this.lmcListHolderList.size() - 1) continue;
            contents.append('\n');
        }
        return contents.toString();
    }
}

