/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.mohandler.program.parser;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.cat.mao.mohandler.program.helper.ProductNumberHelper;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.LmcListHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.SwCompatibilityListHolder;
import se.ericsson.crbs.cat.mao.mohandler.program.parser.SwListItemHolder;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class SwCompatibilityListXmlParser
extends DefaultHandler {
    private static final String LMC_LIST_TAG = "LmcList";
    private static final String LIST_ITEM_TAG = "ListItem";
    private static final String PRE_INSTALLED_TAG = "Preinstalled";
    private static final String PRODUCTION_DATE_TAG = "ProdDate";
    private static final String PRODUCT_NUMBER_TAG = "ProdNbr";
    private static final String PRODUCT_REVISON_TAG = "Rev";
    private static final String PRODUCT_START_REVISION_TAG = "StartRev";
    private static final String PRODUCT_STOP_REVISION_TAG = "StopRev";
    private static final String EMPTY_STRING = "";
    private static final Class THIS_CLASS = SwCompatibilityListXmlParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final StringBuffer dataHolder = new StringBuffer(500);
    private LmcListHolder lmcListHolder = null;
    private final SwCompatibilityListHolder swCompatibilityListHolder = new SwCompatibilityListHolder();
    private String lmProductNumber = "";
    private String lmProductRevision = "";
    private String lmProductionDate = "";
    private String swProductNumber = "";
    private String swProductStartRevision = "";
    private String swProductStopRevision = "";
    private boolean preInstalled = false;
    private boolean insideListItem = false;

    public SwCompatibilityListHolder getSwCompatibilityListHolder() {
        return this.swCompatibilityListHolder;
    }

    public void parse(String xmlString) {
        logger.traceEnter(THIS_CLASS, "parse(xmlString)");
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
            InputSource input = new InputSource(bais);
            saxParser.parse(input, (DefaultHandler)this);
        }
        catch (Exception e) {
            this.swCompatibilityListHolder.setCompatibilityListCorrupt();
            logger.traceError(THIS_CLASS, "Failed to parse the compatibility list: \"" + xmlString + "\". Reason: " + e.getMessage(), (Throwable)e);
        }
        logger.traceReturn(THIS_CLASS, "parse(xmlString)");
    }

    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        if (LMC_LIST_TAG.equals(qName)) {
            this.lmcListHolder = new LmcListHolder();
            this.lmProductNumber = EMPTY_STRING;
            this.lmProductRevision = EMPTY_STRING;
            this.lmProductionDate = EMPTY_STRING;
            this.preInstalled = false;
        } else if (LIST_ITEM_TAG.equals(qName)) {
            this.swProductNumber = EMPTY_STRING;
            this.swProductStartRevision = EMPTY_STRING;
            this.swProductStopRevision = EMPTY_STRING;
            this.insideListItem = true;
        } else if (PRE_INSTALLED_TAG.equals(qName)) {
            this.preInstalled = true;
        }
    }

    public void endElement(String namespaceUri, String localName, String qName) throws SAXException {
        if (LMC_LIST_TAG.equals(qName)) {
            this.handleLmcList();
        } else if (LIST_ITEM_TAG.equals(qName)) {
            this.handleListItem();
        } else {
            this.handleSwInfo(qName);
        }
        this.dataHolder.setLength(0);
    }

    private void handleSwInfo(String qName) {
        if (PRODUCT_NUMBER_TAG.equals(qName)) {
            this.handleProductNumber();
        } else if (PRODUCT_REVISON_TAG.equals(qName)) {
            this.lmProductRevision = ProductNumberHelper.convertPercentToSlash(this.dataHolder.toString().trim());
        } else if (PRODUCTION_DATE_TAG.equals(qName)) {
            this.lmProductionDate = this.dataHolder.toString().trim();
        } else if (PRODUCT_START_REVISION_TAG.equals(qName)) {
            this.swProductStartRevision = ProductNumberHelper.convertPercentToSlash(this.dataHolder.toString().trim());
        } else if (PRODUCT_STOP_REVISION_TAG.equals(qName)) {
            this.swProductStopRevision = ProductNumberHelper.convertPercentToSlash(this.dataHolder.toString().trim());
        }
    }

    private void handleProductNumber() {
        if (this.insideListItem) {
            this.swProductNumber = ProductNumberHelper.convertPercentToSlash(ProductNumberHelper.convertProductNumber(this.dataHolder.toString().trim()));
        } else {
            this.lmProductNumber = ProductNumberHelper.convertPercentToSlash(ProductNumberHelper.convertProductNumber(this.dataHolder.toString().trim()));
        }
    }

    private void handleLmcList() {
        if (this.lmcListHolder != null) {
            this.lmcListHolder.setPreInstalled(this.preInstalled);
            this.lmcListHolder.setProductNumber(this.lmProductNumber);
            this.lmcListHolder.setProductRevision(this.lmProductRevision);
            this.lmcListHolder.setProductionDate(this.lmProductionDate);
            this.swCompatibilityListHolder.addLmcListHolder(this.lmcListHolder);
        }
    }

    private void handleListItem() {
        SwListItemHolder swListItemHolder = new SwListItemHolder();
        swListItemHolder.setSwProductNumber(this.swProductNumber);
        swListItemHolder.setSwProductStartRevision(this.swProductStartRevision);
        swListItemHolder.setSwProductStopRevision(this.swProductStopRevision);
        if (this.lmcListHolder != null) {
            this.lmcListHolder.addSwListItem(swListItemHolder);
        }
        this.insideListItem = false;
    }

    public void characters(char[] charArray, int start, int length) throws SAXException {
        String dataStr = new String(charArray, start, length);
        this.dataHolder.append(dataStr);
    }

    public void error(SAXParseException saxParseException) throws SAXException {
        String msg = "error()";
        logger.traceEnter(THIS_CLASS, "error()");
        logger.traceAbnormal(THIS_CLASS, saxParseException.getMessage());
        logger.traceReturn(THIS_CLASS, "error()");
    }

    public void fatalError(SAXParseException saxParseException) throws SAXException {
        String msg = "fatalError()";
        logger.traceEnter(THIS_CLASS, "fatalError()");
        logger.traceAbnormal(THIS_CLASS, saxParseException.getMessage());
        logger.traceReturn(THIS_CLASS, "fatalError()");
    }
}

