/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.nodeaddresschange;

import java.util.ArrayList;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.cat.mao.interfaces.NodeAddressChangeInformer;
import se.ericsson.crbs.cat.mao.nodeaddresschange.NodeAddressChangeHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class MoRepositoryHelper {
    private static final Class THIS_CLASS = NodeAddressChangeHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String RBS_CONFIGURATION = "RbsConfiguration";
    private static final int CONFIGURATION_MODE_IKE_VALUE = 1;
    private static final int CONFIGURATION_MODE_DHCP_VALUE = 1;
    public static final int DYNAMIC_CONFIGURATION_TYPE_IKE = 0;
    public static final int DYNAMIC_CONFIGURATION_TYPE_DHCP = 1;

    public static NodeAddressChangeInformer getNodeAddressChangeInformer(MoRepositoryWrapper moRepository) {
        logger.traceEnter(THIS_CLASS, "getNodeAddressChangeInformer()");
        NodeAddressChangeInformer result = null;
        MoIterator moIterator = moRepository.lookupType(RBS_CONFIGURATION);
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject mo = moIterator.nextMo();
            if (mo instanceof NodeAddressChangeInformer) {
                result = (NodeAddressChangeInformer)mo;
                break;
            }
            logger.traceAbnormal(THIS_CLASS, "Found an instance of RbsConfiguration that does not implement NodeAddressChangeInformer");
        }
        logger.traceReturn(THIS_CLASS, "getNodeAddressChangeInformer()");
        return result;
    }

    public static String[] getIpMoAddresses(MoRepositoryWrapper moRepository) {
        logger.traceEnter(THIS_CLASS, "getIpMoAddresses()");
        MoIterator moIterator = moRepository.lookupType("Ip");
        String ipv4Address = null;
        String ipv6Address = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject mo = moIterator.nextMo();
            if (!(mo instanceof IpMo)) continue;
            IpMo ipMo = (IpMo)mo;
            try {
                ipv4Address = ipMo.getNodeIpAddress(null);
                ipv6Address = ipMo.getNodeIpv6Address(null);
            }
            catch (MoAccessException e) {
                logger.traceAbnormal(THIS_CLASS, "getIpMoAddresses(): failed to get IpMo ipAddress");
            }
        }
        int ipAddressCount = 0;
        boolean ipMoHasIpv4Address = ipv4Address != null && ipv4Address.trim().length() != 0;
        boolean ipMoHasIpv6Address = ipv6Address != null && ipv6Address.length() != 0;
        ipAddressCount += ipMoHasIpv4Address ? 1 : 0;
        String[] result = new String[ipAddressCount += ipMoHasIpv6Address ? 1 : 0];
        int currentIpIndex = 0;
        if (ipMoHasIpv4Address) {
            result[currentIpIndex++] = ipv4Address;
            logger.traceDebug(THIS_CLASS, "Found ipv4 address: " + ipv4Address);
        }
        if (ipMoHasIpv6Address) {
            result[currentIpIndex++] = ipv6Address;
            logger.traceDebug(THIS_CLASS, "Found ipv6 address: " + ipv6Address);
        }
        logger.traceReturn(THIS_CLASS, "getIpMoAddresses()");
        return result;
    }

    public static String[] getCheckForHostLinkDynamicIpAddresses(MoRepositoryWrapper moRepository, String[] ipAddresses, int dynamicConfigurationType) {
        logger.traceEnter(THIS_CLASS, "getCheckForHostLinkDynamicIpAddresses()");
        boolean[] addressFound = new boolean[ipAddresses.length];
        for (int ipAddressIndex = 0; ipAddressIndex < addressFound.length; ++ipAddressIndex) {
            addressFound[ipAddressIndex] = false;
        }
        IpHostLinkMo[] ipHostLinkIkeMOs = MoRepositoryHelper.getDynamicIpHostLinkMOs(moRepository, dynamicConfigurationType);
        int numberOfIpAddressesFound = 0;
        for (int hostLinkIndex = 0; hostLinkIndex < ipHostLinkIkeMOs.length; ++hostLinkIndex) {
            String[] hostLinkMoAddresses = MoRepositoryHelper.getHostLinkAddresses(ipHostLinkIkeMOs[hostLinkIndex]);
            for (int hostLinkAddressIndex = 0; hostLinkMoAddresses != null && hostLinkAddressIndex < hostLinkMoAddresses.length; ++hostLinkAddressIndex) {
                for (int ipAddressIndex = 0; ipAddressIndex < ipAddresses.length; ++ipAddressIndex) {
                    if (!ipAddresses[ipAddressIndex].equals(hostLinkMoAddresses[hostLinkAddressIndex])) continue;
                    ++numberOfIpAddressesFound;
                    addressFound[ipAddressIndex] = true;
                    logger.traceDebug(THIS_CLASS, "Found address: " + addressFound[ipAddressIndex]);
                }
            }
        }
        String[] result = new String[numberOfIpAddressesFound];
        int resultIndex = 0;
        for (int ipAddressIndex = 0; ipAddressIndex < addressFound.length; ++ipAddressIndex) {
            if (!addressFound[ipAddressIndex]) continue;
            result[resultIndex++] = ipAddresses[ipAddressIndex];
            logger.traceDebug(THIS_CLASS, "Returned address: " + ipAddresses[ipAddressIndex]);
        }
        logger.traceReturn(THIS_CLASS, "getCheckForHostLinkDynamicIpAddresses()");
        return result;
    }

    public static String[] getHostLinkAddresses(IpHostLinkMo ipHostLinkMo) {
        int i;
        logger.traceEnter(THIS_CLASS, "getHostLinkAddresses()");
        logger.traceDebug(THIS_CLASS, "");
        String[] ipv4Addresses = null;
        try {
            ipv4Addresses = ipHostLinkMo.getIpv4Addresses(null);
        }
        catch (MoAccessException e1) {
            logger.traceAbnormal(THIS_CLASS, "Could not get hostLink ipv4Addresses.");
        }
        if (ipv4Addresses == null) {
            ipv4Addresses = new String[]{};
        }
        logger.traceDebug(THIS_CLASS, "Found " + ipv4Addresses.length + " ipv4 addresses");
        Struct[] ipv6AddressStructs = null;
        try {
            ipv6AddressStructs = ipHostLinkMo.getIpv6Addresses(null);
        }
        catch (MoAccessException e1) {
            logger.traceAbnormal(THIS_CLASS, "Could not get hostLink ipv6Addresses.");
        }
        if (ipv6AddressStructs == null) {
            ipv6AddressStructs = new Struct[]{};
        }
        logger.traceDebug(THIS_CLASS, "Found " + ipv6AddressStructs.length + " ipv6 addresses");
        String[] ipv6Addresses = new String[ipv6AddressStructs.length];
        int successfullyConvertedIpv6Addresses = 0;
        for (int i2 = 0; i2 < ipv6AddressStructs.length; ++i2) {
            try {
                String ipv6Address = (String)ipv6AddressStructs[i2].getValue("ipAddress");
                logger.traceDebug(THIS_CLASS, "Converted ipv6AddressStruct: " + ipv6Address);
                ipv6Addresses[successfullyConvertedIpv6Addresses++] = ipv6Address;
                continue;
            }
            catch (Exception e) {
                logger.traceAbnormal(THIS_CLASS, "Could not get ip address from Ipv6AddressInfo struct.");
            }
        }
        String[] result = new String[ipv4Addresses.length + successfullyConvertedIpv6Addresses];
        int ipAddressIndex = 0;
        for (i = 0; i < ipv4Addresses.length; ++i) {
            result[ipAddressIndex++] = ipv4Addresses[i];
            logger.traceDebug(THIS_CLASS, "Returned address: " + ipv4Addresses[i]);
        }
        for (i = 0; i < successfullyConvertedIpv6Addresses; ++i) {
            result[ipAddressIndex++] = ipv6Addresses[i];
            logger.traceDebug(THIS_CLASS, "Returned address: " + ipv6Addresses[i]);
        }
        logger.traceReturn(THIS_CLASS, "getHostLinkAddresses()");
        return result;
    }

    public static IpHostLinkMo[] getDynamicIpHostLinkMOs(MoRepositoryWrapper moRepository, int dynamicConfigurationType) {
        logger.traceEnter(THIS_CLASS, "getDynamicIpHostLinkMOs()");
        MoIterator moIterator = moRepository.lookupType("IpHostLink");
        ArrayList<ManagedObject> foundMOs = new ArrayList<ManagedObject>();
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject mo = moIterator.nextMo();
            if (!(mo instanceof IpHostLinkMo)) continue;
            IpHostLinkMo ipHostLinkMo = (IpHostLinkMo)mo;
            logger.traceDebug(THIS_CLASS, "Found IpHostLinkMo ");
            ManagedObject ipInterfaceMo = null;
            try {
                ipInterfaceMo = ipHostLinkMo.getIpInterfaceMoRef(null);
            }
            catch (MoAccessException e1) {
                logger.traceAbnormal(THIS_CLASS, "Failed to get ipInterfaceMoRef ");
            }
            if (ipInterfaceMo == null || (dynamicConfigurationType != 0 || !(ipInterfaceMo instanceof VpnInterfaceMo)) && (dynamicConfigurationType != 1 || !(ipInterfaceMo instanceof IpInterfaceMo))) continue;
            logger.traceDebug(THIS_CLASS, "Found IpHostLinkMo for dynamic configuration");
            String interfaceType = "VpnInterface";
            try {
                if (dynamicConfigurationType == 0) {
                    VpnInterfaceMo vpnInterfaceMo = (VpnInterfaceMo)ipInterfaceMo;
                    if (vpnInterfaceMo.getConfigurationMode(null) != 1) continue;
                    logger.traceDebug(THIS_CLASS, "Found IpHostLinkMo with VpnInterfaceMo and configuration mode IKE");
                    foundMOs.add(mo);
                    continue;
                }
                interfaceType = "IpInterface";
                IpInterfaceMo interfaceMo = (IpInterfaceMo)ipInterfaceMo;
                if (interfaceMo.getConfigurationMode(null) != 1) continue;
                logger.traceDebug(THIS_CLASS, "Found IpHostLinkMo with IpInterfaceMo and configuration mode DHCP");
                foundMOs.add(mo);
            }
            catch (MoAccessException e) {
                logger.traceAbnormal(THIS_CLASS, "Could not get configuration mode of " + interfaceType + ".");
            }
        }
        IpHostLinkMo[] result = new IpHostLinkMo[foundMOs.size()];
        for (int hostLinkIndex = 0; hostLinkIndex < result.length; ++hostLinkIndex) {
            result[hostLinkIndex] = (IpHostLinkMo)foundMOs.get(hostLinkIndex);
        }
        logger.traceReturn(THIS_CLASS, "getDynamicIpHostLinkMOs()");
        return result;
    }

    public static int getIpHostLinkCount(MoRepositoryWrapper moRepository) {
        logger.traceEnter(THIS_CLASS, "getIpHostLinkCount()");
        MoIterator moIterator = moRepository.lookupType("IpHostLink");
        int ipHostLinkCount = 0;
        while (moIterator != null && moIterator.hasMoreElements()) {
            ++ipHostLinkCount;
            moIterator.nextMo();
        }
        logger.traceReturn(THIS_CLASS, "getIpHostLinkCount()");
        return ipHostLinkCount;
    }

    public static boolean hasDynamicConfigurationMode(MoRepositoryWrapper moRepository, String[] ipAddressesToCheck, int dynamicConfigurationModeType) {
        IpHostLinkMo[] ipHostLinksDynamic = MoRepositoryHelper.getDynamicIpHostLinkMOs(moRepository, dynamicConfigurationModeType);
        String[] addressesDynamic = MoRepositoryHelper.getCheckForHostLinkDynamicIpAddresses(moRepository, ipAddressesToCheck, dynamicConfigurationModeType);
        return ipHostLinksDynamic != null && ipHostLinksDynamic.length > 0 || addressesDynamic.length == 1;
    }
}

