/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.nodemanagementfunction;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import se.ericsson.cello.commandlog.logcontentcontrol.InspectorRepository;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.exception.ActionAlreadyInProgressException;
import se.ericsson.crbs.cat.common.exception.ActionCollisionException;
import se.ericsson.crbs.cat.common.exception.NotEnoughDiskSpaceException;
import se.ericsson.crbs.cat.common.exception.ScanNotAllowedException;
import se.ericsson.crbs.cat.common.exception.VoltageConfigurationFailedException;
import se.ericsson.crbs.cat.mao.interfaces.LogCollector;
import se.ericsson.crbs.cat.mao.nodemanagementfunction.NodeManagementFunctionMao;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.ArrayHelper;
import se.ericsson.crbs.omf.mao.commonifu.InternalErrorException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class NodeManagementFunctionMaoImpl
extends GenericMao
implements NodeManagementFunctionMao,
LogCollector,
LogContentInspector {
    private static final AbstractLogger logger = LoggingService.getLogger();
    private static final Class THIS_CLASS = NodeManagementFunctionMaoImpl.class;
    private static final String ALARM_SUPPRESSED = "alarmSuppressed";
    public static final String DEVICE_SCAN_IN_BACKGROUND = "antennaDeviceScanInBackground";
    public static final String ACTION_ANTENNA_DEVICE_SCAN = "antennaDeviceScan";
    public static final String ACTION_COLLECT_AUT_INT_LOGS = "collectAutIntLogs";
    public static final String COLLECT_TRACES = "collectTraces";
    public static final String RESULT_NOT_ENOUGH_DISK_SPACE = Integer.toString(0x1010001);
    public static final String RESULT_ACTION_ALREADY_IN_PROGRESS = Integer.toString(0x1010002);
    public static final String RESULT_ACTION_NOT_OK = Integer.toString(0x100000C);
    public static final String MAOFRO_NOT_OK = Integer.toString(1);
    public static final String RESULT_ACTION_COLLISION = Integer.toString(0x100000B);
    public static final String RESULT_ACTION_VOLTAGE_CONFIGURATION_FAILED = Integer.toString(0x100000A);

    public NodeManagementFunctionMaoImpl(ManagedObject inputParent, AttrList inputAttributes, String inputIdentity, GenericMaoContext inputGenericMaoContext, Integer inputSoftwareRevision, Coordinator inputCoordinator, InitialMaoContext inputInitialMaoContext) throws MoAccessException {
        super(inputParent, inputAttributes, inputIdentity, "NodeManagementFunction", inputGenericMaoContext, inputSoftwareRevision, inputCoordinator, inputInitialMaoContext);
        logger.traceEnter(THIS_CLASS, "NodeManagementFunctionMaoImpl() - constructor");
        logger.traceReturn(THIS_CLASS, "NodeManagementFunctionMaoImpl() - constructor");
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "NodeManagementFunction");
    }

    public NodeManagementFunctionMaoImpl(MoDataWrapper inputRecoveredData, String inputMoType, GenericMaoContext inputGenericMaoContext, InitialMaoContext inputInitialMaoContext) throws MoAccessException {
        super(inputRecoveredData, inputMoType, inputGenericMaoContext, inputInitialMaoContext);
        logger.traceEnter(THIS_CLASS, "NodeManagementFunctionMaoImpl() - recover constructor");
        logger.traceReturn(THIS_CLASS, "NodeManagementFunctionMaoImpl() - recover constructor");
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "NodeManagementFunction");
    }

    public Object getAttribute(String attributeName, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        logger.traceEnter(THIS_CLASS, "getAttribute(attributeName = " + attributeName + ")");
        Object returnObject = this.handleSpecialAttributes(attributeName);
        if (returnObject == null) {
            returnObject = super.getAttribute(attributeName, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "getAttribute(returnObject = " + returnObject + ")");
        return returnObject;
    }

    public Object[] getAttributes(String[] attributeNames, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributes(no of attributes = " + attributeNames.length + ")");
        ArrayList<String> attributeNamesList = new ArrayList<String>();
        HashMap<String, Object> depAttributes = new HashMap<String, Object>();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            Object newValue = this.handleSpecialAttributes(attributeName);
            if (newValue == null) {
                attributeNamesList.add(attributeName);
                continue;
            }
            depAttributes.put(attributeName, newValue);
        }
        Object[] myAttributes = super.getAttributes(attributeNamesList.toArray(new String[attributeNamesList.size()]), coordinator);
        logger.traceEnter(THIS_CLASS, "getAttributes()");
        return this.combineAttributeLists(attributeNames, attributeNamesList, myAttributes, depAttributes);
    }

    private Object handleSpecialAttributes(String attributeName) {
        logger.traceEnter(THIS_CLASS, "handleSpecialAttributes(attributeName = " + attributeName + ")");
        Comparable<Boolean> returnObject = null;
        if ("technicianPresent".equals(attributeName)) {
            returnObject = Boolean.FALSE;
        } else if ("indicatorState".equals(attributeName)) {
            returnObject = new Integer(2);
        } else if (ALARM_SUPPRESSED.equals(attributeName)) {
            returnObject = Boolean.FALSE;
        }
        logger.traceEnter(THIS_CLASS, "handleSpecialAttributes(returnObject = " + returnObject + ")");
        return returnObject;
    }

    public void setAttribute(String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        File dataFile;
        logger.traceEnter(THIS_CLASS, "setAttribute()");
        Object attributeValueCopy = attributeValue;
        if (ALARM_SUPPRESSED.equals(attributeName)) {
            return;
        }
        if (DEVICE_SCAN_IN_BACKGROUND.equals(attributeName) && attributeValue.equals(Boolean.TRUE) && !(dataFile = new File("/c/DeviceScanData.dat")).exists()) {
            throw new ScanNotAllowedException("NodeManagementFunction", "Background Device Scan cannot start without executing action antennaDeviceScan first.");
        }
        super.setAttribute(attributeName, attributeValueCopy, coordinator);
        logger.traceReturn(THIS_CLASS, "setAttribute()");
    }

    public void setAttributes(String[] attributeNames, Object[] attributeObjs, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttributes()");
        ArrayList<String> attributeNamesCopy = new ArrayList<String>(attributeNames.length);
        ArrayList<Object> attributeObjsCopy = new ArrayList<Object>(attributeObjs.length);
        for (int i = 0; i < attributeNames.length; ++i) {
            File dataFile;
            if (ALARM_SUPPRESSED.equals(attributeNames[i])) continue;
            attributeNamesCopy.add(attributeNames[i]);
            attributeObjsCopy.add(attributeObjs[i]);
            if (!DEVICE_SCAN_IN_BACKGROUND.equals(attributeNames[i]) || !attributeObjs[i].equals(Boolean.TRUE) || (dataFile = new File("/c/DeviceScanData.dat")).exists()) continue;
            throw new ScanNotAllowedException("NodeManagementFunction", "Background Device Scan cannot start without executing action antennaDeviceScan first.");
        }
        super.setAttributes(attributeNamesCopy.toArray(new String[attributeNamesCopy.size()]), attributeObjsCopy.toArray(), coordinator);
        logger.traceReturn(THIS_CLASS, "setAttributes()");
    }

    public void actionAntennaDeviceScan(int dataRate, String server, String path, String username, String password, int portVoltage, int portConfiguration, Coordinator coordinator) throws NotEnoughDiskSpaceException, ActionAlreadyInProgressException, MoAccessException, ScanNotAllowedException, ActionCollisionException, VoltageConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "actionAntennaDeviceScan()");
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("dataRate", new Integer(dataRate));
        parameters.put("server", server);
        String fullpath = path;
        if (!path.endsWith(".xml")) {
            if (!path.endsWith("/")) {
                fullpath = fullpath + "/";
            }
            fullpath = fullpath + this.getFullDistinguishedName() + "_DeviceScanResult.xml";
        }
        parameters.put("path", fullpath);
        parameters.put("username", username);
        parameters.put("password", password);
        parameters.put("portVoltage", new Integer(portVoltage));
        parameters.put("portConfiguration", new Integer(portConfiguration));
        try {
            if (portConfiguration != 0 && portConfiguration != 1 && portConfiguration != 2) {
                String msg = "Parameter portConfiguration needs to be 0, 1 or 2.";
                logger.traceGeneral(THIS_CLASS, "Parameter portConfiguration needs to be 0, 1 or 2.");
                throw new ValueOutOfRangeException("Parameter portConfiguration needs to be 0, 1 or 2.", "NodeManagementFunction");
            }
            this.sendActionWithCfm(ACTION_ANTENNA_DEVICE_SCAN, coordinator, parameters);
        }
        catch (FroRequestFailedException frfe) {
            String exceptionVariables = frfe.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            if (RESULT_NOT_ENOUGH_DISK_SPACE.equals(result)) {
                String msg = "Not enough disk space or connection error when executing action \"antennaDeviceScan\". Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new NotEnoughDiskSpaceException("NodeManagementFunction", msg);
            }
            if (RESULT_ACTION_ALREADY_IN_PROGRESS.equals(result)) {
                String msg = "Action \"antennaDeviceScan\" already in progress";
                logger.traceGeneral(THIS_CLASS, "Action \"antennaDeviceScan\" already in progress");
                throw new ActionAlreadyInProgressException("NodeManagementFunction", "Action \"antennaDeviceScan\" already in progress");
            }
            if (RESULT_ACTION_NOT_OK.equals(result)) {
                String msg = "Action \"antennaDeviceScan\" is not allowed.";
                logger.traceGeneral(THIS_CLASS, "Action \"antennaDeviceScan\" is not allowed.");
                throw new ScanNotAllowedException("NodeManagementFunction", "Action \"antennaDeviceScan\" is not allowed.");
            }
            if (MAOFRO_NOT_OK.equals(result)) {
                String msg = "Action \"antennaDeviceScan\" is not allowed.";
                logger.traceGeneral(THIS_CLASS, "Action \"antennaDeviceScan\" is not allowed.");
                throw new InternalErrorException("NodeManagementFunction", "Internal error for " + this.getLocalDistinguishedName());
            }
            if (RESULT_ACTION_COLLISION.equals(result)) {
                String msg = "Action \"antennaDeviceScan\" cannot be run at the same time as \"downloadSoftware\" of AntennaNearUnit MO.";
                logger.traceGeneral(THIS_CLASS, "Action \"antennaDeviceScan\" cannot be run at the same time as \"downloadSoftware\" of AntennaNearUnit MO.");
                throw new ActionCollisionException("NodeManagementFunction", "Action \"antennaDeviceScan\" cannot be run at the same time as \"downloadSoftware\" of AntennaNearUnit MO.");
            }
            if (RESULT_ACTION_VOLTAGE_CONFIGURATION_FAILED.equals(result)) {
                String msg = "Action \"antennaDeviceScan\" cannot be run. Voltage setting has been rejected by Radio Unit.";
                logger.traceGeneral(THIS_CLASS, "Action \"antennaDeviceScan\" cannot be run. Voltage setting has been rejected by Radio Unit.");
                throw new VoltageConfigurationFailedException("NodeManagementFunction", "Action \"antennaDeviceScan\" cannot be run. Voltage setting has been rejected by Radio Unit.");
            }
            logger.traceAbnormal(THIS_CLASS, "Undefined exception received from FRO");
            throw frfe;
        }
        logger.traceReturn(THIS_CLASS, "actionAntennaDeviceScan()");
    }

    public void actionClearTechnicianPresent(Coordinator coordinator) throws MoAccessException {
        this.setReadOnlyAttribute("technicianPresent", Boolean.FALSE, coordinator);
    }

    public void actionCollectAutIntLogs(Coordinator coordinator) throws NotEnoughDiskSpaceException, ActionAlreadyInProgressException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionCollectAutIntLogs(" + coordinator + ")");
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("llog", "llog -l > /c/logfiles/autointegration/llog_output.log");
        parameters.put("ps", "ps -w > /c/logfiles/autointegration/ps_output.log");
        parameters.put("jdumpthreads", "jdumpthreads > /c/logfiles/autointegration/jdumpthreads.log");
        File autoIntegrationDirectory = new File("/c/logfiles/autointegration");
        if (!autoIntegrationDirectory.exists()) {
            autoIntegrationDirectory.mkdir();
        }
        try {
            this.sendActionWithCfm(ACTION_COLLECT_AUT_INT_LOGS, null, parameters);
        }
        catch (FroRequestFailedException frfe) {
            String exceptionVariables = frfe.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            if (RESULT_NOT_ENOUGH_DISK_SPACE.equals(result)) {
                String msg = "Not enough disk space when executing action \"collectAutIntLogs\". Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new NotEnoughDiskSpaceException("NodeManagementFunction", msg);
            }
            if (RESULT_ACTION_ALREADY_IN_PROGRESS.equals(result)) {
                String msg = "Action \"collectAutIntLogs\" already in progress";
                logger.traceGeneral(THIS_CLASS, "Action \"collectAutIntLogs\" already in progress");
                throw new ActionAlreadyInProgressException("NodeManagementFunction", "Action \"collectAutIntLogs\" already in progress");
            }
            logger.traceAbnormal(THIS_CLASS, "Undefined result received in exception from FRO [" + result + "]");
            throw frfe;
        }
        logger.traceReturn(THIS_CLASS, "actionCollectAutIntLogs()");
    }

    public void actionCollectTraces(Coordinator coordinator) throws ActionAlreadyInProgressException, NotEnoughDiskSpaceException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionCollectTraces()");
        try {
            this.sendActionWithCfm(COLLECT_TRACES, coordinator, new TreeMap());
        }
        catch (FroRequestFailedException frfe) {
            String exceptionVariables = frfe.getVariablesAsString();
            String result = this.getResultFromString(exceptionVariables);
            if (RESULT_NOT_ENOUGH_DISK_SPACE.equals(result)) {
                String msg = "Not enough disk space. Caught exception = " + (Object)((Object)frfe);
                logger.traceAbnormal(THIS_CLASS, msg);
                throw new NotEnoughDiskSpaceException("NodeManagementFunction", msg);
            }
            if (RESULT_ACTION_ALREADY_IN_PROGRESS.equals(result)) {
                String msg = "Action \"collectTraces\" already in progress";
                logger.traceGeneral(THIS_CLASS, "Action \"collectTraces\" already in progress");
                throw new ActionAlreadyInProgressException("NodeManagementFunction", "Action \"collectTraces\" already in progress");
            }
            logger.traceAbnormal(THIS_CLASS, "Undefined exception recieved from FRO");
            throw frfe;
        }
        logger.traceReturn(THIS_CLASS, "actionCollectTraces()");
    }

    protected Object[] combineAttributeLists(String[] originalAttributeNames, List newAttributeNamesList, Object[] newAttributeValues, Map deprecatedValues) {
        logger.traceEnter(THIS_CLASS, "combineAttributeLists()");
        ArrayList<Object> originalAttributeValues = new ArrayList<Object>();
        for (int i = 0; i < originalAttributeNames.length; ++i) {
            String currentAttributeName = originalAttributeNames[i];
            int indexOf = newAttributeNamesList.indexOf(currentAttributeName);
            if (indexOf >= 0) {
                originalAttributeValues.add(newAttributeValues[indexOf]);
                continue;
            }
            originalAttributeValues.add(deprecatedValues.get(currentAttributeName));
        }
        logger.traceReturn(THIS_CLASS, "combineAttributeLists()");
        return originalAttributeValues.toArray(new Object[originalAttributeValues.size()]);
    }

    public Object[] hideHazardousActionParameters(String actionName, Object[] parameters) {
        logger.traceEnter(THIS_CLASS, "hideHazardousActionParameters() action: " + actionName);
        Object[] result = null;
        if (ACTION_ANTENNA_DEVICE_SCAN.equalsIgnoreCase(actionName)) {
            result = ArrayHelper.replaceObject((Object[])parameters, (int)4, (Object)"[HIDDEN]");
        }
        logger.traceReturn(THIS_CLASS, "hideHazardousActionParameters()");
        return result;
    }

    public Object[] hideHazardousAttributeValues(AttrList attrlist) {
        return null;
    }
}

