/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.pic.signals;

import enea.ose.io.SignalInputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class OmfMaoPicCompatibilityListReqOseSignal
extends UnlinkedSignal {
    private static final Class THIS_CLASS = OmfMaoPicCompatibilityListReqOseSignal.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected int clientRef;
    protected int serverRef;
    protected String ruDataXml = "";
    protected String compatibilityListXml = "";
    protected String runningLmcInfo = "";

    public OmfMaoPicCompatibilityListReqOseSignal() {
        super(24379924);
    }

    protected void initReceive() {
        SignalInputStream sis = this.getTheSignalInputStream();
        try {
            int toRead;
            int noOfReadBytes;
            this.clientRef = sis.readS32();
            this.serverRef = sis.readS32();
            int ruDataLength = sis.readS32();
            int compListLength = sis.readS32();
            int runningLmcInfoLength = sis.readS32();
            sis.readS32();
            int totalLength = ruDataLength + compListLength + runningLmcInfoLength;
            byte[] buffer = new byte[totalLength];
            int offset = 0;
            for (toRead = totalLength; toRead > 0; toRead -= noOfReadBytes) {
                noOfReadBytes = sis.read(buffer, offset, toRead);
                if (noOfReadBytes == -1) {
                    logger.traceError(THIS_CLASS, toRead + " bytes left to read from signal data but got EOF");
                    break;
                }
                offset += noOfReadBytes;
            }
            if (toRead <= 0) {
                this.ruDataXml = new String(buffer, 0, ruDataLength);
                this.compatibilityListXml = new String(buffer, ruDataLength, compListLength);
                this.runningLmcInfo = new String(buffer, ruDataLength + compListLength, runningLmcInfoLength);
                logger.traceGeneral(THIS_CLASS, "Received RU data XML is: " + this.ruDataXml);
                logger.traceGeneral(THIS_CLASS, "Received compatibility list XML is: " + this.compatibilityListXml);
                logger.traceGeneral(THIS_CLASS, "Received running LMC info is: " + this.runningLmcInfo);
            } else {
                logger.traceError(THIS_CLASS, "Read only " + offset + " bytes of requested " + totalLength);
            }
        }
        catch (IOException e) {
            logger.traceError(THIS_CLASS, "Can't read signal data" + e.toString());
        }
    }

    protected SignalInputStream getTheSignalInputStream() {
        return super.getSignalInputStream();
    }

    protected void initSend() {
        logger.traceError(THIS_CLASS, "initSend is not implemented");
    }

    public int getClientRef() {
        return this.clientRef;
    }

    public void setClientRef(int inputClientRef) {
        this.clientRef = inputClientRef;
    }

    public int getServerRef() {
        return this.serverRef;
    }

    public void setServerRef(int inputServerRef) {
        this.serverRef = inputServerRef;
    }

    public String getRuXmlData() {
        return this.ruDataXml;
    }

    public String getCompatibilityListXmlData() {
        return this.compatibilityListXml;
    }

    public String getRunningLmcInfoData() {
        return this.runningLmcInfo;
    }
}

