/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rilink;

import java.util.Map;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rilink.RiLinkMao;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class RiLinkMaoImpl
extends GenericMao
implements RiLinkMao {
    private static final String RESERVED_BY = "reservedBy";
    public static final String RI_PORT_REF1 = "riPortRef1";
    public static final String RI_PORT_REF2 = "riPortRef2";
    private static final Class THIS_CLASS = RiLinkMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String RI_PORT_B1_RDN = "RiPort=B1";
    private static final String RI_PORT_B2_RDN = "RiPort=B2";

    public RiLinkMaoImpl(ManagedObject parent, AttrList attributes, String identity, GenericMaoContext aGenericMaoContext, Integer softwareRevision, Coordinator coordinator, InitialMaoContext initialmaocontext) throws MoAccessException {
        super(parent, attributes, identity, "RiLink", aGenericMaoContext, softwareRevision, coordinator, initialmaocontext);
        String rdn;
        ManagedObject riPortRef1 = (ManagedObject)this.getAttribute(RI_PORT_REF1, coordinator);
        ManagedObject riPortRef2 = (ManagedObject)this.getAttribute(RI_PORT_REF2, coordinator);
        if (riPortRef1.getLocalDistinguishedName().equals(riPortRef2.getLocalDistinguishedName()) && !RI_PORT_B1_RDN.equals(rdn = riPortRef1.getRelativeDistinguishedName()) && !RI_PORT_B2_RDN.equals(rdn)) {
            throw new ResourceUnavailableException("RiLink", "It is not allowed to set the same RiPort as RiPortRef1 and RiPortRef2: " + riPortRef1.getLocalDistinguishedName());
        }
        this.checkRiPortIsNotUsed(riPortRef1, coordinator);
        this.checkRiPortIsNotUsed(riPortRef2, coordinator);
    }

    public RiLinkMaoImpl(MoDataWrapper recoveredData, String moType, GenericMaoContext aGenericMaoContext, InitialMaoContext initialmaocontext) throws MoNameAlreadyTakenException, MoAccessException {
        super(recoveredData, moType, aGenericMaoContext, initialmaocontext);
    }

    public Object preSet(String attributeName, Map attributes, Object value, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSet(" + attributeName + ", " + attributes + ", " + value + ", " + coordinator + ")");
        if (RI_PORT_REF1.equals(attributeName) || RI_PORT_REF2.equals(attributeName)) {
            ManagedObject otherRiPort;
            ManagedObject newRiPort = (ManagedObject)value;
            ManagedObject managedObject = otherRiPort = RI_PORT_REF1.equals(attributeName) ? (ManagedObject)this.getAttribute(RI_PORT_REF2, coordinator) : (ManagedObject)this.getAttribute(RI_PORT_REF1, coordinator);
            if (otherRiPort.getLocalDistinguishedName().equals(newRiPort.getLocalDistinguishedName())) {
                String rdn = newRiPort.getRelativeDistinguishedName();
                if (!RI_PORT_B1_RDN.equals(rdn) && !RI_PORT_B2_RDN.equals(rdn)) {
                    throw new ResourceUnavailableException("RiLink", "It is not allowed to set the same RiPort as RiPortRef1 and RiPortRef2: " + newRiPort.getLocalDistinguishedName());
                }
            } else {
                this.checkRiPortIsNotUsed(newRiPort, coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "preSet()");
        return value;
    }

    public void postSet(String attributeName, Object value, Coordinator coordinator) throws MoAccessException {
        ManagedObject otherRiPort;
        ManagedObject[] reservedBY;
        logger.traceEnter(THIS_CLASS, "postSet(" + attributeName + ", " + attributeName + ", " + value + ", " + coordinator + ")");
        if ((RI_PORT_REF1.equals(attributeName) || RI_PORT_REF2.equals(attributeName)) && ((reservedBY = (ManagedObject[])(otherRiPort = RI_PORT_REF1.equals(attributeName) ? (ManagedObject)this.getAttribute(RI_PORT_REF2, coordinator) : (ManagedObject)this.getAttribute(RI_PORT_REF1, coordinator)).getAttribute(RESERVED_BY, coordinator)) == null || reservedBY.length == 0)) {
            ((Reservable)otherRiPort).reserve((ManagedObject)this, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "postSet()");
    }

    private void checkRiPortIsNotUsed(ManagedObject riPort, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        ManagedObject[] reservedBy = (ManagedObject[])riPort.getAttribute(RESERVED_BY, coordinator);
        if (reservedBy != null && reservedBy.length > 0) {
            for (int i = 0; i < reservedBy.length; ++i) {
                if (!"RiLink".equals(reservedBy[i].getType()) || reservedBy[i].getLocalDistinguishedName().equals(this.getLocalDistinguishedName())) continue;
                throw new ResourceUnavailableException("RiLink", "This RiPort is already in use by another RiLink; RiPort:" + riPort.getLocalDistinguishedName() + ";RiLink:" + reservedBy[i].getLocalDistinguishedName());
            }
        }
    }
}

