/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.sectorequipmentfunction;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.crbs.cat.mao.sectorequipmentfunction.SectorEquipmentFunctionMao;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.validation.MoAttrNotSettableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;

public class SectorEquipmentFunctionMaoImpl
extends GenericMao
implements SectorEquipmentFunctionMao {
    private static final Class THIS_CLASS = SectorEquipmentFunctionMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String MO_TYPE_SECTOR_CARRIER = "SectorCarrier";
    public static final String CONFIGURED_OUTPUT_POWER = "configuredOutputPower";
    public static final String AVAILABLE_SECTOR_POWER = "availableSectorPower";
    public static final String TX_POWER_PERSISTENT_LOCK = "txPowerPersistentLock";
    public static final String SECTOR_CARRIER_TYPE = "SectorCarrier";
    public static final String SECTOR_FUNCTION_REF = "sectorFunctionRef";
    public static final String ADMINISTRATIVE_STATE_ATTR = "administrativeState";
    private static final Integer LOCK = new Integer(0);
    private static final int SHUTTING_DOWN = 2;
    private static final Object MUTEX = new Object();

    public SectorEquipmentFunctionMaoImpl(ManagedObject parent, AttrList attributes, String identity, GenericMaoContext inputGenericMaoContext, Integer softwareRevision, Coordinator coordinator, InitialMaoContext initialmaocontext) throws MoAccessException {
        super(parent, SectorEquipmentFunctionMaoImpl.checkAndCorrectTxPowerPersistentLock(attributes), identity, "SectorEquipmentFunction", inputGenericMaoContext, softwareRevision, coordinator, initialmaocontext);
        logger.traceEnter(THIS_CLASS, "SectorEquipmentFunctionMaoImpl() - constructor");
        logger.traceReturn(THIS_CLASS, "SectorEquipmentFunctionMaoImpl() - constructor");
    }

    public SectorEquipmentFunctionMaoImpl(MoDataWrapper recoveredData, String moType, GenericMaoContext inputGenericMaoContext, InitialMaoContext initialmaocontext) throws MoNameAlreadyTakenException, MoAccessException {
        super(recoveredData, moType, inputGenericMaoContext, initialmaocontext);
        logger.traceEnter(THIS_CLASS, "SectorEquipmentFunctionMaoImpl() - reconstructor");
        logger.traceReturn(THIS_CLASS, "SectorEquipmentFunctionMaoImpl() - reconstructor");
    }

    public void delete(Coordinator coordinator) throws MoAccessException, ProcessingFailureException {
        logger.traceEnter(this.getClass(), "delete()");
        boolean isTxPowerLockActivated = (Boolean)super.getAttribute(TX_POWER_PERSISTENT_LOCK, coordinator);
        if (isTxPowerLockActivated) {
            String reason = "MO cannot be deleted, because txPowerPersistentLock is set as true";
            logger.traceDebug(THIS_CLASS, "Cannot delete MO. UndeletableMoException: MO cannot be deleted, because txPowerPersistentLock is set as true");
            throw new UndeletableMoException((ManagedObject)this, "MO cannot be deleted, because txPowerPersistentLock is set as true");
        }
        ManagedObject[] reservedBy = (ManagedObject[])this.getAttribute("reservedBy", coordinator);
        for (int i = 0; i < reservedBy.length; ++i) {
            ManagedObject[] reservedBySectorCarrier;
            ManagedObject currReservedBy = reservedBy[i];
            if (!"SectorCarrier".equalsIgnoreCase(currReservedBy.getType()) || 0 != (reservedBySectorCarrier = (ManagedObject[])currReservedBy.getAttribute("reservedBy", coordinator)).length) continue;
            logger.traceDebug(this.getClass(), "delete() delete orphan SectorCarrier Mo" + currReservedBy.getLocalDistinguishedName());
            currReservedBy.delete(coordinator);
        }
        super.delete(coordinator);
        logger.traceReturn(this.getClass(), "delete()");
    }

    public AttrList addFroParametersAtCreate(AttrList signalParameters, AttrList clientProvidedParameters, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "addFroParametersAtCreate()");
        AttrListImpl result = new AttrListImpl(this.genericMaoContext.getMoRepositoryWrapper());
        for (int i = 0; i < signalParameters.size(); ++i) {
            result.addAttribute(signalParameters.getName(i), signalParameters.getValue(i));
        }
        logger.traceReturn(THIS_CLASS, "addFroParametersAtCreate()");
        return result;
    }

    public void setAttribute(String attributeName, Object attributeValue, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttribute()");
        if (ADMINISTRATIVE_STATE_ATTR.equals(attributeName)) {
            int value = (Integer)attributeValue;
            if (value == 2) {
                super.setAttribute(ADMINISTRATIVE_STATE_ATTR, (Object)LOCK, coordinator);
            } else {
                super.setAttribute(attributeName, attributeValue, coordinator);
            }
        } else if (CONFIGURED_OUTPUT_POWER.equals(attributeName)) {
            boolean isTxPowerLockActivated = (Boolean)super.getAttribute(TX_POWER_PERSISTENT_LOCK, coordinator);
            if (isTxPowerLockActivated) {
                String reason = "Attribute configuredOutputPower cannot be changed, because txPowerPersistentLock is set as true";
                logger.info(THIS_CLASS, "Cannot set configuredOutputPower. MoAttrNotSettableException: Attribute configuredOutputPower cannot be changed, because txPowerPersistentLock is set as true");
                throw new MoAttrNotSettableException(this.getType(), attributeName, "Attribute configuredOutputPower cannot be changed, because txPowerPersistentLock is set as true");
            }
            super.setAttribute(attributeName, attributeValue, coordinator);
        } else if (TX_POWER_PERSISTENT_LOCK.equals(attributeName)) {
            int configuredOutputPower = (Integer)super.getAttribute(CONFIGURED_OUTPUT_POWER, coordinator);
            boolean isTxPowerLockActivated = (Boolean)super.getAttribute(TX_POWER_PERSISTENT_LOCK, coordinator);
            if (isTxPowerLockActivated && Boolean.FALSE.equals(attributeValue)) {
                String reason = "Attribute txPowerPersistentLock cannot be changed, because is set as true";
                logger.info(THIS_CLASS, "Cannot set txPowerPersistentLock. MoAttrNotSettableException: Attribute txPowerPersistentLock cannot be changed, because is set as true");
                throw new MoAttrNotSettableException(this.getType(), attributeName, "Attribute txPowerPersistentLock cannot be changed, because is set as true");
            }
            if (attributeValue.equals(Boolean.TRUE) && configuredOutputPower > 10000) {
                String reason = "Attribute txPowerPersistentLock cannot be set, because configuredOutputPower > 10000";
                logger.info(THIS_CLASS, "Cannot set txPowerPersistentLock. ProcessingFailureException: Attribute txPowerPersistentLock cannot be set, because configuredOutputPower > 10000");
                throw new ProcessingFailureException("Attribute txPowerPersistentLock cannot be set, because configuredOutputPower > 10000");
            }
            super.setAttribute(attributeName, attributeValue, coordinator);
            MoIterator sectorCarriers = this.genericMaoContext.getMoRepositoryWrapper().lookupType("SectorCarrier");
            if (sectorCarriers != null) {
                while (sectorCarriers.hasMoreElements()) {
                    ManagedObject mo;
                    ManagedObject sectorCarrier = sectorCarriers.nextMo();
                    Object object = sectorCarrier.getAttribute(SECTOR_FUNCTION_REF, coordinator);
                    if (object == null || !(object instanceof ManagedObject) || !(mo = (ManagedObject)object).getLocalDistinguishedName().equals(this.getLocalDistinguishedName())) continue;
                    sectorCarrier.setAttribute(TX_POWER_PERSISTENT_LOCK, attributeValue, coordinator);
                }
            }
        } else {
            super.setAttribute(attributeName, attributeValue, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setAttribute()");
    }

    public void setAttributes(String[] attributeNames, Object[] attributeValues, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAttributes()");
        for (int i = 0; i < attributeNames.length; ++i) {
            if (ADMINISTRATIVE_STATE_ATTR.equals(attributeNames[i]) || CONFIGURED_OUTPUT_POWER.equals(attributeNames[i]) || TX_POWER_PERSISTENT_LOCK.equals(attributeNames[i])) {
                this.setAttribute(attributeNames[i], attributeValues[i], coordinator);
                continue;
            }
            super.setAttribute(attributeNames[i], attributeValues[i], coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setAttributes()");
    }

    public final Object getAttribute(String attributeName, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttribute()");
        Object result = super.getAttribute(attributeName, coordinator);
        logger.traceReturn(THIS_CLASS, "getAttribute()");
        return result;
    }

    public Object[] getAttributes(String[] attrNames, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributes()");
        this.preGetAttributes(attrNames, coordinator);
        Object[] result = new Object[attrNames.length];
        for (int i = 0; i < attrNames.length; ++i) {
            result[i] = super.getAttribute(attrNames[i], coordinator);
        }
        logger.traceReturn(THIS_CLASS, "getAttributes()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parameterChanged(String attributeName, Object attributeValue) {
        logger.traceEnter(THIS_CLASS, "parameterChanged()");
        if (ADMINISTRATIVE_STATE_ATTR.equals(attributeName)) {
            int value = (Integer)attributeValue;
            if (value == 2) {
                super.parameterChanged(attributeName, (Object)new Integer(0));
            } else {
                super.parameterChanged(attributeName, attributeValue);
            }
        } else if (TX_POWER_PERSISTENT_LOCK.equals(attributeName)) {
            Object object = MUTEX;
            synchronized (object) {
                try {
                    Control control = this.getTranscationFactory();
                    Coordinator coordinator = control.getCoordinator();
                    super.setAttribute(attributeName, attributeValue, coordinator);
                    control.getTerminator().commit();
                }
                catch (MoAccessException e) {
                    logger.traceError(THIS_CLASS, e.getMessage());
                }
                catch (TransactionRolledBackException e) {
                    logger.traceError(THIS_CLASS, e.getMessage());
                }
                catch (InactiveTransactionException e) {
                    logger.traceError(THIS_CLASS, e.getMessage());
                }
                return;
            }
        }
        super.parameterChanged(attributeName, attributeValue);
        logger.traceReturn(THIS_CLASS, "parameterChanged()");
    }

    private static AttrList checkAndCorrectTxPowerPersistentLock(AttrList arguments) throws MoAccessException {
        if (arguments != null) {
            int indexOfTxPowerLock = arguments.indexOf(TX_POWER_PERSISTENT_LOCK);
            int indexConfiguredOutputPower = arguments.indexOf(CONFIGURED_OUTPUT_POWER);
            if (indexOfTxPowerLock >= 0 && indexConfiguredOutputPower >= 0 && ((Boolean)arguments.getValue(indexOfTxPowerLock)).booleanValue() && (Integer)arguments.getValue(indexConfiguredOutputPower) > 10000) {
                logger.traceAbnormal(THIS_CLASS, "Attribute txPowerPersistentLock has been changed to false during creation of MO.");
                arguments.removeElementAt(indexOfTxPowerLock);
                if (arguments instanceof AttrListImpl) {
                    ((AttrListImpl)arguments).addAttribute(TX_POWER_PERSISTENT_LOCK, (Object)Boolean.FALSE);
                }
            }
        }
        return arguments;
    }

    private Control getTranscationFactory() {
        Control control = null;
        try {
            TransactionFactory transFact = this.genericMaoContext.getTransactionServicesFactory().getCppTransactionFactory();
            control = transFact.create(0);
        }
        catch (TransactionRolledBackException trbe) {
            logger.traceError(THIS_CLASS, "Failed to create (temp) transaction. Reason: " + trbe.reason, (Throwable)trbe);
        }
        return control;
    }
}

