/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.ulspectrumanalyzer;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.exception.ActionAlreadyInProgressException;
import se.ericsson.crbs.cat.common.exception.NoLicenseException;
import se.ericsson.crbs.cat.mao.ulspectrumanalyzer.UlSpectrumAnalyzerMao;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.LengthOutOfRangeException;
import se.ericsson.crbs.omf.mao.commonmo.NoConnectionWithUnitException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.commonmo.StructImpl;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapperFactoryFactory;

public class UlSpectrumAnalyzerMaoImpl
extends GenericMao
implements UlSpectrumAnalyzerMao {
    private static final Class THIS_CLASS = UlSpectrumAnalyzerMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ATTRIBUTE_TARGET_RF_PORT = "targetRfPort";
    private static final String ATTRIBUTE_TARGET_RADIO_UNIT = "targetRadioUnit";
    private static final String ATTRIBUTE_IP_ADDRESS = "ipAddress";
    private static final String ATTRIBUTE_USER_NAME = "username";
    private static final String ATTRIBUTE_PASSWORD = "password";
    private static final String ATTRIBUTE_UPLOAD_DIRECTORY = "uploadDirectory";
    private static final String ATTRIBUTE_SAMPLING_TYPE = "samplingType";
    private static final String ATTRIBUTE_CENTER_FREQUENCY = "centerFrequency";
    private static final String ATTRIBUTE_DISPLAYED_BANDWIDTH = "displayedBandwidth";
    private static final String ATTRIBUTE_RESOLUTION_BANDWIDTH = "resolutionBandwidth";
    private static final String ATTRIBUTE_SAMPLING_INTERVAL = "samplingInterval";
    private static final String ATTRIBUTE_SAMPLING_TIME_OUT = "samplingTimeout";
    private static final String ATTRIBUTE_TRIGGER_TIME_OF_DAY = "triggerTimeOfDay";
    private static final String ATTRIBUTE_POWER_LEVEL = "powerLevel";
    private static final String ATTRIBUTE_ULSA_SAMPLING_STATUS = "ulSpectrumSamplingStatus";
    private static final String STOP_UL_SPECTRUM_SAMPLING = "stopUlsaSampling";
    private static final String GET_UL_SPECTRUM_SAMPLING_CAPABILITY = "getUlsaSamplingCapability";
    private static final String START_UL_SPECTRUM_SAMPLING = "startUlsaSampling";
    private static final int STARTED = 1;
    private static final int SERVICE_STATE = 1;
    private static final int CONDITIONAL_SAMPLING = 2;
    private static final int CONTINUOUS_SAMPLING = 1;
    private static final String OPTIONAL_FEATURE_MO_LDN = "ManagedElement=1,SystemFunctions=1,Licensing=1,OptionalFeatureLicense=UlSpectrumAnalyzer";
    private static final String TRIGGER1DATADEFINED1 = "trigger1DataDefined1";
    private static final String TRIGGER1DATADEFINED2 = "trigger1DataDefined2";
    private static final int ATTRIBUTE_SAMPLING_TIME_OUT_FAULT_RANGE_MIN = 10;
    private static final int ATTRIBUTE_SAMPLING_TIME_OUT_FAULT_RANGE_MAX = 7200;
    private final MoRepositoryWrapper aMoRepository;
    private String auxLdn = null;
    private static final String MANAGED_ELEMENT = "ManagedElement=1,";

    public UlSpectrumAnalyzerMaoImpl(ManagedObject parent, AttrList attributes, String identity, GenericMaoContext aGenericMaoContext, Integer softwareRevision, Coordinator coordinator, InitialMaoContext initialmaocontext) throws MoAccessException {
        super(parent, attributes, identity, "UlSpectrumAnalyzer", aGenericMaoContext, softwareRevision, coordinator, initialmaocontext);
        logger.traceEnter(THIS_CLASS, "UlSpectrumAnalyzerMaoImpl()");
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
        logger.traceReturn(THIS_CLASS, "UlSpectrumAnalyzerMaoImpl()");
    }

    public UlSpectrumAnalyzerMaoImpl(MoDataWrapper recoveredData, String moType, GenericMaoContext aGenericMaoContext, InitialMaoContext initialmaocontext) throws MoNameAlreadyTakenException, MoAccessException {
        super(recoveredData, moType, aGenericMaoContext, initialmaocontext);
        logger.traceEnter(THIS_CLASS, "UlSpectrumAnalyzerMaoImpl()");
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
        logger.traceReturn(THIS_CLASS, "UlSpectrumAnalyzerMaoImpl()");
    }

    public void preCreateValidation(AttrList attributes, Coordinator coordinator) throws MoAccessException {
        ManagedObject mo = MoRepositoryWrapperFactoryFactory.getMoRepositoryWrapperFactory().getMoRepository().lookup(OPTIONAL_FEATURE_MO_LDN);
        if (mo == null) {
            throw new MoNotFoundException("UlSpectrumAnalyzer OptionalFeatureLicense MO is not available");
        }
        int ulsaServiceState = (Integer)mo.getAttribute("serviceState", coordinator);
        if (ulsaServiceState != 1) {
            throw new NoLicenseException("UlSpectrumAnalyzer", "License unavailable.");
        }
    }

    public void preDelete(Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        int samplingStatus = 0;
        Object result = this.getAttribute(ATTRIBUTE_ULSA_SAMPLING_STATUS, coordinator);
        if (result != null && (samplingStatus = ((Integer)result).intValue()) == 1) {
            String msg = "The MO cannot be deleted because there is an ongoing sampling";
            throw new ActionNotAllowedException("The MO cannot be deleted because there is an ongoing sampling", "UlSpectrumAnalyzer");
        }
    }

    public void actionStopUlsaSampling(String targetRfPort, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionStopUlsaSampling()");
        String rfPort = null;
        int samplingType = 0;
        int samplingStatus = 0;
        samplingStatus = (Integer)this.getAttribute(ATTRIBUTE_ULSA_SAMPLING_STATUS, coordinator);
        if (samplingStatus == 1 && ((samplingType = ((Integer)this.getAttribute(ATTRIBUTE_SAMPLING_TYPE, coordinator)).intValue()) == 1 || samplingType == 2)) {
            samplingStatus = (Integer)this.getAttribute(ATTRIBUTE_ULSA_SAMPLING_STATUS, coordinator);
            rfPort = (String)this.getAttribute(ATTRIBUTE_TARGET_RF_PORT, coordinator);
            TreeMap<String, String> parameters = new TreeMap<String, String>();
            parameters.put(ATTRIBUTE_TARGET_RF_PORT, targetRfPort);
            targetRfPort = this.removeManagedElementfromLdn(targetRfPort);
            rfPort = this.removeManagedElementfromLdn(rfPort);
            if (rfPort.equals(targetRfPort)) {
                this.sendActionWithCfm(STOP_UL_SPECTRUM_SAMPLING, coordinator, parameters);
            } else {
                String msg = "The port to stop sampling is not the same with start sampling." + targetRfPort + " is not valid.";
                throw new ActionNotAllowedException(msg, "UlSpectrumAnalyzer");
            }
        }
        logger.traceReturn(THIS_CLASS, "actionStopUlsaSampling()");
    }

    public Struct actionGetUlsaSamplingCapability(String targetRadioUnit, Coordinator coordinator) throws MoAccessException {
        StructImpl ulSpectrumSamplingCapability;
        block8: {
            logger.traceEnter(THIS_CLASS, "actionGetUlsaSamplingCapability()");
            if (targetRadioUnit == null) {
                String msg = "The provided targetRadioUnit [" + targetRadioUnit + "] is not valid.";
                logger.traceGeneral(THIS_CLASS, msg);
                throw new IllegalAttributeValueException(msg, "UlSpectrumAnalyzer");
            }
            if (targetRadioUnit.indexOf(MANAGED_ELEMENT) >= 0) {
                this.validateAuxPlugInUnitLdn(targetRadioUnit);
            } else {
                this.validateAuxPlugInUnitLdn(MANAGED_ELEMENT + targetRadioUnit);
            }
            TreeMap<String, String> parameters = new TreeMap<String, String>();
            parameters.put(ATTRIBUTE_TARGET_RADIO_UNIT, targetRadioUnit);
            ulSpectrumSamplingCapability = new StructImpl();
            try {
                Map returnedParameters = this.sendActionWithCfm(GET_UL_SPECTRUM_SAMPLING_CAPABILITY, coordinator, parameters);
                Iterator parameterNameIterator = returnedParameters.keySet().iterator();
                while (parameterNameIterator.hasNext()) {
                    String currentAttrName = (String)parameterNameIterator.next();
                    if (TRIGGER1DATADEFINED1.equals(currentAttrName) || TRIGGER1DATADEFINED2.equals(currentAttrName)) {
                        Long trigger1DataDefined = (Long)returnedParameters.get(currentAttrName);
                        boolean trigger1Data = trigger1DataDefined != 0L;
                        ulSpectrumSamplingCapability.addElement(currentAttrName, (Object)trigger1Data);
                        continue;
                    }
                    ulSpectrumSamplingCapability.addElement(currentAttrName, returnedParameters.get(currentAttrName));
                }
            }
            catch (FroRequestFailedException e) {
                String exceptionVariables = e.getVariablesAsString();
                String result = this.getResultFromString(exceptionVariables);
                int resultInt = Integer.parseInt(result.trim());
                if (resultInt == 0x1000006 || resultInt == 1) {
                    throw new NoConnectionWithUnitException("UlSpectrumAnalyzer", "No connection with " + targetRadioUnit);
                }
                if (resultInt != 0x100000A) break block8;
                String errorText = ExceptionHelper.getErrorString((String)exceptionVariables);
                throw new NoLicenseException("UlSpectrumAnalyzer", "License unavailable: " + errorText);
            }
        }
        logger.traceReturn(THIS_CLASS, "actionGetUlsaSamplingCapability()");
        return ulSpectrumSamplingCapability;
    }

    public void actionStartUlsaSampling(String ipAddress, String username, String password, String uploadDirectory, String targetRfPort, int samplingType, int centerFrequency, int displayedBandwidth, int resolutionBandwidth, int samplingInterval, int samplingTimeout, String triggerTimeOfDay, int powerLevel, Coordinator coordinator) throws MoAccessException {
        block6: {
            logger.traceEnter(THIS_CLASS, "actionStartUlsaSampling()");
            this.checkNull(ipAddress, username, password, uploadDirectory, targetRfPort, triggerTimeOfDay);
            this.validateIpAddress(ipAddress);
            this.validateTargetRfPortAndSetAuxLdn(targetRfPort);
            if (samplingType == 1 || samplingType == 2) {
                this.validateRange(ATTRIBUTE_SAMPLING_TIME_OUT, samplingTimeout, 10, 7200);
            }
            if (samplingType == 2) {
                this.validateTriggerTimeOfDay(triggerTimeOfDay);
            }
            TreeMap<String, Object> parameters = new TreeMap<String, Object>();
            parameters.put(ATTRIBUTE_IP_ADDRESS, ipAddress);
            parameters.put(ATTRIBUTE_USER_NAME, username);
            parameters.put(ATTRIBUTE_PASSWORD, password);
            parameters.put(ATTRIBUTE_UPLOAD_DIRECTORY, uploadDirectory);
            parameters.put(ATTRIBUTE_TARGET_RF_PORT, targetRfPort);
            parameters.put(ATTRIBUTE_SAMPLING_TYPE, new Integer(samplingType));
            parameters.put(ATTRIBUTE_CENTER_FREQUENCY, new Integer(centerFrequency));
            parameters.put(ATTRIBUTE_DISPLAYED_BANDWIDTH, new Integer(displayedBandwidth));
            parameters.put(ATTRIBUTE_RESOLUTION_BANDWIDTH, new Integer(resolutionBandwidth));
            parameters.put(ATTRIBUTE_SAMPLING_INTERVAL, new Integer(samplingInterval));
            parameters.put(ATTRIBUTE_SAMPLING_TIME_OUT, new Integer(samplingTimeout));
            parameters.put(ATTRIBUTE_TRIGGER_TIME_OF_DAY, triggerTimeOfDay);
            parameters.put(ATTRIBUTE_POWER_LEVEL, new Integer(powerLevel));
            try {
                this.sendActionWithCfm(START_UL_SPECTRUM_SAMPLING, coordinator, parameters);
            }
            catch (FroRequestFailedException e) {
                String exceptionVariables = e.getVariablesAsString();
                String result = this.getResultFromString(exceptionVariables);
                int resultInt = Integer.parseInt(result.trim());
                if (resultInt == 0x1000006) {
                    throw new NoConnectionWithUnitException("UlSpectrumAnalyzer", "No connection with " + this.auxLdn);
                }
                if (resultInt == 0x100000A) {
                    throw new NoLicenseException("UlSpectrumAnalyzer", "No License available " + this.auxLdn);
                }
                if (resultInt != 0x1010002) break block6;
                throw new ActionAlreadyInProgressException("UlSpectrumAnalyzer", "Action already in progress " + this.auxLdn);
            }
        }
        logger.traceReturn(THIS_CLASS, "actionStartUlsaSampling()");
    }

    private void validateIpAddress(String ipAddress) throws IllegalAttributeValueException {
        if (!this.isIpaddressValid(ipAddress)) {
            String msg = "The provided IpAddress [" + ipAddress + "]is not valid.";
            logger.traceGeneral(THIS_CLASS, msg);
            throw new IllegalAttributeValueException("UlSpectrumAnalyzer", msg);
        }
    }

    private void checkNull(String ipAddress, String username, String password, String uploadDirectory, String targetRfPort, String triggerTimeOfDay) throws IllegalAttributeValueException {
        if (ipAddress == null || username == null || password == null || uploadDirectory == null || targetRfPort == null || triggerTimeOfDay == null) {
            String msg = "The provided value is not valid.";
            logger.traceGeneral(THIS_CLASS, "The provided value is not valid.");
            throw new IllegalAttributeValueException("The provided value is not valid.", "UlSpectrumAnalyzer");
        }
    }

    private void validateRange(String paramName, int samplingTimeout, int rangeMin, int rangeMax) throws LengthOutOfRangeException {
        if (samplingTimeout < rangeMin || samplingTimeout > rangeMax) {
            String msg = "Length of " + paramName + " not within range. Range: " + rangeMin + " - " + rangeMax;
            logger.traceGeneral(THIS_CLASS, msg);
            throw new LengthOutOfRangeException("UlSpectrumAnalyzer", msg);
        }
    }

    private void validateAuxPlugInUnitLdn(String ldn) throws IllegalAttributeValueException {
        String AUXPLUGINUNIT = "AuxPlugInUnit";
        int index = ldn.lastIndexOf("=");
        String auxPlugInUnitLdn = ldn.substring(0, index);
        if (!auxPlugInUnitLdn.endsWith("AuxPlugInUnit")) {
            String msg = "The provided targetRadioUnit [" + ldn + "] is not valid.";
            throw new IllegalAttributeValueException(msg, "UlSpectrumAnalyzer");
        }
        ManagedObject mo = this.aMoRepository.lookup(ldn);
        if (mo == null) {
            String msg = "The provided targetRadioUnit [" + ldn + "] is not valid.";
            throw new IllegalAttributeValueException(msg, "UlSpectrumAnalyzer");
        }
    }

    private boolean isIpaddressValid(String ip) {
        if (ip == null || ip.length() < 7 || ip.length() > 15) {
            return false;
        }
        if (ip.indexOf("-") >= 0) {
            return false;
        }
        try {
            int x = 0;
            int y = ip.indexOf(46);
            if (y != -1 && Integer.parseInt(ip.substring(x, y)) > 255) {
                return false;
            }
            if ((x = ip.indexOf(46, ++y)) != -1 && Integer.parseInt(ip.substring(y, x)) > 255) {
                return false;
            }
            return (y = ip.indexOf(46, ++x)) == -1 || Integer.parseInt(ip.substring(x, y)) <= 255 || Integer.parseInt(ip.substring(++y, ip.length() - 1)) <= 255 || ip.charAt(ip.length() - 1) == '.';
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void validateTriggerTimeOfDay(String triggerTimeOfDay) throws IllegalAttributeValueException {
        if (!triggerTimeOfDay.equalsIgnoreCase("FF:FF:FF.FFF")) {
            Date date = DateTimeHelper.stringToDateTime((String)triggerTimeOfDay, (String)"HH:mm:ss.SSS");
            if (date == null) {
                String msg = "The provided triggerTimeOfDay value [" + triggerTimeOfDay + "] is not valid ";
                throw new IllegalAttributeValueException(msg, "UlSpectrumAnalyzer");
            }
            int x = 0;
            int y = triggerTimeOfDay.indexOf(58);
            if (Integer.parseInt(triggerTimeOfDay.substring(x, y)) > 23) {
                String msg = "The provided triggerTimeOfDay value [" + triggerTimeOfDay + "] is not valid ";
                throw new IllegalAttributeValueException(msg, "UlSpectrumAnalyzer");
            }
            if (Integer.parseInt(triggerTimeOfDay.substring(++y, x = triggerTimeOfDay.indexOf(58, y))) > 59) {
                String msg = "The provided triggerTimeOfDay value [" + triggerTimeOfDay + "] is not valid ";
                throw new IllegalAttributeValueException(msg, "UlSpectrumAnalyzer");
            }
            if (Integer.parseInt(triggerTimeOfDay.substring(++x, y = triggerTimeOfDay.indexOf(46, x))) > 59) {
                String msg = "The provided triggerTimeOfDay value [" + triggerTimeOfDay + "] is not valid ";
                throw new IllegalAttributeValueException(msg, "UlSpectrumAnalyzer");
            }
        }
    }

    private String removeManagedElementfromLdn(String ldn) {
        String portldn = ldn;
        if (ldn.indexOf(MANAGED_ELEMENT) == 0) {
            int index = ldn.indexOf(",");
            portldn = ldn.substring(index + 1);
        }
        return portldn;
    }

    private void validateTargetRfPortAndSetAuxLdn(String ldn) throws IllegalAttributeValueException {
        if (ldn.indexOf(MANAGED_ELEMENT) == -1) {
            ldn = MANAGED_ELEMENT + ldn;
        }
        String RFPORT = "RfPort";
        int index = ldn.lastIndexOf("=");
        String rfPortLdn = ldn.substring(0, index);
        String rfPortR = ldn.substring(index + 1);
        if (!rfPortLdn.endsWith("RfPort") || rfPortR.equals("R")) {
            String msg = "The provided targetRfPort [" + ldn + "] is not valid.";
            throw new IllegalAttributeValueException(msg, "UlSpectrumAnalyzer");
        }
        ManagedObject mo = this.aMoRepository.lookup(ldn);
        if (mo == null) {
            String msg = "The provided targetRfPort [" + ldn + "] is not valid.";
            throw new IllegalAttributeValueException(msg, "UlSpectrumAnalyzer");
        }
        ManagedObject grandParent = mo.getParent().getParent();
        this.auxLdn = grandParent.getLocalDistinguishedName();
    }
}

