/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.StringTokenizer;
import se.ericsson.cello.mao.IpException;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;

public class IpAddress {
    private String addrAsString;
    private long addrAsLong;
    private static IpAddress defaultIpAddress;

    public IpAddress(String string) throws IpFormatException {
        this.addrAsLong = IpAddress.ipAddrString2Long(string);
        this.addrAsString = this.ipAddrInt2String((int)this.addrAsLong);
    }

    public IpAddress(long l) throws IpFormatException {
        this.addrAsString = this.ipAddrInt2String((int)l);
        this.addrAsLong = IpAddress.ipAddrString2Long(this.addrAsString);
    }

    public static IpAddress getDefaultIpAddress() throws IpFormatException {
        if (defaultIpAddress == null) {
            defaultIpAddress = new IpAddress("0.0.0.0");
        }
        return defaultIpAddress;
    }

    public String toString() {
        return this.addrAsString;
    }

    public int toInt() {
        return (int)this.addrAsLong;
    }

    public long toLong() {
        return this.addrAsLong;
    }

    public IpAddress getSubnetAddress(int n) throws IpException, IpFormatException {
        return new IpAddress(IpAddress.getSubnetMask(n) & this.toInt());
    }

    public static int getSubnetMask(int n) throws IpException {
        if (n < 0 || n > 32) {
            throw new IpException("Illegal value for networkPrefix. Allowed value is [0,32]. Value is: " + n);
        }
        if (n == 32) {
            return -1;
        }
        int n2 = -1;
        int n3 = 0;
        n3 = n2 >>> n;
        return n3 ^= 0xFFFFFFFF;
    }

    public void validateIpAddrWithinSubnet(int n, IpAddress ipAddress, String string) throws MoAccessException {
        IpAddress ipAddress2 = this.getSubnetAddress(n);
        if (!ipAddress2.equals(ipAddress)) {
            throw new ValueOutOfRangeException("The ipAddress " + this.addrAsString + " and prefix " + n + " produces the subnet: " + ipAddress2 + " which is not equal to subnet: " + ipAddress, string);
        }
    }

    public boolean equals(Object object) {
        return object instanceof IpAddress && this.addrAsString.equals(object.toString());
    }

    public int hashCode() {
        return this.addrAsString.hashCode();
    }

    protected static long ipAddrString2Long(String string) throws IpFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '.') continue;
            ++n3;
        }
        if (n3 != 3) {
            IpAddress.formatException(string);
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            try {
                string2 = stringTokenizer.nextToken();
                n = Integer.parseInt(string2);
                if (string2.length() > 3) {
                    IpAddress.formatException(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                IpAddress.formatException(string);
            }
            if (n < 0 || n > 255) {
                IpAddress.formatException(string);
            }
            if ((string2 = Integer.toHexString(n)).length() == 1) {
                stringBuffer.append("0");
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(string2);
            }
            ++n2;
        }
        if (n2 != 4) {
            IpAddress.formatException(string);
        }
        return Long.parseLong(stringBuffer.toString(), 16);
    }

    private static void formatException(String string) throws IpFormatException {
        throw new IpFormatException("The address " + string + " is not a valid IP address");
    }

    private String ipAddrInt2String(int n) {
        long l = n < 0 ? 0x100000000L + (long)n : (long)n;
        String string = Long.toString(l >>> 24) + "." + Long.toString(l >>> 16 & 0xFFL) + "." + Long.toString(l >>> 8 & 0xFFL) + "." + Long.toString(l & 0xFFL);
        return string;
    }
}

