/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.IdentityNotAllowedException;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class MoGenUtil {
    public static final Class THIS_CLASS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void checkAttributesDuringSet(String[] stringArray, AttrList attrList, String string) throws NoSuchAttributeException {
        int n;
        boolean[] blArray = new boolean[stringArray.length];
        int n2 = 0;
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < attrList.size(); ++n) {
            n2 = MoGenUtil.nameInList(attrList.getName(n), stringArray);
            if (n2 == -1) {
                throw new NoSuchAttributeException(attrList.getName(n), string);
            }
            if (blArray[n2]) {
                throw new NoSuchAttributeException(attrList.getName(n), string);
            }
            blArray[n2] = true;
        }
    }

    public static void checkAttributesDuringCreate(String[] stringArray, boolean[] blArray, AttrList attrList, String string) throws MoAccessException, NoSuchAttributeException {
        if (stringArray.length != blArray.length) {
            throw new NoSuchAttributeException("checkAttributesDuringCreate", "attrNames.length<>mandatory.length");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!blArray[i] || attrList.indexOf(stringArray[i]) >= 0) continue;
            throw new AttrMissingAtCreateException(stringArray[i], string);
        }
        MoGenUtil.checkAttributesDuringSet(stringArray, attrList, string);
    }

    private static int nameInList(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static void checkStringWithLength(String string, String string2, int n, int n2, String string3) throws MoAccessException {
        if (string.length() > n || string.length() < n2) {
            throw new ValueOutOfRangeException(string2, string3);
        }
    }

    public static void checkArrayWithLength(Object object, String string, int n, int n2, String string2) throws MoAccessException {
        int n3;
        if (object instanceof Integer[]) {
            n3 = ((Integer[])object).length;
        } else if (object instanceof Long[]) {
            n3 = ((Long[])object).length;
        } else if (object instanceof String[]) {
            n3 = ((String[])object).length;
        } else if (object instanceof int[]) {
            n3 = ((int[])object).length;
        } else if (object instanceof long[]) {
            n3 = ((long[])object).length;
        } else if (object instanceof ManagedObject[]) {
            n3 = ((ManagedObject[])object).length;
        } else {
            return;
        }
        if (n3 > n || n3 < n2) {
            throw new ValueOutOfRangeException(string, string2);
        }
    }

    private static void isAcceptedClass(Object object, String string, String string2, String[] stringArray) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!object.getClass().getName().equals(stringArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            throw new WrongAttributeTypeException(string, string2);
        }
    }

    private static void isAcceptedType(ManagedObject managedObject, String string, String string2, String[] stringArray) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!managedObject.getType().equals(stringArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            throw new WrongAttributeTypeException(string, string2);
        }
    }

    public static boolean isAcceptedArrayType(ManagedObject[] managedObjectArray, String string) {
        boolean bl = true;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            ManagedObject managedObject = managedObjectArray[i];
            if (managedObject != null && managedObject.getType().equals(string)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static void checkEnumAttribute(String string, int n, int[] nArray, String string2) throws MoAccessException {
        if (!MoGenUtil.isWithinEnum(n, nArray)) {
            throw new ValueOutOfRangeException(string, string2);
        }
    }

    public static void checkEnumAttributeAsArray(String string, int[] nArray, int[] nArray2, String string2) throws MoAccessException {
        for (int i = 0; i < nArray.length; ++i) {
            if (MoGenUtil.isWithinEnum(nArray[i], nArray2)) continue;
            throw new ValueOutOfRangeException(string, string2);
        }
    }

    private static boolean isWithinEnum(int n, int[] nArray) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static void checkParent(ManagedObject managedObject, String string) throws MoAccessException {
        if (!managedObject.getType().equals(string)) {
            throw new IllegalParentException(string);
        }
    }

    public static void checkParents(ManagedObject managedObject, String[] stringArray) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!managedObject.getType().equals(stringArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalParentException(managedObject.getType());
        }
    }

    public static void checkTransaction(Coordinator coordinator) throws TransactionRequiredException {
        if (coordinator == null) {
            throw new TransactionRequiredException();
        }
    }

    public static int getTransactionId(Coordinator coordinator) {
        int n = 0;
        if (coordinator != null) {
            n = coordinator.getTransactionID();
        }
        return n;
    }

    public static void checkIdentity(String string, String string2) throws IdentityNotAllowedException {
        if (string2 == null || string2.equals("")) {
            throw new IdentityNotAllowedException(string);
        }
    }

    public static void checkNoOfSiblings(ManagedObject managedObject, String string, int n) throws MaxNumberExceededException {
        if (n == -1) {
            return;
        }
        MoIterator moIterator = managedObject.getChildren();
        int n2 = 0;
        for (int i = 0; i < moIterator.size(); ++i) {
            if (!moIterator.nextMo().getType().equals(string) || ++n2 < n) continue;
            throw new MaxNumberExceededException(string, "Max number of this MO is exceeded. Max number=" + n + ", parent=" + managedObject.getType());
        }
    }

    public static Object checkAndGetAttributeType(String string, AttrList attrList, Class clazz, String string2) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (n == -1) {
            return null;
        }
        Object object = attrList.getValue(n);
        if (object != null && !clazz.isAssignableFrom(object.getClass())) {
            throw new WrongAttributeTypeException(string, string2);
        }
        Object object2 = attrList.getValue(n);
        attrList.removeElementAt(n);
        return object2;
    }

    public static String padString(String string, int n) {
        int n2;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        n3 = string.length();
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append(string.charAt(n2));
        }
        for (n2 = n3; n2 < n; ++n2) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static int[] getIntArrayFromIntegerArray(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    public static Integer[] getIntegerArrayFromIntArray(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            integerArray[i] = new Integer(nArray[i]);
        }
        return integerArray;
    }

    public static long[] getPrimLongArrayFromLongArray(Long[] longArray) {
        long[] lArray = new long[longArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = longArray[i];
        }
        return lArray;
    }

    public static Long[] getLongArrayFromPrimLongArray(long[] lArray) {
        Long[] longArray = new Long[lArray.length];
        for (int i = 0; i < longArray.length; ++i) {
            longArray[i] = new Long(lArray[i]);
        }
        return longArray;
    }

    public static void checkIntegerAttribute(String string, int n, int n2, int n3, String string2) throws MoAccessException {
        if (!MoGenUtil.isWithinRange(n, n2, n3)) {
            throw new ValueOutOfRangeException(string, string2);
        }
    }

    public static void checkIntegerAttribute(String string, int n, int[] nArray, int[] nArray2, String string2) throws MoAccessException {
        if (!$assertionsDisabled && nArray.length != nArray2.length) {
            throw new AssertionError();
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (!MoGenUtil.isWithinRange(n, nArray[i], nArray2[i])) continue;
            return;
        }
        throw new ValueOutOfRangeException(string, string2);
    }

    public static int[] checkIntegerArrayAttribute(String string, int[] nArray, int n, int n2, int n3, int n4, String string2) throws MoAccessException {
        int[] nArray2 = MoGenUtil.checkIntegerArrayAttribute(string, nArray, n3, n4, string2);
        MoGenUtil.checkValueOfArrayElement(string, nArray2, n, n2, string2);
        return nArray2;
    }

    public static void checkValueOfArrayElement(String string, int[] nArray, int n, int n2, String string2) throws MoAccessException {
        for (int i = 0; i < nArray.length; ++i) {
            if (MoGenUtil.isWithinRange(nArray[i], n, n2)) continue;
            throw new ValueOutOfRangeException(string, string2);
        }
    }

    public static int[] checkIntegerArrayAttribute(String string, int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, String string2) throws MoAccessException {
        int[] nArray4 = MoGenUtil.checkIntegerArrayAttribute(string, nArray, n, n2, string2);
        MoGenUtil.checkValueOfArrayElement(string, nArray4, nArray2, nArray3, string2);
        return nArray4;
    }

    public static void checkValueOfArrayElement(String string, int[] nArray, int[] nArray2, int[] nArray3, String string2) throws MoAccessException {
        if (!$assertionsDisabled && nArray2.length != nArray3.length) {
            throw new AssertionError();
        }
        for (int i = 0; i < nArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < nArray3.length; ++j) {
                if (!MoGenUtil.isWithinRange(nArray[i], nArray2[j], nArray3[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new ValueOutOfRangeException(string, string2);
        }
    }

    private static boolean isWithinRange(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    public static int[] checkIntegerArrayAttribute(String string, int[] nArray, int n, int n2, String string2) throws MoAccessException {
        if (nArray.length < n) {
            throw new ValueOutOfRangeException(string + " array is not allowed to contain less than " + n + " elements", string2);
        }
        if (nArray.length > n2) {
            throw new ValueOutOfRangeException(string + " array is not allowed to contain more than " + n2 + " elements", string2);
        }
        return nArray;
    }

    public static void checkLongAttribute(String string, long l, long l2, long l3, String string2) throws MoAccessException {
        if (!MoGenUtil.isWithinRange(l, l2, l3)) {
            throw new ValueOutOfRangeException(string, string2);
        }
    }

    public static void checkLongAttribute(String string, long l, long[] lArray, long[] lArray2, String string2) throws MoAccessException {
        if (!$assertionsDisabled && lArray.length != lArray2.length) {
            throw new AssertionError();
        }
        for (int i = 0; i < lArray.length; ++i) {
            if (!MoGenUtil.isWithinRange(l, lArray[i], lArray2[i])) continue;
            return;
        }
        throw new ValueOutOfRangeException(string, string2);
    }

    public static long[] checkLongArrayAttribute(String string, long[] lArray, long l, long l2, int n, int n2, String string2) throws MoAccessException {
        long[] lArray2 = MoGenUtil.checkLongArrayAttribute(string, lArray, n, n2, string2);
        MoGenUtil.checkValueOfArrayElement(string, lArray2, l, l2, string2);
        return lArray2;
    }

    public static void checkValueOfArrayElement(String string, long[] lArray, long l, long l2, String string2) throws MoAccessException {
        for (int i = 0; i < lArray.length; ++i) {
            if (MoGenUtil.isWithinRange(lArray[i], l, l2)) continue;
            throw new ValueOutOfRangeException(string, string2);
        }
    }

    public static long[] checkLongArrayAttribute(String string, long[] lArray, int n, int n2, String string2) throws MoAccessException {
        if (lArray.length < n) {
            throw new ValueOutOfRangeException(string + " array is not allowed to contain less than " + n + " elements", string2);
        }
        if (lArray.length > n2) {
            throw new ValueOutOfRangeException(string + " array is not allowed to contain more than " + n2 + " elements", string2);
        }
        return lArray;
    }

    public static long[] checkLongArrayAttribute(String string, long[] lArray, long[] lArray2, long[] lArray3, int n, int n2, String string2) throws MoAccessException {
        long[] lArray4 = MoGenUtil.checkLongArrayAttribute(string, lArray, n, n2, string2);
        MoGenUtil.checkValueOfArrayElement(string, lArray4, lArray2, lArray3, string2);
        return lArray4;
    }

    public static void checkValueOfArrayElement(String string, long[] lArray, long[] lArray2, long[] lArray3, String string2) throws MoAccessException {
        if (!$assertionsDisabled && lArray2.length != lArray3.length) {
            throw new AssertionError();
        }
        for (int i = 0; i < lArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < lArray3.length; ++j) {
                if (!MoGenUtil.isWithinRange(lArray[i], lArray2[j], lArray3[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new ValueOutOfRangeException(string, string2);
        }
    }

    public static void checkUniquenessOfArray(String string, Object object, String string2) throws AttrValueNotUniqueException {
        List<Object> list = null;
        if (object instanceof Integer[]) {
            list = Arrays.asList((Integer[])object);
        } else if (object instanceof Long[]) {
            list = Arrays.asList((Long[])object);
        } else if (object instanceof String[]) {
            list = Arrays.asList((String[])object);
        } else if (object instanceof int[]) {
            list = Arrays.asList(MoGenUtil.getIntegerArrayFromIntArray((int[])object));
        } else if (object instanceof long[]) {
            list = Arrays.asList(MoGenUtil.getLongArrayFromPrimLongArray((long[])object));
        } else if (object instanceof ManagedObject[]) {
            list = Arrays.asList((ManagedObject[])object);
        } else {
            return;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(list);
        if (hashSet.size() < list.size()) {
            throw new AttrValueNotUniqueException("Values uniquenss in the Sequence attribute: " + string + " failed.", string2);
        }
    }

    private static boolean isWithinRange(long l, long l2, long l3) {
        return l >= l2 && l <= l3;
    }

    static {
        $assertionsDisabled = !MoGenUtil.class.desiredAssertionStatus();
        THIS_CLASS = MoGenUtil.class;
    }
}

