/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.Collection;
import java.util.HashSet;
import se.ericsson.cello.support.debug.MessageLog;

public class ThreadUtil {
    public static final Class CLASS = ThreadUtil.class;

    public static synchronized Collection getAllThreadNames() {
        HashSet<String> hashSet = new HashSet<String>();
        ThreadGroup[] threadGroupArray = ThreadUtil.getThreadGroups();
        MessageLog.trace((int)5, (Class)CLASS, (String)("Number of groups :" + threadGroupArray.length));
        for (int i = 0; i < threadGroupArray.length; ++i) {
            MessageLog.trace((int)5, (Class)CLASS, (String)("Thread group number : " + i));
            Thread[] threadArray = ThreadUtil.getGroupThreads(threadGroupArray[i]);
            for (int j = 0; j < threadArray.length; ++j) {
                MessageLog.trace((int)5, (Class)CLASS, (String)("Thread name = " + threadArray[j].getName()));
                hashSet.add(threadArray[j].getName());
            }
        }
        return hashSet;
    }

    private static ThreadGroup[] getThreadGroups() {
        ThreadGroup[] threadGroupArray;
        ThreadGroup threadGroup = ThreadUtil.getRootThreadGroup();
        int n = threadGroup.activeGroupCount();
        int n2 = 0;
        while ((n2 = threadGroup.enumerate(threadGroupArray = new ThreadGroup[n *= 2], true)) == n) {
        }
        ThreadGroup[] threadGroupArray2 = new ThreadGroup[n2 + 1];
        threadGroupArray2[0] = threadGroup;
        System.arraycopy(threadGroupArray, 0, threadGroupArray2, 1, n2);
        return threadGroupArray2;
    }

    private static Thread[] getGroupThreads(ThreadGroup threadGroup) {
        int n = threadGroup.activeCount();
        Thread[] threadArray = new Thread[n * 2];
        n = threadGroup.enumerate(threadArray, false);
        Thread[] threadArray2 = new Thread[n];
        System.arraycopy(threadArray, 0, threadArray2, 0, n);
        return threadArray2;
    }

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup().getParent();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }
}

