/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.property;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;

public class PropertyChangeSupport
implements Serializable {
    private transient Vector listeners;
    private Hashtable children;
    private Object source;
    private int propertyChangeSupportSerializedDataVersion = 2;
    static final long serialVersionUID = 6401253773779951803L;

    public PropertyChangeSupport(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport;
        if (this.children == null) {
            this.children = new Hashtable();
        }
        if ((propertyChangeSupport = (PropertyChangeSupport)this.children.get(string)) == null) {
            propertyChangeSupport = new PropertyChangeSupport(this.source);
            this.children.put(string, propertyChangeSupport);
        }
        propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.children == null) {
            return;
        }
        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)this.children.get(string);
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(String string, Object object, Object object2) {
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        Vector vector = null;
        PropertyChangeSupport propertyChangeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
            if (this.children != null && string != null) {
                propertyChangeSupport = (PropertyChangeSupport)this.children.get(string);
            }
        }
        serializable = new PropertyChangeEvent(this.source, string, object, object2);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(i);
                propertyChangeListener.propertyChange((PropertyChangeEvent)serializable);
            }
        }
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange((PropertyChangeEvent)serializable);
        }
    }

    public void firePropertyChange(String string, int n, int n2) {
        if (n == n2) {
            return;
        }
        this.firePropertyChange(string, new Integer(n), new Integer(n2));
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (bl == bl2) {
            return;
        }
        this.firePropertyChange(string, (Object)bl, (Object)bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        String string = propertyChangeEvent.getPropertyName();
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        Vector vector = null;
        PropertyChangeSupport propertyChangeSupport = null;
        PropertyChangeSupport propertyChangeSupport2 = this;
        synchronized (propertyChangeSupport2) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
            if (this.children != null && string != null) {
                propertyChangeSupport = (PropertyChangeSupport)this.children.get(string);
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(i);
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(propertyChangeEvent);
        }
    }

    public synchronized boolean hasListeners(String string) {
        PropertyChangeSupport propertyChangeSupport;
        if (this.listeners != null && !this.listeners.isEmpty()) {
            return true;
        }
        if (this.children != null && (propertyChangeSupport = (PropertyChangeSupport)this.children.get(string)) != null && propertyChangeSupport.listeners != null) {
            return !propertyChangeSupport.listeners.isEmpty();
        }
        return false;
    }

    public synchronized boolean isListener(String string, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport;
        if (this.children != null && (propertyChangeSupport = (PropertyChangeSupport)this.children.get(string)) != null && propertyChangeSupport.listeners != null) {
            return propertyChangeSupport.listeners.contains(propertyChangeListener);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Vector vector = null;
        PropertyChangeSupport propertyChangeSupport = this;
        synchronized (propertyChangeSupport) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(i);
                if (!(propertyChangeListener instanceof Serializable)) continue;
                objectOutputStream.writeObject(propertyChangeListener);
            }
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            this.addPropertyChangeListener((PropertyChangeListener)object);
        }
    }
}

