/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class CopyLrhDb {
    private static final Class THIS_CLASS = CopyLrhDb.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final DbWrapper dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
    private static final String BB_PROCESSING_RESOURCE = "BbProcessingResource";

    public void execute() throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "execute()");
        String string = "";
        try {
            this.dbWrapper.openConnection();
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Failing open db connection", (Throwable)sQLException);
        }
        try {
            String string2 = null;
            try {
                string2 = this.getFroDataTableName("select frodatatablename  from lrh_fro_versions where frotypename= " + AueUtil.quote((String)BB_PROCESSING_RESOURCE));
            }
            catch (CrbsAueException crbsAueException) {
                logger.traceGeneral(THIS_CLASS, "No need to convert LRH db.");
            }
            if (string2 != null && string2.length() > 0) {
                string = this.getFroDataTableName("select frodatatablename  from fro_versions where frotypename= " + AueUtil.quote((String)BB_PROCESSING_RESOURCE));
                boolean bl = this.piuFroidExists(string2);
                String string3 = this.makeCreateQuery(string, bl);
                this.dbWrapper.executeUpdate(string3);
                this.copyRowsToNewTable(string2, string, bl);
                this.copyLrhAttributeRowsToNewTable();
            }
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Failing create db table:" + string, (Throwable)sQLException);
        }
        finally {
            try {
                this.dbWrapper.closeConnection(1);
            }
            catch (SQLException sQLException) {
                logger.traceError(THIS_CLASS, "Unable to close db connection: " + (Object)((Object)sQLException));
            }
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private String makeCreateQuery(String string, boolean bl) throws CrbsAueException {
        String string2 = "";
        string2 = bl ? "froid int NOT NULL,ldn varchar(0) NOT NULL, parentref varchar(0) NOT NULL, liccapdistr int NOT NULL, piufroid int NOT NULL," : "froid int NOT NULL,ldn varchar(0) NOT NULL, parentref varchar(0) NOT NULL, liccapdistr int NOT NULL,";
        return "CREATE TABLE " + string + " (PERSISTENT, " + string2 + " PRIMARY KEY(froid))";
    }

    private boolean piuFroidExists(String string) throws CrbsAueException {
        boolean bl = false;
        String string2 = "select name from attributes where table_name = " + AueUtil.quote((String)string.toLowerCase(Locale.getDefault()));
        ResultSet resultSet = null;
        try {
            resultSet = this.dbWrapper.executeQuery(string2);
            while (resultSet != null && resultSet.next()) {
                if (!"piuFroId".equalsIgnoreCase(resultSet.getString(1))) continue;
                bl = true;
                break;
            }
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Caught SQLException", (Throwable)sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    logger.traceAbnormal(THIS_CLASS, "Unable to close resultset: " + exception);
                }
            }
        }
        return bl;
    }

    private void copyRowsToNewTable(String string, String string2, boolean bl) throws CrbsAueException {
        try {
            List list = this.getLrhFroDataTableRows(string, bl);
            for (int i = 0; i < list.size(); ++i) {
                String string3 = "INSERT INTO " + string2 + " VALUES (";
                List list2 = (List)list.get(i);
                string3 = bl ? string3 + list2.get(0).toString() + "," + AueUtil.quote((String)list2.get(1).toString()) + "," + AueUtil.quote((String)list2.get(2).toString()) + "," + list2.get(3).toString() + "," + list2.get(4).toString() + ")" : string3 + list2.get(0).toString() + "," + AueUtil.quote((String)list2.get(1).toString()) + "," + AueUtil.quote((String)list2.get(2).toString()) + "," + list2.get(3).toString() + ")";
                this.dbWrapper.executeUpdate(string3);
            }
        }
        catch (CrbsAueException crbsAueException) {
            throw new CrbsAueException("Caught CrbsAueException when retrieving data from " + string, (Throwable)crbsAueException);
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Caught SQLException when insert data in to " + string2, (Throwable)sQLException);
        }
    }

    private List getLrhFroDataTableRows(String string, boolean bl) throws CrbsAueException {
        String string2 = "SELECT * FROM " + string;
        ResultSet resultSet = null;
        ArrayList<List> arrayList = new ArrayList<List>();
        try {
            resultSet = this.dbWrapper.executeQuery(string2);
            while (resultSet != null && resultSet.next()) {
                List list = this.getFroDataRowData(resultSet, bl);
                arrayList.add(list);
            }
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Caught SQLException", (Throwable)sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    logger.traceAbnormal(THIS_CLASS, "Unable to close resultset: " + exception);
                }
            }
        }
        return arrayList;
    }

    private List getLrhFroAttributesRowData(ResultSet resultSet) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new Integer(resultSet.getInt("frotype")));
        arrayList.add(resultSet.getString("attrname"));
        arrayList.add(resultSet.getString("attrtype"));
        return arrayList;
    }

    private List copyLrhFroAttributes() throws CrbsAueException {
        ResultSet resultSet = null;
        ArrayList<List> arrayList = new ArrayList<List>();
        try {
            resultSet = this.dbWrapper.executeQuery("SELECT * FROM lrh_fro_attributes");
            while (resultSet != null && resultSet.next()) {
                List list = this.getLrhFroAttributesRowData(resultSet);
                arrayList.add(list);
            }
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Caught SQLException", (Throwable)sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    logger.traceAbnormal(THIS_CLASS, "Unable to close resultset: " + exception);
                }
            }
        }
        return arrayList;
    }

    private void copyLrhAttributeRowsToNewTable() throws CrbsAueException {
        try {
            List list = this.copyLrhFroAttributes();
            for (int i = 0; i < list.size(); ++i) {
                String string = "INSERT INTO fro_attributes VALUES (";
                List list2 = (List)list.get(i);
                string = string + list2.get(0).toString() + "," + AueUtil.quote((String)list2.get(1).toString()) + "," + AueUtil.quote((String)list2.get(2).toString()) + ")";
                this.dbWrapper.executeUpdate(string);
            }
        }
        catch (CrbsAueException crbsAueException) {
            throw new CrbsAueException("Caught CrbsAueException when retrieving data from lrh_fro_attributes", (Throwable)crbsAueException);
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Caught SQLException when insert data in to fro_attributes", (Throwable)sQLException);
        }
    }

    private List getFroDataRowData(ResultSet resultSet, boolean bl) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new Integer(resultSet.getInt("froid")));
        arrayList.add(resultSet.getString("ldn"));
        arrayList.add(resultSet.getString("parentref"));
        arrayList.add(new Integer(resultSet.getInt("liccapdistr")));
        if (bl) {
            arrayList.add(new Integer(resultSet.getInt("piufroid")));
        }
        return arrayList;
    }

    private String getFroDataTableName(String string) throws CrbsAueException {
        ResultSet resultSet = null;
        String string2 = null;
        try {
            resultSet = this.dbWrapper.executeQuery(string);
            while (resultSet != null && resultSet.next()) {
                string2 = resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException("Caught SQLException", (Throwable)sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    logger.traceAbnormal(THIS_CLASS, "Unable to close resultset: " + exception);
                }
            }
        }
        return string2;
    }
}

