/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class NewCompactFroXmlFormatUtility {
    private static final Class THIS_CLASS = NewCompactFroXmlFormatUtility.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String STRCT = "strct";
    private static final String SEQ = "seq";
    private static final String MOREF = "moref";
    private static final String ATTR = "attr";
    private static final String DATA = "data";
    private static final String START_NAME = "name=\"";
    private static final String START_ATTR = "<attr";
    private static final String START_MOREF = "<moref";
    private static final String START_DATA = "<data>";
    private static final String END_DATA = "</data>";
    private static final String END_STRUCT = "</strct>";
    private static final String END_ARRAY = "</seq>";
    private static final String END_COMPLEX = "</complex>";
    private static final String COMMA = ",";
    private static final String DOUBLE_COMMA = ",,";
    private static final String TEMP_REPLACEMENT_OF_EXTRA_COMMA = ")!*!(";
    private static final String EMPTY_STRING = "";
    private SimpleParser simpleParser = new SimpleParser();

    protected void setSimpleParserForBT(SimpleParser simpleParser) {
        this.simpleParser = simpleParser;
    }

    public String getLdnFromMoRef(String string) throws CrbsAueException {
        try {
            this.simpleParser.setXmlData(string);
        }
        catch (IOException iOException) {
            throw new CrbsAueException("IOException while parsing xml. Value : " + string);
        }
        String string2 = this.simpleParser.getType();
        if (!MOREF.equalsIgnoreCase(string2)) {
            throw new CrbsAueException("Not a valid moref xml, value is: " + string);
        }
        int n = string.indexOf(START_DATA);
        int n2 = string.indexOf(END_DATA);
        String string3 = string.substring(n + START_DATA.length(), n2);
        return AueUtil.replaceInString((String)this.removeAfterLastComma(this.removeAfterLastComma(string3)), (String)"\\,", (String)COMMA);
    }

    private String removeAfterLastComma(String string) throws CrbsAueException {
        int n = string.lastIndexOf(COMMA);
        if (n == -1) {
            throw new CrbsAueException("Not a valid moref xml, part of data is missing comma: " + string);
        }
        return string.substring(0, n);
    }

    public String getStructMemberValue(String string, String string2) throws CrbsAueException {
        try {
            this.simpleParser.setXmlData(string);
        }
        catch (IOException iOException) {
            throw new CrbsAueException("IOException while parsing xml. Value : " + string);
        }
        String string3 = this.simpleParser.getType();
        if (!STRCT.equalsIgnoreCase(string3)) {
            throw new CrbsAueException("Not a valid struct xml, value is: " + string);
        }
        List list = this.getMemberNames(string);
        int n = list.indexOf(string2);
        String string4 = this.getValueAtStructPosition(n);
        return string4;
    }

    public String changeStructMemberValue(String string, String string2, String string3) throws CrbsAueException {
        try {
            this.simpleParser.setXmlData(string);
        }
        catch (IOException iOException) {
            throw new CrbsAueException("IOException while parsing xml. Value : " + string);
        }
        String string4 = this.simpleParser.getType();
        if (!STRCT.equalsIgnoreCase(string4)) {
            throw new CrbsAueException("Not a valid struct xml, value is: " + string);
        }
        int n = string.indexOf(START_DATA);
        int n2 = string.indexOf(END_DATA);
        int n3 = n + START_DATA.length();
        String string5 = string.substring(0, n3);
        String string6 = string.substring(n2);
        List list = this.getMemberNames(string);
        int n4 = list.indexOf(string2);
        String string7 = this.changeValueAtStructPosition(string3, n4);
        String string8 = string5 + string7 + string6;
        return string8;
    }

    public String insertNewStructMembers(String string, String string2, String string3, String string4, String string5) throws CrbsAueException {
        int n = string3.indexOf(END_STRUCT);
        int n2 = string3.indexOf(START_DATA);
        int n3 = string3.indexOf(END_DATA);
        String string6 = EMPTY_STRING;
        try {
            this.simpleParser.setXmlData(string3);
        }
        catch (IOException iOException) {
            throw new CrbsAueException("IOException while parsing xml. Attribute : " + string2 + ", Value : " + string3);
        }
        String string7 = this.simpleParser.getType();
        String string8 = this.simpleParser.getSeqType();
        if (!STRCT.equalsIgnoreCase(string7) && !SEQ.equalsIgnoreCase(string7)) {
            throw new CrbsAueException("Attribute " + string2 + " does not contain valid struct xml, value is: " + string3);
        }
        string6 = STRCT.equalsIgnoreCase(string7) ? this.handleSimpleStruct(string, string2, string3, string4, string5, n, n2, n3) : (EMPTY_STRING.equalsIgnoreCase(string8) ? string3 : (STRCT.equalsIgnoreCase(string8) ? this.handleArrayWithStructs(string, string2, string3, string4, string5) : string3));
        return string6;
    }

    public boolean isValueInArray(String string, String string2) throws CrbsAueException {
        boolean bl = false;
        try {
            this.simpleParser.setXmlData(string);
        }
        catch (IOException iOException) {
            throw new CrbsAueException("IOException while parsing xml. Value : " + string);
        }
        String string3 = this.simpleParser.getType();
        if (!SEQ.equalsIgnoreCase(string3)) {
            throw new CrbsAueException("Not a valid array xml, value is: " + string);
        }
        bl = this.isValueInData(string2);
        return bl;
    }

    private String handleSimpleStruct(String string, String string2, String string3, String string4, String string5, int n, int n2, int n3) throws CrbsAueException {
        String string6;
        if (this.checkIfAnyMemberNameAlreadyExists(string, string2, string4, string3)) {
            string6 = string3;
        } else {
            String string7 = EMPTY_STRING;
            if (n3 != n2 + START_DATA.length()) {
                string7 = COMMA;
            }
            string6 = string3.substring(0, n) + string4 + string3.substring(n, n3) + string7 + string5 + string3.substring(n3);
        }
        return string6;
    }

    private String handleArrayWithStructs(String string, String string2, String string3, String string4, String string5) throws CrbsAueException {
        String string6 = EMPTY_STRING;
        if (this.checkIfAnyMemberNameAlreadyExists(string, string2, string4, string3)) {
            string6 = string3;
        } else {
            int n = this.getNumOfMembersInOneElement();
            String string7 = this.getNewDataForArray(n, string5);
            int n2 = string3.indexOf(END_ARRAY);
            string6 = string3.substring(0, n2) + string4 + END_ARRAY + string7 + END_COMPLEX;
        }
        return string6;
    }

    private int getNumOfMembersInOneElement() {
        int n = 0;
        List list = this.getDataTokensFromParser();
        Iterator iterator = list.iterator();
        if (list.size() > 1) {
            int n2 = 0;
            int n3 = Integer.parseInt((String)iterator.next());
            while (iterator.hasNext()) {
                iterator.next();
                ++n2;
            }
            n = n2 / n3;
        }
        return n;
    }

    private String getValueAtStructPosition(int n) {
        String string = EMPTY_STRING;
        Iterator iterator = this.getDataTokensFromParser().iterator();
        for (int i = 0; iterator.hasNext() && i <= n; ++i) {
            string = (String)iterator.next();
        }
        return string;
    }

    private String changeValueAtStructPosition(String string, int n) {
        String string2 = EMPTY_STRING;
        String string3 = EMPTY_STRING;
        int n2 = 0;
        Iterator iterator = this.getDataTokensFromParser().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string3 = n2 == n ? string3 + string + COMMA : string3 + string2 + COMMA;
            ++n2;
        }
        String string4 = string3.substring(0, string3.length() - 1);
        return string4;
    }

    private String getNewDataForArray(int n, String string) throws CrbsAueException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = EMPTY_STRING;
        List list = this.getDataTokensFromParser();
        Iterator iterator = list.iterator();
        if (list.size() >= 1) {
            int n2 = 0;
            stringBuffer.append(START_DATA);
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                stringBuffer.append(string3 + COMMA);
                if (n2 != 0 && n2 % n == 0 || n == 0) {
                    stringBuffer.append(string + COMMA);
                }
                ++n2;
            }
        } else {
            throw new CrbsAueException("Failed to get new data value for array of struct");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(END_DATA);
        string2 = stringBuffer.toString();
        return string2;
    }

    private boolean checkIfAnyMemberNameAlreadyExists(String string, String string2, String string3, String string4) throws CrbsAueException {
        boolean bl = false;
        List list = this.getMemberNames(string3);
        List list2 = this.getMemberNames(string4);
        for (int i = 0; i < list.size(); ++i) {
            if (!list2.contains(list.get(i))) continue;
            bl = true;
            logger.traceAbnormal(THIS_CLASS, "Attribute " + string + "::" + string2 + " already contains struct with member name : " + list.get(i));
            break;
        }
        return bl;
    }

    public List getMemberNames(String string) throws CrbsAueException {
        String string2 = string;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        while (string2.indexOf(START_NAME) != -1) {
            int n2 = string2.indexOf(START_NAME) + START_NAME.length();
            int n3 = string2.substring(n2).indexOf("\"");
            if (n3 == -1) {
                throw new CrbsAueException("Missing closing quotation character in badly formatted XML string: " + string);
            }
            int n4 = n2 + n3;
            String string3 = string2.substring(n2, n4);
            if (n != 1) {
                arrayList.add(string3);
            }
            string2 = string2.substring(n4 + 1);
            ++n;
        }
        return arrayList;
    }

    private boolean isValueInData(String string) {
        boolean bl = false;
        List list = this.getDataTokensFromParser();
        Iterator iterator = list.iterator();
        if (list.size() > 2) {
            iterator.next();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
        } else if (list.size() == 2) {
            iterator.next();
            String string3 = (String)iterator.next();
            if (string.equals(string3)) {
                bl = true;
            }
        }
        return bl;
    }

    private String getDataExtraCommaHandled(String string) {
        String string2 = string;
        if (string2.startsWith(COMMA)) {
            string2 = TEMP_REPLACEMENT_OF_EXTRA_COMMA + string2.substring(1, string2.length());
        }
        int n = string2.indexOf(DOUBLE_COMMA);
        while (n > -1) {
            string2 = string2.substring(0, n) + COMMA + TEMP_REPLACEMENT_OF_EXTRA_COMMA + string2.substring(n + DOUBLE_COMMA.length(), string2.length());
            n = string2.indexOf(DOUBLE_COMMA);
        }
        return string2;
    }

    public String getStructMember(String string) throws CrbsAueException {
        String string2 = string;
        int n = string2.indexOf(START_ATTR);
        if (n <= -1) {
            n = string2.indexOf(START_MOREF);
        }
        int n2 = 0;
        n2 = string2.indexOf(END_STRUCT) > -1 ? string2.indexOf(END_STRUCT) : string2.indexOf(END_ARRAY);
        String string3 = string2.substring(n, n2);
        return string3;
    }

    public String getStructMemberValues(String string) throws CrbsAueException {
        String string2 = string;
        int n = string2.indexOf(START_DATA);
        int n2 = string2.indexOf(END_DATA);
        String string3 = string2.substring(n + START_DATA.length(), n2);
        return string3;
    }

    public int getArraySize(String string) throws CrbsAueException {
        try {
            this.simpleParser.setXmlData(string);
        }
        catch (IOException iOException) {
            throw new CrbsAueException("IOException while parsing xml. Value : " + string);
        }
        String string2 = this.simpleParser.getType();
        if (!SEQ.equalsIgnoreCase(string2)) {
            throw new CrbsAueException("Not a valid array xml, value is: " + string);
        }
        int n = Integer.parseInt(this.getDataTokensFromParser().iterator().next().toString());
        return n;
    }

    public Iterator getDataTokens(String string) throws CrbsAueException {
        try {
            this.simpleParser.setXmlData(string);
        }
        catch (IOException iOException) {
            throw new CrbsAueException("IOException while parsing xml. Value : " + string);
        }
        return this.getDataTokensFromParser(false).iterator();
    }

    public Iterator getDataTokensFromValueOfWrongEmptyMoref(String string) throws CrbsAueException {
        try {
            this.simpleParser.setXmlData(string);
        }
        catch (IOException iOException) {
            throw new CrbsAueException("IOException while parsing xml. Value : " + string);
        }
        return this.getDataTokensFromParser(true).iterator();
    }

    private List getDataTokensFromParser() {
        return this.getDataTokensFromParser(false);
    }

    private List getDataTokensFromParser(boolean bl) {
        String string = this.simpleParser.getData();
        XmlDataTokenizer xmlDataTokenizer = new XmlDataTokenizer(string);
        Iterator iterator = this.simpleParser.getAttrTypes().iterator();
        List list = this.processTokens(xmlDataTokenizer, iterator, bl);
        return list;
    }

    private List processTokens(XmlDataTokenizer xmlDataTokenizer, Iterator iterator, boolean bl) {
        Iterator iterator2 = iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (xmlDataTokenizer.hasMoreTokens()) {
            while (iterator2.hasNext()) {
                String string;
                String string2 = (String)iterator2.next();
                if (STRCT.equals(string2)) continue;
                if (SEQ.equals(string2)) {
                    string = xmlDataTokenizer.nextToken();
                    arrayList.add(string);
                    string2 = (String)iterator2.next();
                    if (STRCT.equals(string2)) {
                        iterator2 = this.updateTypes(iterator2, Integer.parseInt(string));
                        continue;
                    }
                    iterator2 = this.updateTypes(iterator2, string2, Integer.parseInt(string));
                    continue;
                }
                if (MOREF.equals(string2)) {
                    string = xmlDataTokenizer.nextToken();
                    if (",-1".equals(string)) {
                        arrayList.add(string + COMMA + xmlDataTokenizer.nextToken());
                        continue;
                    }
                    if ("-1".equals(string) && bl) {
                        arrayList.add(string + COMMA + xmlDataTokenizer.nextToken());
                        continue;
                    }
                    arrayList.add(string + COMMA + xmlDataTokenizer.nextToken() + COMMA + xmlDataTokenizer.nextToken());
                    continue;
                }
                arrayList.add(xmlDataTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    private Iterator updateTypes(Iterator iterator, int n) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < arrayList.size(); ++j) {
                arrayList2.add(arrayList.get(j));
            }
        }
        return arrayList2.iterator();
    }

    private Iterator updateTypes(Iterator iterator, String string, int n) {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        for (int i = 0; i < n; ++i) {
            arrayList.add(0, string);
        }
        return arrayList.iterator();
    }

    protected static class SimpleParser
    extends DefaultHandler {
        private static final String TYPE = "type";
        private String type;
        private String seqType;
        private boolean isData;
        private List types;
        private StringBuffer sb;

        protected SimpleParser() {
        }

        public void setXmlData(String string) throws CrbsAueException, IOException {
            this.type = NewCompactFroXmlFormatUtility.EMPTY_STRING;
            this.seqType = NewCompactFroXmlFormatUtility.EMPTY_STRING;
            this.isData = false;
            this.types = new ArrayList();
            this.sb = new StringBuffer();
            try {
                XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                xMLReader.setContentHandler(this);
                InputSource inputSource = new InputSource(new StringReader(string));
                xMLReader.parse(inputSource);
            }
            catch (SAXException sAXException) {
                throw new CrbsAueException("Wrong xml format. Value : " + string);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals(NewCompactFroXmlFormatUtility.STRCT)) {
                this.setCurrentType(string3);
                this.types.add(string3);
            } else if (string3.equals(NewCompactFroXmlFormatUtility.SEQ)) {
                if (this.setCurrentType(string3)) {
                    this.seqType = attributes.getValue(TYPE);
                }
                this.types.add(string3);
                this.types.add(attributes.getValue(TYPE));
            } else if (string3.equals(NewCompactFroXmlFormatUtility.MOREF)) {
                this.setCurrentType(string3);
                this.types.add(string3);
            } else if (string3.equals(NewCompactFroXmlFormatUtility.ATTR)) {
                this.types.add(attributes.getValue(TYPE));
            } else if (string3.equals(NewCompactFroXmlFormatUtility.DATA)) {
                this.isData = true;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals(NewCompactFroXmlFormatUtility.DATA)) {
                this.isData = false;
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.isData) {
                String string = new String(cArray, n, n2);
                this.sb.append(string);
            }
        }

        public String getType() {
            return this.type;
        }

        public String getSeqType() {
            return this.seqType;
        }

        public String getData() {
            return this.sb.toString();
        }

        public List getAttrTypes() {
            return this.types;
        }

        private boolean setCurrentType(String string) {
            boolean bl = false;
            if (NewCompactFroXmlFormatUtility.EMPTY_STRING.equals(this.type)) {
                this.type = string;
                bl = true;
            }
            return bl;
        }
    }

    private class XmlDataTokenizer
    extends StringTokenizer {
        public XmlDataTokenizer(String string) {
            super(NewCompactFroXmlFormatUtility.this.getDataExtraCommaHandled(string), NewCompactFroXmlFormatUtility.COMMA);
        }

        public String nextToken() {
            String string = super.nextToken();
            while (string.endsWith("\\")) {
                string = string + NewCompactFroXmlFormatUtility.COMMA + super.nextToken();
            }
            if (string.indexOf(NewCompactFroXmlFormatUtility.TEMP_REPLACEMENT_OF_EXTRA_COMMA) > -1) {
                string = AueUtil.replaceInString((String)string, (String)NewCompactFroXmlFormatUtility.TEMP_REPLACEMENT_OF_EXTRA_COMMA, (String)NewCompactFroXmlFormatUtility.COMMA);
            }
            return string;
        }
    }
}

