/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it14;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.StructUtilityWrapper;

public class CopyStructMemberToAttributeAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = CopyStructMemberToAttributeAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert");
        String string = this.getMoTypeName();
        try {
            TableData tableData = this.getTableData(aueContext, string);
            if (tableData.isNotEmpty()) {
                this.copyStructMemberToAttribute(tableData, string);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not to get table data for: " + string, (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "convert");
    }

    private void copyStructMemberToAttribute(TableData tableData, String string) throws CrbsAueException {
        Object[] objectArray;
        String string2 = this.getFromAttributeName();
        String string3 = this.getFromStructMemberName();
        String string4 = this.getToAttributeName();
        try {
            objectArray = tableData.getAttributeValues(string2);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not get table column for: " + string + "::" + string2, (Throwable)tableDataException);
        }
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                Integer n = this.getStructMemberValue(objectArray[i].toString(), string3, string, string2);
                tableData.setAttributeValue(i, string4, (Object)n);
                logger.traceGeneral(THIS_CLASS, "The struct member \"" + string3 + "\" value was successfully copied from " + string + "::" + string2 + ", instance " + i + " to " + string + "::" + string4);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not set table data for: " + string + "::" + string2, (Throwable)tableDataException);
        }
    }

    private TableData getTableData(AueContext aueContext, String string) throws TableDataException {
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = tableHandler.getTableData(string);
        return tableData;
    }

    private Integer getStructMemberValue(String string, String string2, String string3, String string4) throws CrbsAueException {
        Integer n;
        String string5 = StructUtilityWrapper.getStructUtilityInstance().getStructMemberValue(string, string2, string3, string4);
        try {
            n = new Integer(string5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CrbsAueException("Could not convert struct member value to an integer " + string2 + " for " + string3 + "::" + string4);
        }
        return n;
    }

    private String getMoTypeName() throws CrbsAueException {
        return this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }

    private String getFromAttributeName() throws CrbsAueException {
        return this.getAndCheckParamMapString("fromAttr", this.paramMap, "The attribute fromAttr is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }

    private String getFromStructMemberName() throws CrbsAueException {
        return this.getAndCheckParamMapString("structMember", this.paramMap, "The attribute structMember is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }

    private String getToAttributeName() throws CrbsAueException {
        return this.getAndCheckParamMapString("toAttr", this.paramMap, "The attribute toAttr is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }
}

