/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it14;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class RemoveStructMemberAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = RemoveStructMemberAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getMoTypeName();
        try {
            TableData tableData = this.getTableData(aueContext, string);
            if (tableData.isNotEmpty()) {
                this.removeStructMember(tableData, string);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not to get table data for: " + string, (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void removeStructMember(TableData tableData, String string) throws CrbsAueException {
        Object[] objectArray;
        String string2 = this.getAttributeName();
        String string3 = this.getStructMemberName();
        try {
            objectArray = tableData.getAttributeValues(string2);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not get table column for: " + string + "::" + string2, (Throwable)tableDataException);
        }
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                String string4;
                String string5 = objectArray[i].toString();
                if (!string5.equals(string4 = this.removeStructMemberFromArray(string3, string5, string, string2))) {
                    tableData.setAttributeValue(i, string2, (Object)string4);
                }
                logger.traceGeneral(THIS_CLASS, "Struct member \"" + string3 + "\" was successfully removed from instance " + i + " of " + string + "::" + string2 + " .");
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not set table data for: " + string + "::" + string2, (Throwable)tableDataException);
        }
    }

    private String removeStructMemberFromArray(String string, String string2, String string3, String string4) throws CrbsAueException {
        String string5 = "Could not find struct member xml end tag for " + string + " in " + string3 + "::" + string4;
        String string6 = "";
        String string7 = string2;
        String string8 = "<attr name=\"" + string + "\"";
        int n = string2.indexOf(string8);
        while (n > 0) {
            int n2 = string7.indexOf(62, n);
            if (n2 < 0) {
                throw new CrbsAueException(string5);
            }
            string6 = string6 + string7.substring(0, n);
            string7 = string7.substring(n2 + 1);
            n = string7.indexOf(string8);
        }
        return string6.trim() + string7;
    }

    private TableData getTableData(AueContext aueContext, String string) throws TableDataException {
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = tableHandler.getTableData(string);
        return tableData;
    }

    private String getMoTypeName() throws CrbsAueException {
        return this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }

    private String getAttributeName() throws CrbsAueException {
        return this.getAndCheckParamMapString("attribute", this.paramMap, "The attribute \"attribute\" is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }

    private String getStructMemberName() throws CrbsAueException {
        return this.getAndCheckParamMapString("structMember", this.paramMap, "The attribute \"structMember\" is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
    }
}

