/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it16;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CorrectFroIdInReferencesAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = CorrectFroIdInReferencesAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private String refXmlStringPrefix;
    private String refXmlStringSuffix;

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getAndCheckParamMapString("Mo", this.paramMap, "The MO type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String string2 = this.getAndCheckParamMapString("attribute", this.paramMap, "The argument attribute is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String string3 = this.getAndCheckParamMapString("refMoType", this.paramMap, "The attribute refMoType is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = this.getTableData(tableHandler, string3);
        TableData tableData2 = this.getTableData(tableHandler, string);
        if (tableData.isNotEmpty() && tableData2.isNotEmpty()) {
            Map map = this.getReferredMoTypeLdnToFroIdMap(string3, tableData);
            Object[] objectArray = this.getColumnData(string2, string, tableData2);
            for (int i = 0; i < objectArray.length; ++i) {
                String string4;
                Integer n;
                Integer n2 = this.getFroIdFromRef((String)objectArray[i], string, string2);
                if (n2.equals(n = (Integer)map.get(string4 = this.getLdnFromRef((String)objectArray[i], string, string2)))) continue;
                this.setAttributeValue(tableData2, string2, i, this.refXmlStringPrefix + n + this.refXmlStringSuffix);
            }
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private Map getReferredMoTypeLdnToFroIdMap(String string, TableData tableData) throws CrbsAueException {
        Object[] objectArray = this.getColumnData("ldn", string, tableData);
        Object[] objectArray2 = this.getColumnData("froid", string, tableData);
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            hashMap.put(objectArray[i], objectArray2[i]);
        }
        return hashMap;
    }

    private Integer getFroIdFromRef(String string, String string2, String string3) throws CrbsAueException {
        int n = string.indexOf("<attr name=\"froId\" type=\"S32\" value=\"");
        if (n < 0) {
            throw new CrbsAueException("Could not get froId value in reference for " + string2 + "::" + string3);
        }
        int n2 = n + "<attr name=\"froId\" type=\"S32\" value=\"".length();
        this.refXmlStringPrefix = string.substring(0, n2);
        int n3 = string.indexOf("\"", n2);
        if (n3 < 0) {
            throw new CrbsAueException("Could not get froId value due to missing end quote in " + string2 + "::" + string3);
        }
        this.refXmlStringSuffix = string.substring(n3);
        return new Integer(Integer.parseInt(string.substring(n2, n3)));
    }

    private String getLdnFromRef(String string, String string2, String string3) throws CrbsAueException {
        int n = string.indexOf("<attr name=\"ldn\" type=\"STRING\" value=\"");
        if (n < 0) {
            throw new CrbsAueException("Could not get LDN value in reference for " + string2 + "::" + string3);
        }
        int n2 = n + "<attr name=\"ldn\" type=\"STRING\" value=\"".length();
        int n3 = string.indexOf("\"", n2);
        if (n3 < 0) {
            throw new CrbsAueException("Could not get LDN value due to missing end quote in " + string2 + "::" + string3);
        }
        return string.substring(n2, n3);
    }

    private TableData getTableData(TableHandler tableHandler, String string) throws CrbsAueException {
        try {
            return tableHandler.getTableData(string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not get table data for: " + string, (Throwable)tableDataException);
        }
    }

    private Object[] getColumnData(String string, String string2, TableData tableData) throws CrbsAueException {
        try {
            return tableData.getAttributeValues(string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not get column data for " + string2 + "::" + string, (Throwable)tableDataException);
        }
    }

    private void setAttributeValue(TableData tableData, String string, int n, String string2) throws CrbsAueException {
        try {
            tableData.setAttributeValue(n, string, (Object)string2);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not set attribute value for " + tableData.getFroTypeName() + "::" + string, (Throwable)tableDataException);
        }
    }
}

