/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it16;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.CorrectFroTypeAndFroIdInRefAttributeActionWrapper;
import se.ericsson.lte.rbs.omf.aue.step1.CreateOneInstanceActionWrapper;
import se.ericsson.lte.rbs.omf.aue.step1.OtherFragmentUtilityWrapper;
import se.ericsson.lte.rbs.omf.aue.step1.actions.it23.CorrectFroTypeAndFroIdInRefAttributeAction;

public class CreateMoInstanceIfParentExistsAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = CreateMoInstanceIfParentExistsAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_FRAGMENT_CAT = "cat";
    private static final String CORRECT_FRO_TYPE_AND_FRO_ID_IN_REF_ATTRIBUTE_ACTION = "se.ericsson.lte.rbs.omf.aue.step1.actions.it23.CorrectFroTypeAndFroIdInRefAttributeAction";
    private static final String PARENT_REF = "parentRef";

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        boolean bl = false;
        String string = "";
        String string2 = this.getAndCheckParamMapString("Mo", this.paramMap, "The attribute Mo type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String string3 = this.getAndCheckParamMapString("name", this.paramMap, "The attribute name is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String string4 = this.getAndCheckParamMapString("frotype", this.paramMap, "The attribute frotype is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String string5 = this.getAndCheckParamMapString("parentldn", this.paramMap, "The attribute parentldn is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String string6 = this.getAndCheckParamMapString("rdnValue", this.paramMap, "The attribute rdnValue is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        try {
            string = this.getAndCheckParamMapString("parentMoFragment", this.paramMap, "Optional parameter");
            bl = true;
        }
        catch (CrbsAueException crbsAueException) {
            bl = false;
        }
        if (bl) {
            if (MO_FRAGMENT_CAT.equalsIgnoreCase(string) && OtherFragmentUtilityWrapper.getOtherFragmentUtilityInstance().isMoExistingInOtherFragment(string, string5)) {
                this.invokeCreateOneInstanceAction(aueContext, string2, string4, string6, string5, bl);
            }
        } else {
            String string7 = LdnUtil.getMoType((String)string5);
            if (this.isParentExisting(aueContext, string7, string5)) {
                this.invokeCreateOneInstanceAction(aueContext, string2, string4, string6, string5, bl);
            } else {
                logger.info(THIS_CLASS, "Could not create mo instance " + string3 + ", due to parent " + string5 + " does not exists." + " This can cause longer system downtime during upgrade.");
            }
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private boolean isParentExisting(AueContext aueContext, String string, String string2) throws CrbsAueException {
        boolean bl;
        block5: {
            bl = false;
            try {
                TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
                TableData tableData = tableHandler.getTableData(string);
                if (!tableData.isNotEmpty()) break block5;
                try {
                    Object[] objectArray = tableData.getAttributeValues("ldn");
                    for (int i = 0; i < objectArray.length; ++i) {
                        String string3 = (String)objectArray[i];
                        if (!string3.equalsIgnoreCase(string2)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (TableDataException tableDataException) {
                    throw new CrbsAueException("Could not get table column for: " + string + "::" + "ldn", (Throwable)tableDataException);
                }
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException("Could not to get table data for: " + string, (Throwable)tableDataException);
            }
        }
        return bl;
    }

    private void invokeCreateOneInstanceAction(AueContext aueContext, String string, String string2, String string3, String string4, boolean bl) throws CrbsAueException {
        CreateOneInstanceActionWrapper createOneInstanceActionWrapper = CreateOneInstanceActionWrapper.getInstance();
        CreateOneInstanceAction createOneInstanceAction = createOneInstanceActionWrapper.getCreateOneInstanceAction();
        logger.traceDebug(THIS_CLASS, "Calling CreateOneInstanceAction with Fro Type name:" + string + ", Fro Type id:" + string2 + ", Rdn Value:" + string3 + ", Parent:" + string4);
        if (bl) {
            this.paramMap.remove("parentMoFragment");
        }
        createOneInstanceAction.setMoActionArgs(this.paramMap);
        createOneInstanceAction.convert(aueContext);
        if (bl) {
            String string5 = (String)this.paramMap.get("name");
            this.paramMap.clear();
            this.paramMap.put("Mo", string5);
            this.paramMap.put("class", CORRECT_FRO_TYPE_AND_FRO_ID_IN_REF_ATTRIBUTE_ACTION);
            this.paramMap.put("attribute", PARENT_REF);
            this.paramMap.put("referredMoFragment", MO_FRAGMENT_CAT);
            this.paramMap.put("referredMoType", LdnUtil.getMoType((String)string4));
            CorrectFroTypeAndFroIdInRefAttributeActionWrapper correctFroTypeAndFroIdInRefAttributeActionWrapper = CorrectFroTypeAndFroIdInRefAttributeActionWrapper.getInstance();
            CorrectFroTypeAndFroIdInRefAttributeAction correctFroTypeAndFroIdInRefAttributeAction = correctFroTypeAndFroIdInRefAttributeActionWrapper.getCorrectFroTypeAndFroIdInRefAttributeAction();
            logger.traceDebug(THIS_CLASS, "Calling CorrectFroTypeAndFroIdInRefAttributeAction with Fro Type name" + string5 + ", attribute name:" + PARENT_REF + "parent Mo Fragment : " + MO_FRAGMENT_CAT + ", parent Mo : " + LdnUtil.getMoType((String)string4));
            correctFroTypeAndFroIdInRefAttributeAction.setMoActionArgs(this.paramMap);
            correctFroTypeAndFroIdInRefAttributeAction.convert(aueContext);
        }
    }
}

