/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it16;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class TruncateStructArrayAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = TruncateStructArrayAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getAndCheckParamMapString("Mo", this.paramMap, "The MO type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String string2 = this.getAndCheckParamMapString("name", this.paramMap, "The attribute name is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        int n = Integer.parseInt(this.getAndCheckParamMapString("length", this.paramMap, "The attribute length is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName())));
        try {
            TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
            TableData tableData = tableHandler.getTableData(string);
            if (tableData.isNotEmpty()) {
                this.truncate(tableData, string, string2, n);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not to get table data for: " + string, (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "convert");
    }

    private void truncate(TableData tableData, String string, String string2, int n) throws CrbsAueException {
        Object[] objectArray;
        try {
            objectArray = tableData.getAttributeValues(string2);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not get table column for: " + string + "::" + string2, (Throwable)tableDataException);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            String string3 = (String)objectArray[i];
            int n2 = 0;
            int n3 = string3.indexOf("</struct>", n2);
            for (int j = 0; j < n && n3 > -1; ++j) {
                n2 = n3 + "</struct>".length();
                n3 = string3.indexOf("</struct>", n2);
            }
            if (n3 <= -1) continue;
            String string4 = string3.substring(0, n2) + "</array>";
            try {
                tableData.setAttributeValue(i, string2, (Object)string4);
                continue;
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException("Could not set table data for: " + string + "::" + string2, (Throwable)tableDataException);
            }
        }
    }
}

