/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it18;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroAttributesTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsData;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CleanUpCatFroTypesAction
extends AbstractConversionAction {
    private final Map moTypesToRemoveMap = new HashMap();
    private static final Class THIS_CLASS = CleanUpCatFroTypesAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public CleanUpCatFroTypesAction() {
        this.moTypesToRemoveMap.put("SectorEquipmentFunction", null);
        this.moTypesToRemoveMap.put("RbsSlot", null);
        this.moTypesToRemoveMap.put("AntennaSubunit", null);
        this.moTypesToRemoveMap.put("ResourceAllocationFunction", null);
        this.moTypesToRemoveMap.put("AntennaUnit", null);
        this.moTypesToRemoveMap.put("DeviceGroup", null);
        this.moTypesToRemoveMap.put("SubDeviceGroup", null);
        this.moTypesToRemoveMap.put("RicmDeviceSet", null);
        this.moTypesToRemoveMap.put("XpProgram", null);
        this.moTypesToRemoveMap.put("TrDeviceSet", null);
        this.moTypesToRemoveMap.put("RbsSubrack", null);
        this.moTypesToRemoveMap.put("AuPort", null);
        this.moTypesToRemoveMap.put("RfPort", null);
        this.moTypesToRemoveMap.put("RfBranch", null);
        this.moTypesToRemoveMap.put("AntennaUnitGroup", null);
        this.moTypesToRemoveMap.put("RiPort", null);
        this.moTypesToRemoveMap.put("AuxPlugInUnit", null);
        this.moTypesToRemoveMap.put("SystemConstants", null);
        this.moTypesToRemoveMap.put("CellDeviceSet", null);
        this.moTypesToRemoveMap.put("SrioTestPort", null);
        this.moTypesToRemoveMap.put("UcToolFunction", null);
        this.moTypesToRemoveMap.put("XmuDeviceSet", null);
        this.moTypesToRemoveMap.put("AntennaCtrlDevice", null);
        this.moTypesToRemoveMap.put("AntennaPath", null);
        this.moTypesToRemoveMap.put("NodeManagementFunction", null);
        this.moTypesToRemoveMap.put("AntennaNearUnit", null);
        this.moTypesToRemoveMap.put("ExternalTMA", null);
        this.moTypesToRemoveMap.put("ExtTmaConnector", null);
        this.moTypesToRemoveMap.put("RetSubUnit", null);
        this.moTypesToRemoveMap.put("TmaSubUnit", null);
        this.moTypesToRemoveMap.put("UnitHandling", null);
    }

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        FroVersionsTable froVersionsTable = tableHandler.getFroVersionsTable();
        FroVersionsData[] froVersionsDataArray = froVersionsTable.getDatas();
        logger.traceDebug(THIS_CLASS, "froVersionsData.length = " + froVersionsDataArray.length);
        if (froVersionsDataArray.length > 0) {
            this.cleanUp(tableHandler, froVersionsDataArray, froVersionsTable);
        } else {
            logger.traceDebug(THIS_CLASS, "fro_versions table is empty.");
        }
        froVersionsDataArray = null;
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void cleanUp(TableHandler tableHandler, FroVersionsData[] froVersionsDataArray, FroVersionsTable froVersionsTable) throws CrbsAueException {
        FroAttributesTable froAttributesTable = tableHandler.getFroAttributesTable();
        for (int i = 0; i < froVersionsDataArray.length; ++i) {
            if (!this.moTypesToRemoveMap.containsKey(froVersionsDataArray[i].froTypeName)) continue;
            this.cleanUpOneMoType(tableHandler, froVersionsDataArray[i].froType, froVersionsDataArray[i].froTypeName, froVersionsTable, froAttributesTable);
        }
    }

    private void cleanUpOneMoType(TableHandler tableHandler, int n, String string, FroVersionsTable froVersionsTable, FroAttributesTable froAttributesTable) throws CrbsAueException {
        logger.traceDebug(THIS_CLASS, "cleanUpOneMoType: " + string + ", " + n);
        try {
            froVersionsTable.deleteFroTypeId(n);
            this.deleteFromFroAttributesIgnoreException(n, froAttributesTable);
            TableData tableData = tableHandler.getTableData(string);
            tableData.clearAllData();
            tableData.setTableDataUpdated(false);
            tableData.deleteMoType();
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Caugth TableDataException: ", (Throwable)tableDataException);
        }
    }

    private void deleteFromFroAttributesIgnoreException(int n, FroAttributesTable froAttributesTable) {
        try {
            froAttributesTable.deleteFromTable(n);
        }
        catch (TableDataException tableDataException) {
            logger.traceDebug(THIS_CLASS, "In fro_attributes nothing to remove for frotype: " + n);
        }
    }
}

