/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it18;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;

public class CreateSectorCarriersAction
extends AbstractConversionAction {
    private static final Integer FRO_TYPE_SECTOR_CARRIER = new Integer(117833729);
    private static final String MO_TYPE_SECTOR_CARRIER = "SectorCarrier";
    private static final String ATTRIBUTE_FRO_ID = "froId";
    private static final String ATTRIBUTE_LDN = "ldn";
    private static final String ATTRIBUTE_PARENT_REF = "parentRef";
    private static final String ARRAY_END = "</array>";
    private static final String ARRAY_START_2 = "\">";
    private static final String ARRAY_START_1 = "<array name=\"";
    private static final String ATTRIBUTE_SECTOR_FUNCTION_REF = "sectorFunctionRef";
    private static final String ATTRIBUTE_NO_OF_RX_ANTENNAS = "noOfRxAntennas";
    private static final String ATTRIBUTE_NO_OF_TX_ANTENNAS = "noOfTxAntennas";
    private static final String ATTRIBUTE_PART_OF_SECTOR_POWER = "partOfSectorPower";
    private static final String ATTRIBUTE_PRS_ENABLED = "prsEnabled";
    private static final String ATTRIBUTE_SECTOR_CARRIER_REF = "sectorCarrierRef";
    private static final String[] SECTOR_CARRIER_ATTRIBUTE_NAMES = new String[]{"froId", "ldn", "parentRef", "sectorFunctionRef", "noOfRxAntennas", "noOfTxAntennas", "partOfSectorPower", "prsEnabled"};
    private static final Class THIS_CLASS = CreateSectorCarriersAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String HASH = "#";
    private int auePersistencyRow = 0;

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getAndCheckParamMapString("Mo", this.paramMap, "The MO type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = this.getTableData(tableHandler, string);
        if (tableData.isNotEmpty()) {
            TableData tableData2;
            logger.traceDebug(THIS_CLASS, "Found data for " + string);
            try {
                tableData2 = tableHandler.createNewEmptyTableData(FRO_TYPE_SECTOR_CARRIER, MO_TYPE_SECTOR_CARRIER);
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException("Could not create new empty table data for SectorCarrier:", (Throwable)tableDataException);
            }
            this.addColumnsToSectorCarrierFroDataTable(MO_TYPE_SECTOR_CARRIER, tableData2);
            Object[] objectArray = this.getColumnData(string, ATTRIBUTE_LDN, tableData);
            Object[] objectArray2 = this.getColumnData(string, ATTRIBUTE_SECTOR_FUNCTION_REF, tableData);
            Object[] objectArray3 = this.getColumnData(string, ATTRIBUTE_NO_OF_RX_ANTENNAS, tableData);
            Object[] objectArray4 = this.getColumnData(string, ATTRIBUTE_NO_OF_TX_ANTENNAS, tableData);
            Object[] objectArray5 = this.getColumnData(string, ATTRIBUTE_PART_OF_SECTOR_POWER, tableData);
            Object[] objectArray6 = this.getColumnData(string, ATTRIBUTE_PARENT_REF, tableData);
            int n = tableData.getNumberOfRecords();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)objectArray[i];
                Integer n2 = new Integer(i);
                String string3 = LdnUtil.getRdnValue((String)string2);
                String string4 = "ManagedElement=1,ENodeBFunction=1,SectorCarrier=" + string3;
                logger.traceDebug(THIS_CLASS, "CREATE_SECTORCARRIER " + string4);
                Object[] objectArray7 = new Object[]{n2, string4, objectArray6[i], objectArray2[i], objectArray3[i], objectArray4[i], objectArray5[i], new Integer(1)};
                this.addRowToSectorCarrier(MO_TYPE_SECTOR_CARRIER, tableData2, objectArray7);
                String string5 = "<array name=\"sectorCarrierRef\">" + TableDataUtil.createMoRefInArrayXmlString((String)string4, (String)FRO_TYPE_SECTOR_CARRIER.toString(), (String)n2.toString()) + ARRAY_END;
                this.setColumnData(string, i, ATTRIBUTE_SECTOR_CARRIER_REF, string5, tableData);
                this.setColumnData(string, i, ATTRIBUTE_SECTOR_FUNCTION_REF, TableDataUtil.createEmptyMoRefXmlString((String)ATTRIBUTE_SECTOR_FUNCTION_REF), tableData);
                this.writeToPersistencyTable(string4, TableDataUtil.getLdnFromMoRef((String)((String)objectArray2[i])), (String)objectArray[i], tableHandler);
            }
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void addRowToSectorCarrier(String string, TableData tableData, Object[] objectArray) throws CrbsAueException {
        try {
            tableData.addAttributeValues(SECTOR_CARRIER_ATTRIBUTE_NAMES, objectArray);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not add database row for " + string + ". ", (Throwable)tableDataException);
        }
    }

    private void addColumnsToSectorCarrierFroDataTable(String string, TableData tableData) throws CrbsAueException {
        try {
            tableData.addAttribute(ATTRIBUTE_FRO_ID, "S32", "0");
            tableData.setPrimaryKey(ATTRIBUTE_FRO_ID, true);
            tableData.addAttribute(ATTRIBUTE_LDN, "STRING", "");
            tableData.addAttribute(ATTRIBUTE_PARENT_REF, "moref", "");
            tableData.addAttribute(ATTRIBUTE_SECTOR_FUNCTION_REF, "moref", TableDataUtil.createEmptyMoRefXmlString((String)ATTRIBUTE_SECTOR_FUNCTION_REF));
            tableData.addAttribute(ATTRIBUTE_NO_OF_RX_ANTENNAS, "S32", "0");
            tableData.addAttribute(ATTRIBUTE_NO_OF_TX_ANTENNAS, "S32", "0");
            tableData.addAttribute(ATTRIBUTE_PART_OF_SECTOR_POWER, "S32", "0");
            tableData.addAttribute(ATTRIBUTE_PRS_ENABLED, "S32", "1");
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not add database column to " + string + ": ", (Throwable)tableDataException);
        }
    }

    private TableData getTableData(TableHandler tableHandler, String string) throws CrbsAueException {
        try {
            return tableHandler.getTableData(string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not get table data for: " + string, (Throwable)tableDataException);
        }
    }

    private Object[] getColumnData(String string, String string2, TableData tableData) throws CrbsAueException {
        try {
            return tableData.getAttributeValues(string2);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not get column data for " + string + ":" + string2, (Throwable)tableDataException);
        }
    }

    private void setColumnData(String string, int n, String string2, String string3, TableData tableData) throws CrbsAueException {
        try {
            tableData.setAttributeValue(n, string2, (Object)string3);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not set column data for " + string + ":" + string2, (Throwable)tableDataException);
        }
    }

    private void writeToPersistencyTable(String string, String string2, String string3, TableHandler tableHandler) throws CrbsAueException {
        try {
            tableHandler.storeInAuePersistency(MO_TYPE_SECTOR_CARRIER, String.valueOf(this.auePersistencyRow++), string + HASH + string2 + HASH + string3);
        }
        catch (TableDataException tableDataException) {
            logger.traceError(THIS_CLASS, "Could not store in AuePersistency table: " + string, (Throwable)tableDataException);
            throw new CrbsAueException("Could not store in AuePersistency table: " + string, (Throwable)tableDataException);
        }
    }
}

