/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it18;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class SimpleDeleteMoInstanceAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = SimpleDeleteMoInstanceAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getAndCheckParamMapString("ldn", this.paramMap, "The ldn is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            this.deleteMoInstance(tableHandler, string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to run action: " + THIS_CLASS.getName(), (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void deleteMoInstance(TableHandler tableHandler, String string) throws CrbsAueException, TableDataException {
        String string2 = this.getFroTypeFromLdn(string);
        TableData tableData = null;
        try {
            tableData = tableHandler.getTableData(string2);
        }
        catch (TableDataException tableDataException) {
            logger.traceDebug(THIS_CLASS, "Could not delete Mo instance " + AueUtil.doubleQuote((String)string) + " due to no data for Mo type.");
        }
        if (tableData != null && tableData.isNotEmpty()) {
            Object[] objectArray = tableData.getAttributeValues("ldn");
            int n = -1;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!string.equals(objectArray[i].toString())) continue;
                n = i;
                break;
            }
            if (n > -1) {
                tableData.deleteRowData(n);
                logger.traceGeneral(THIS_CLASS, "Mo instance, " + AueUtil.doubleQuote((String)string) + ", is removed");
            } else {
                String string3 = "Could not find Mo instance " + AueUtil.doubleQuote((String)string) + ", for deletion!";
                logger.traceDebug(THIS_CLASS, string3);
            }
        }
    }
}

