/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it20;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;
import se.ericsson.lte.rbs.omf.aue.step1.actions.it20.XmlStructArray2ArrayList;

public class RemoveDefaultStructFillingsOfArrayAction
extends AbstractStep1ConversionAction {
    private TypedStructImpl defaultStruct;
    protected static final String XML_STRING_DEFAULT_STRUCT = "defaultStruct";
    private static final Class THIS_CLASS = RemoveDefaultStructFillingsOfArrayAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private String moType;

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        this.moType = this.getAndCheckParamMapString("Mo", this.paramMap, "The MO type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        TableData tableData = this.getTableData(tableHandler, this.moType);
        if (tableData.isNotEmpty()) {
            String string = this.getAndCheckParamMapString("attribute", this.paramMap, "The attribute name is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
            String string2 = this.getAndCheckParamMapString(XML_STRING_DEFAULT_STRUCT, this.paramMap, "The default struct is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
            this.defaultStruct = this.convertToStruct(string2);
            Object[] objectArray = this.getAttributeColumn(tableData, this.moType, string);
            for (int i = 0; i < objectArray.length; ++i) {
                String string3 = objectArray[i].toString();
                this.removeDefaultStructFillings(i, tableData, string, string3);
            }
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void removeDefaultStructFillings(int n, TableData tableData, String string, String string2) throws CrbsAueException {
        try {
            String string3 = "<array name=\"" + string + "\">";
            XmlStructArray2ArrayList xmlStructArray2ArrayList = new XmlStructArray2ArrayList(string2);
            Iterator iterator = xmlStructArray2ArrayList.getStructList().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                StructImpl structImpl = (StructImpl)iterator.next();
                if (this.areStructValuesDefault((Struct)structImpl)) {
                    bl = true;
                    break;
                }
                string3 = string3 + this.createStructString(structImpl);
            }
            if (bl) {
                string3 = string3 + "</array>";
                tableData.setAttributeValue(n, string, (Object)string3);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not set attribute " + this.moType + "::" + string + ".", (Throwable)tableDataException);
        }
        catch (MoAccessException moAccessException) {
            throw new CrbsAueException("Struct member in defaultStruct unknown.", (Throwable)moAccessException);
        }
    }

    private String createStructString(StructImpl structImpl) throws MoAccessException {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<struct>");
        String[] stringArray = structImpl.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            stringBuffer.append("<attr name=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" type=\"");
            stringBuffer.append(this.defaultStruct.getType(string));
            stringBuffer.append("\" value=\"");
            stringBuffer.append(structImpl.getValue(string));
            stringBuffer.append("\"/>");
        }
        stringBuffer.append("</struct>");
        return stringBuffer.toString();
    }

    private boolean areStructValuesDefault(Struct struct) throws MoAccessException {
        Object object;
        Object object2;
        boolean bl = true;
        String[] stringArray = this.defaultStruct.getNames();
        for (int i = 0; i < stringArray.length && (bl = (object2 = this.defaultStruct.getValue(stringArray[i])).equals(object = struct.getValue(stringArray[i]))); ++i) {
        }
        return bl;
    }

    private TypedStructImpl convertToStruct(String string) throws CrbsAueException {
        String string2;
        int n = 0;
        int n2 = string.indexOf(44);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        while (n2 > -1) {
            string2 = string.substring(n, n2);
            this.putStructMemberPartsInArrays(string2, arrayList, arrayList2, arrayList3);
            n = n2 + 1;
            n2 = string.indexOf(44, n);
        }
        string2 = string.substring(n, string.length());
        this.putStructMemberPartsInArrays(string2, arrayList, arrayList2, arrayList3);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        String[] stringArray2 = arrayList2.toArray(new String[arrayList2.size()]);
        Object[] objectArray = arrayList3.toArray(new Object[arrayList3.size()]);
        return new TypedStructImpl(stringArray, stringArray2, objectArray);
    }

    private void putStructMemberPartsInArrays(String string, List list, List list2, List list3) throws CrbsAueException {
        int n = 0;
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            throw new CrbsAueException("The default struct has invalid format for struct member \"" + string + "\". Format should be: name:type:value.");
        }
        list.add(string.substring(n, n2));
        n = n2 + 1;
        n2 = string.indexOf(58, n);
        if (n2 == -1) {
            throw new CrbsAueException("The default struct has invalid format for struct member \"" + string + "\". Format should be: name:type:value.");
        }
        list2.add(string.substring(n, n2));
        n = n2 + 1;
        list3.add(string.substring(n, string.length()));
    }

    private class TypedStructImpl
    extends StructImpl {
        private final Map typesMap;

        public TypedStructImpl(String[] stringArray, String[] stringArray2, Object[] objectArray) throws CrbsAueException {
            super(stringArray, objectArray);
            this.typesMap = new HashMap();
            for (int i = 0; i < stringArray.length; ++i) {
                this.typesMap.put(stringArray[i], stringArray2[i]);
            }
        }

        public String getType(String string) {
            return (String)this.typesMap.get(string);
        }
    }
}

