/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it20;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;

public class RemoveUnusedExternalEUtranCellsAction
extends AbstractStep1ConversionAction {
    private static final String AUE_PERSISTENCY_DBKEY = "RemoveUnusedExternalEUtranCellsAction";
    private static final String MO_TYPE_EUTRAN_CELL_RELATION = "EUtranCellRelation";
    private static final String ATTRIBUTE_LDN = "ldn";
    private static final String ATTRIBUTE_NEIGHBOR_CELL_REF = "neighborCellRef";
    private static final String ATTRIBUTE_EUTRAN_FREQUENCY_REF = "eutranFrequencyRef";
    private static final String ATTRIBUTE_IS_REMOVED_ALLOWED = "isRemoveAllowed";
    private static final int IS_REMOVE_ALLOWED_TRUE = 1;
    private static final Class THIS_CLASS = RemoveUnusedExternalEUtranCellsAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getValueFromModificationFile("Mo");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = this.getTableData(tableHandler, string);
        if (tableData.isNotEmpty()) {
            TableData tableData2 = this.getTableData(tableHandler, MO_TYPE_EUTRAN_CELL_RELATION);
            Map map = this.createReferredNeighborsMap(tableData2);
            Object[] objectArray = this.getAttributeColumn(tableData, string, ATTRIBUTE_LDN);
            Object[] objectArray2 = this.getAttributeColumn(tableData, string, ATTRIBUTE_EUTRAN_FREQUENCY_REF);
            Object[] objectArray3 = this.getAttributeColumn(tableData, string, ATTRIBUTE_IS_REMOVED_ALLOWED);
            int n = tableData.getNumberOfRecords();
            for (int i = n - 1; i >= 0; --i) {
                if (map.containsKey(objectArray[i]) || (Integer)objectArray3[i] != 1) continue;
                tableData.deleteRowData(i);
                String string2 = "RemoveUnusedExternalEUtranCellsAction#" + string;
                String string3 = (String)objectArray[i] + '#' + TableDataUtil.getLdnFromMoRef((String)((String)objectArray2[i]));
                this.writeToPersistencyTable(string2, string3, tableHandler);
            }
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private Map createReferredNeighborsMap(TableData tableData) throws CrbsAueException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (tableData.isNotEmpty()) {
            Object[] objectArray = this.getAttributeColumn(tableData, MO_TYPE_EUTRAN_CELL_RELATION, ATTRIBUTE_NEIGHBOR_CELL_REF);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                String string = TableDataUtil.getLdnFromMoRef((String)((String)objectArray[i]));
                hashMap.put(string, null);
            }
        }
        return hashMap;
    }
}

