/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it21;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;

public class RemoveCellRelationsIfMoreThanMaxAllowedAction
extends AbstractStep1ConversionAction {
    private static final String AUE_PERSISTENCY_DBKEY = "RemoveCellRelationsIfMoreThanMaxAllowedAction";
    private static final String MO_TYPE_UTRAN_CELL_RELATION = "UtranCellRelation";
    private static final String ATTRIBUTE_LDN = "ldn";
    private static final String ATTRIBUTE_REMOVING_MONITORING_START = "removingMonitoringStart";
    private static final String ATTRIBUTE_EXTERNAL_UTRAN_CELL_FDD_REF = "externalUtranCellFDDRef";
    private static final String ATTRIBUTE_MAX_NR_UTRAN_CELL_RELATIONS = "maxNrUtranCellRelations";
    private static final Class THIS_CLASS = RemoveCellRelationsIfMoreThanMaxAllowedAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException {
        TableData tableData;
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getValueFromModificationFile("Mo");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData2 = this.getTableData(tableHandler, string);
        if (tableData2.isNotEmpty() && (tableData = this.getTableData(tableHandler, MO_TYPE_UTRAN_CELL_RELATION)).isNotEmpty()) {
            int n;
            Object[] objectArray = this.getAttributeColumn(tableData, MO_TYPE_UTRAN_CELL_RELATION, ATTRIBUTE_LDN);
            Object[] objectArray2 = this.getAttributeColumn(tableData, MO_TYPE_UTRAN_CELL_RELATION, ATTRIBUTE_EXTERNAL_UTRAN_CELL_FDD_REF);
            List list = this.createLdnBucketList(string, tableData2, tableData, objectArray);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 0; n < list.size(); ++n) {
                UtranFreqRelation utranFreqRelation = (UtranFreqRelation)list.get(n);
                Collections.sort(utranFreqRelation.getUtranCellRelations());
                int n2 = utranFreqRelation.getUtranCellRelations().size() - utranFreqRelation.maxNrUtranCellRelation;
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(new Integer(((UtranCellRelation)utranFreqRelation.getUtranCellRelations().get(i)).row));
                }
            }
            Collections.sort(arrayList);
            for (n = arrayList.size() - 1; n > -1; --n) {
                tableData.deleteRowData(((Integer)arrayList.get(n)).intValue());
                String string2 = (String)objectArray[(Integer)arrayList.get(n)] + '#' + TableDataUtil.getLdnFromMoRef((String)((String)objectArray2[(Integer)arrayList.get(n)]));
                this.writeToPersistencyTable("RemoveCellRelationsIfMoreThanMaxAllowedAction#UtranCellRelation", string2, tableHandler);
            }
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private List createLdnBucketList(String string, TableData tableData, TableData tableData2, Object[] objectArray) throws CrbsAueException {
        ArrayList<UtranFreqRelation> arrayList = new ArrayList<UtranFreqRelation>();
        Object[] objectArray2 = this.getAttributeColumn(tableData, string, ATTRIBUTE_LDN);
        Object[] objectArray3 = this.getAttributeColumn(tableData, string, ATTRIBUTE_MAX_NR_UTRAN_CELL_RELATIONS);
        Object[] objectArray4 = this.getAttributeColumn(tableData2, MO_TYPE_UTRAN_CELL_RELATION, ATTRIBUTE_REMOVING_MONITORING_START);
        int n = objectArray2.length;
        int n2 = objectArray.length;
        String string2 = null;
        ArrayList<UtranCellRelation> arrayList2 = new ArrayList<UtranCellRelation>();
        for (int i = 0; i < n; ++i) {
            arrayList2.clear();
            string2 = (String)objectArray2[i];
            int n3 = (Integer)objectArray3[i];
            for (int j = 0; j < n2; ++j) {
                if (((String)objectArray[j]).indexOf(string2.concat(",")) == -1) continue;
                try {
                    arrayList2.add(new UtranCellRelation(j, (String)objectArray4[j]));
                    continue;
                }
                catch (ParseException parseException) {
                    logger.traceError(THIS_CLASS, "Problem to parse " + (String)objectArray4[j], (Throwable)parseException);
                    throw new CrbsAueException("Problem to parse ", (Throwable)parseException);
                }
            }
            if (arrayList2.size() <= n3) continue;
            arrayList.add(new UtranFreqRelation(n3, new ArrayList(arrayList2)));
        }
        return arrayList;
    }

    private class UtranCellRelation
    implements Comparable {
        private final int row;
        private final Long time;

        protected UtranCellRelation(int n, String string) throws ParseException {
            String string2 = string;
            this.row = n;
            if (string2.length() == 0) {
                string2 = "1970-01-01 00:00";
            }
            this.time = new Long(new SimpleDateFormat("yyyy-mm-dd HH:mm").parse(string2).getTime());
        }

        public Long getTime() {
            return this.time;
        }

        public int compareTo(Object object) {
            return this.getTime().compareTo(((UtranCellRelation)object).getTime());
        }
    }

    private class UtranFreqRelation {
        private final int maxNrUtranCellRelation;
        private final List utranCellRelations;

        protected UtranFreqRelation(int n, List list) {
            this.maxNrUtranCellRelation = n;
            this.utranCellRelations = list;
        }

        public List getUtranCellRelations() {
            return this.utranCellRelations;
        }
    }
}

