/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it22;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;

public class MoveExternalGeranCellAction
extends AbstractStep1ConversionAction {
    private static final String AUE_PERSISTENCY_DBKEY_UPDATE_LDN = "UpdateLdn_";
    private static final String AUE_PERSISTENCY_DBKEY_ADD_REF_RESERVED_BY = "AddRefAndReservedBy_";
    private static final String EXTERNAL_GERAN_CELL_MO_TYPE = "EXTERNALGERANCELL";
    private static final String EXTERNAL_GERAN_CELL_MO_TYPE_LOWER_CASES = "ExternalGeranCell";
    private static final String GERAN_FREQUENCY_REF_ATTRIBUTE = "geranFrequencyRef";
    private static final String RDN_VALUE_SEPARATOR__ = "__";
    private static final String MO_REF_START_XML = "<moref name=\"parentRef\"><attr name=\"ldn\" type=\"STRING\" value=\"";
    private static final String MO_REF_FROTYPE_XML = "\"/><attr name=\"froType\" type=\"S32\" value=\"";
    private static final String MO_REF_FROID = "\"/><attr name=\"froId\" type=\"S32\" value=\"";
    private static final String MO_REF_END_XML = "\"/></moref>";
    private static String geraNetworkLdn = "";
    private static final Integer GERA_NETWORK_FRO_ID = new Integer(-1);
    private static final Integer GERA_NETWORK_FRO_TYPE = new Integer(-1);
    private static final Class THIS_CLASS = MoveExternalGeranCellAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getAndCheckParamMapString("Mo", this.paramMap, "The attribute Mo copy from is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        if (!EXTERNAL_GERAN_CELL_MO_TYPE_LOWER_CASES.equals(string)) {
            throw new CrbsAueException(THIS_CLASS + " This action is under " + string + " in the modification file, but it must be under " + EXTERNAL_GERAN_CELL_MO_TYPE_LOWER_CASES);
        }
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = this.getTableData(tableHandler, string);
        if (tableData.isNotEmpty()) {
            Object[] objectArray = this.getAttributeColumn(tableData, string, "ldn");
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = (String)objectArray[i];
                if (string2.indexOf(RDN_VALUE_SEPARATOR__) > -1) {
                    throw new CrbsAueException(THIS_CLASS + " a MO already have double underscore in the LDN: " + string2);
                }
                String string3 = LdnUtil.getParentLdn((String)string2);
                String string4 = LdnUtil.getRdnValue((String)string3);
                String string5 = LdnUtil.getParentLdn((String)string3);
                String string6 = LdnUtil.getRdnValue((String)string5);
                geraNetworkLdn = LdnUtil.getParentLdn((String)string5);
                String string7 = LdnUtil.getRdnValue((String)string2);
                String string8 = geraNetworkLdn + "," + LdnUtil.getTypeNameFromLdn((String)string2) + "=" + string6 + RDN_VALUE_SEPARATOR__ + string4 + RDN_VALUE_SEPARATOR__ + string7;
                this.updateLdnColumn(string, tableHandler, tableData, string2, string8, i);
                String string9 = geraNetworkLdn + "," + LdnUtil.getTypeNameFromLdn((String)string3) + "=" + string6 + RDN_VALUE_SEPARATOR__ + string4;
                this.updateGeranFrequencyRef(string, tableHandler, tableData, string9, string8, string3, i);
                this.updateParentRef(string, GERA_NETWORK_FRO_ID, GERA_NETWORK_FRO_TYPE, tableData, i);
            }
        }
    }

    private void updateParentRef(String string, Integer n, Integer n2, TableData tableData, int n3) throws CrbsAueException {
        String string2 = MO_REF_START_XML + geraNetworkLdn + MO_REF_FROTYPE_XML + n2 + MO_REF_FROID + n + MO_REF_END_XML;
        try {
            tableData.setAttributeValue(n3, "parentRef", (Object)string2);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(THIS_CLASS + " could not set " + "parentRef" + " in Mo type " + string, (Throwable)tableDataException);
        }
    }

    private void updateLdnColumn(String string, TableHandler tableHandler, TableData tableData, String string2, String string3, int n) throws CrbsAueException {
        try {
            tableData.setAttributeValue(n, "ldn", (Object)string3);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(THIS_CLASS + " could not set " + "ldn" + " in Mo type " + string, (Throwable)tableDataException);
        }
        String string4 = string2 + '#' + string3;
        this.writeToPersistencyTable("UpdateLdn_EXTERNALGERANCELL", string4, tableHandler);
    }

    private void updateGeranFrequencyRef(String string, TableHandler tableHandler, TableData tableData, String string2, String string3, String string4, int n) throws CrbsAueException {
        Object[] objectArray = this.getAttributeColumn(tableData, string, "parentRef");
        String string5 = AueUtil.replaceInString((String)((String)objectArray[n]), (String)"parentRef", (String)GERAN_FREQUENCY_REF_ATTRIBUTE);
        String string6 = AueUtil.replaceInString((String)string5, (String)string4, (String)string2);
        try {
            tableData.setAttributeValue(n, GERAN_FREQUENCY_REF_ATTRIBUTE, (Object)string6);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(THIS_CLASS + " could not set " + GERAN_FREQUENCY_REF_ATTRIBUTE + " in Mo type " + string, (Throwable)tableDataException);
        }
        String string7 = string3 + '#' + string2;
        this.writeToPersistencyTable("AddRefAndReservedBy_EXTERNALGERANCELL", string7, tableHandler);
    }
}

