/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it22;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;
import se.ericsson.lte.rbs.omf.aue.step1.StructUtilityWrapper;

public class RemapStructS32MemberRangeAction
extends AbstractStep1ConversionAction {
    private static final Class THIS_CLASS = RemapStructS32MemberRangeAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static List valueList = null;
    private static final String TEXT_LOWBOUND = "lowBound";
    private static final String TEXT_HIBOUND = "hiBound";
    private static final String TEXT_SETVALUE = "setValue";

    public void convert(AueContext aueContext) throws CrbsAueException, NoSuchTableException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String string2 = this.getAndCheckParamMapString("name", this.paramMap, "No attribute name is specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String string3 = this.getAndCheckParamMapString("structMember", this.paramMap, "No structMember is specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String string4 = this.getAndCheckParamMapString("mapping", this.paramMap, "No mapping is specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        valueList = this.parseMappingString(string4);
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            TableData tableData = tableHandler.getTableData(string);
            if (tableData.isNotEmpty()) {
                this.modifyS32StructMemberValue(string, string2, string3, tableData);
            }
        }
        catch (TableDataException tableDataException) {
            String string5 = "Could not modify attribute, " + AueUtil.doubleQuote((String)string2) + ", in, " + string;
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason((String)string5, (Throwable)tableDataException));
            throw new CrbsAueException(string5, (Throwable)tableDataException);
        }
    }

    protected List parseMappingString(String string) throws CrbsAueException {
        String[] stringArray = new String[]{TEXT_LOWBOUND, TEXT_HIBOUND, TEXT_SETVALUE};
        ArrayList<StructImpl> arrayList = new ArrayList<StructImpl>();
        String string2 = AueUtil.replaceInString((String)string, (String)" ", (String)"");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.toLowerCase(Locale.US).indexOf("to");
            int n2 = string3.indexOf(58);
            try {
                Integer n3 = null;
                Integer n4 = null;
                Integer n5 = null;
                if (n > 0) {
                    n3 = Integer.valueOf(string3.substring(0, n));
                }
                if (n2 - (n + 2) > 0) {
                    n4 = Integer.valueOf(string3.substring(n + 2, n2));
                }
                if (string3.length() - (n2 + 1) > 0) {
                    n5 = Integer.valueOf(string3.substring(n2 + 1));
                }
                Object[] objectArray = new Integer[]{n3, n4, n5};
                arrayList.add(new StructImpl(stringArray, objectArray));
            }
            catch (NumberFormatException numberFormatException) {
                throw new CrbsAueException("The parsing of " + string3 + " could not be done.");
            }
        }
        return arrayList;
    }

    private void modifyS32StructMemberValue(String string, String string2, String string3, TableData tableData) throws TableDataException, CrbsAueException {
        Object[] objectArray = tableData.getAttributeValues(string2);
        Integer n = null;
        Integer n2 = null;
        int n3 = tableData.getNumberOfRecords();
        for (int i = 0; i < n3; ++i) {
            String string4;
            Object object = objectArray[i];
            if (object == null) {
                throw new CrbsAueException("The struct attribute to modify is NULL!");
            }
            try {
                string4 = StructUtilityWrapper.getStructUtilityInstance().getStructMemberValue(object.toString(), string3, string, string2);
                n = Integer.valueOf(string4);
                n2 = this.evaluateInput(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CrbsAueException("The attribute value " + object.toString() + " is not a valid Long number.");
            }
            if (n2.compareTo(n) == 0) continue;
            string4 = StructUtilityWrapper.getStructUtilityInstance().setStructMemberValue(object.toString(), string3, n2.toString(), string, string2);
            tableData.setAttributeValue(i, string2, (Object)string4);
            logger.traceGeneral(THIS_CLASS, "Struct member " + string3 + " value modified, from " + AueUtil.doubleQuote((String)n.toString()) + " to " + AueUtil.doubleQuote((String)n2.toString()) + ", in attribute, " + AueUtil.doubleQuote((String)string2) + ", in, " + AueUtil.doubleQuote((String)tableData.getTableName()));
        }
    }

    private Integer evaluateInput(Integer n) throws CrbsAueException {
        Integer n2 = n;
        Integer n3 = null;
        Integer n4 = null;
        Integer n5 = null;
        Iterator iterator = valueList.iterator();
        while (iterator.hasNext()) {
            Struct struct = (Struct)iterator.next();
            try {
                n3 = (Integer)struct.getValue(TEXT_LOWBOUND);
                n4 = (Integer)struct.getValue(TEXT_HIBOUND);
                n5 = (Integer)struct.getValue(TEXT_SETVALUE);
                if (n5 == null) {
                    throw new CrbsAueException("The value to set must be defined in the mapping.");
                }
            }
            catch (Exception exception) {
                logger.traceError(THIS_CLASS, "Could not evaluate input.", (Throwable)exception);
                throw new CrbsAueException("Could not evaluate input.", (Throwable)exception);
            }
            n2 = this.getWorkingData(n, n3, n4, n5);
        }
        return n2;
    }

    private Integer getWorkingData(Integer n, Integer n2, Integer n3, Integer n4) {
        Integer n5 = n;
        if (n2 == null && n3 == null) {
            n5 = n4;
        } else if (this.isOnlyHighBoundSpecified(n, n2, n3)) {
            n5 = n4;
        } else if (this.isOnlyLowBoundSpecified(n, n2, n3)) {
            n5 = n4;
        } else if (this.isBothHighAndLowBoundsSpecified(n, n2, n3)) {
            n5 = n4;
        }
        return n5;
    }

    private boolean isBothHighAndLowBoundsSpecified(Integer n, Integer n2, Integer n3) {
        return n2 != null && n3 != null && 0 <= n.compareTo(n2) && n.compareTo(n3) <= 0;
    }

    private boolean isOnlyLowBoundSpecified(Integer n, Integer n2, Integer n3) {
        return n3 == null && 0 <= n.compareTo(n2);
    }

    private boolean isOnlyHighBoundSpecified(Integer n, Integer n2, Integer n3) {
        return n2 == null && n.compareTo(n3) <= 0;
    }
}

