/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it22;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;

public class RescaleAttributeAction
extends AbstractStep1ConversionAction {
    private static final Class THIS_CLASS = RescaleAttributeAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getValueFromModificationFile("Mo");
        String string2 = this.getValueFromModificationFile("attribute");
        String string3 = this.getValueFromModificationFile("multiplicationFactor");
        try {
            int n = Integer.parseInt(string3);
            TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
            TableData tableData = this.getTableData(tableHandler, string);
            if (tableData.isNotEmpty()) {
                Object[] objectArray = this.getAttributeColumn(tableData, string, string2);
                int n2 = tableData.getNumberOfRecords();
                for (int i = 0; i < n2; ++i) {
                    int n3 = (Integer)objectArray[i] * n;
                    this.setAttributeValue(tableData, string, i, string2, new Integer(n3));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.traceError(THIS_CLASS, "The attribute value and multiplication factor must be integers.", (Throwable)numberFormatException);
            throw new CrbsAueException("The attribute value and multiplication factor must be integers.", (Throwable)numberFormatException);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }
}

