/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it23;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;

public class ConvertAnrFunctionCellRelHoAttRateThresholdAction
extends AbstractStep1ConversionAction {
    private static final Class THIS_CLASS = ConvertAnrFunctionCellRelHoAttRateThresholdAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ATTRIBUTE_CELL_REL_HO_ATT_RATE_THRESHOLD = "cellRelHoAttRateThreshold";
    private static final String ATTRIBUTE_NR_HO_NEEDED_TO_ADD_CELL_RELATION = "nrHoNeededToAddCellRelation";
    private static final String ATTRIBUTE_REMOVE_NREL_TIME = "removeNrelTime";

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getValueFromModificationFile("Mo");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = this.getTableData(tableHandler, string);
        try {
            if (tableData.isNotEmpty()) {
                Object[] objectArray = this.getAttributeColumn(tableData, string, ATTRIBUTE_NR_HO_NEEDED_TO_ADD_CELL_RELATION);
                Object[] objectArray2 = this.getAttributeColumn(tableData, string, ATTRIBUTE_REMOVE_NREL_TIME);
                for (int i = 0; i < objectArray.length; ++i) {
                    int n = (int)Math.ceil(((Integer)objectArray[i]).doubleValue() / (((Integer)objectArray2[i]).doubleValue() + 1.0));
                    tableData.setAttributeValue(i, ATTRIBUTE_CELL_REL_HO_ATT_RATE_THRESHOLD, (Object)new Integer(n));
                }
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not set attribute " + string + "::" + ATTRIBUTE_CELL_REL_HO_ATT_RATE_THRESHOLD + ".", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "convert");
    }
}

