/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it23;

import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;
import se.ericsson.lte.rbs.omf.aue.step1.OtherFragmentUtility;
import se.ericsson.lte.rbs.omf.aue.step1.OtherFragmentUtilityWrapper;

public class CorrectFroTypeAndFroIdInRefAttributeAction
extends AbstractStep1ConversionAction {
    private static final Class THIS_CLASS = CorrectFroTypeAndFroIdInRefAttributeAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String LDN = "ldn";
    private static final String PARENT_REF = "parentRef";
    private static final String FRO_TYPE = "froType";
    private static final String FRO_ID = "froId";

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getAndCheckParamMapString("Mo", this.paramMap, "The attribute Mo type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String string2 = this.getAndCheckParamMapString("attribute", this.paramMap, "The attribute attribute is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String string3 = this.getAndCheckParamMapString("referredMoFragment", this.paramMap, "The attribute referredMoFragment is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String string4 = this.getAndCheckParamMapString("referredMoType", this.paramMap, "The attribute referredMoType is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = this.getTableData(tableHandler, string);
        if (tableData.isNotEmpty()) {
            Object[] objectArray = this.getAttributeColumn(tableData, string, LDN);
            Object[] objectArray2 = this.getAttributeColumn(tableData, string, string2);
            Map map = OtherFragmentUtilityWrapper.getOtherFragmentUtilityInstance().getFroLdnToFroTypeAndFroIdMapping(string3, string4);
            for (int i = 0; i < objectArray.length; ++i) {
                String string5;
                String string6 = (String)objectArray[i];
                String string7 = LdnUtil.getParentLdn((String)string6);
                if (this.isCorrectMoRef(string7, string5 = (String)objectArray2[i], map)) continue;
                this.correctRefAttribute(map, string7, tableData, string, i);
            }
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private boolean isCorrectMoRef(String string, String string2, Map map) throws CrbsAueException {
        boolean bl = false;
        if (!map.isEmpty()) {
            OtherFragmentUtility.FroInstanceInfo froInstanceInfo = (OtherFragmentUtility.FroInstanceInfo)map.get(string);
            String string3 = froInstanceInfo.getFroType();
            String string4 = froInstanceInfo.getFroId();
            String string5 = this.getValueByAttrName(FRO_TYPE, string2);
            String string6 = this.getValueByAttrName(FRO_ID, string2);
            if (string3.equalsIgnoreCase(string5) && string4.equalsIgnoreCase(string6)) {
                bl = true;
            }
        }
        return bl;
    }

    private void correctRefAttribute(Map map, String string, TableData tableData, String string2, int n) throws CrbsAueException {
        if (!map.isEmpty()) {
            OtherFragmentUtility.FroInstanceInfo froInstanceInfo = (OtherFragmentUtility.FroInstanceInfo)map.get(string);
            String string3 = froInstanceInfo.getFroType();
            String string4 = froInstanceInfo.getFroId();
            String string5 = this.getCorrectMoRef(string, string3, string4);
            this.setAttributeValue(tableData, string2, n, PARENT_REF, string5);
        }
    }

    private String getCorrectMoRef(String string, String string2, String string3) {
        return "<moref name=\"parentRef\"><attr name=\"ldn\" type=\"STRING\" value=\"" + string + "\"/>" + this.getFroTypeString(string2) + this.getFroIdString(string3) + "</moref>";
    }

    private String getFroTypeString(String string) {
        return "<attr name=\"froType\" type=\"S32\" value=\"" + string + "\"/>";
    }

    private String getFroIdString(String string) {
        return "<attr name=\"froId\" type=\"S32\" value=\"" + string + "\"/>";
    }

    private String getValueByAttrName(String string, String string2) throws CrbsAueException {
        String string3 = "<attr name=\"" + string + "\" type=\"S32\" value=\"";
        int n = string2.indexOf(string3);
        if (n < 0) {
            throw new CrbsAueException("Could not get value for " + string);
        }
        int n2 = string2.indexOf("\"/>", n += string3.length());
        if (n2 < 0) {
            throw new CrbsAueException("Could not get value for " + string);
        }
        return string2.substring(n, n2);
    }
}

