/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it23;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;

public class UpdateMaxNoOfPagingRecordsAction
extends AbstractStep1ConversionAction {
    private static final String MOTYPE_EUTRANCELLTDD = "EUtranCellTDD";
    private static final String ATTRIBUTE_CHANNEL_BANDWIDTH = "channelBandwidth";
    private static final String MOTYPE_EUTRANCELLFDD = "EUtranCellFDD";
    private static final String ATTRIBUTE_DL_CHANNEL_BANDWIDTH = "dlChannelBandwidth";
    private static final String ATTRIBUTE_MAX_NO_OF_PAGING_RECORDS = "maxNoOfPagingRecords";
    private static final Map refMaxNoOfPagingRecordsMap = new HashMap();
    private static final Class THIS_CLASS = UpdateMaxNoOfPagingRecordsAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final int ROW_0 = 0;

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String string = this.getValueFromModificationFile("Mo");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = this.getTableData(tableHandler, string);
        TableData tableData2 = this.getTableData(tableHandler, MOTYPE_EUTRANCELLFDD);
        TableData tableData3 = this.getTableData(tableHandler, MOTYPE_EUTRANCELLTDD);
        boolean bl = tableData.isNotEmpty();
        boolean bl2 = tableData2.isNotEmpty();
        boolean bl3 = tableData3.isNotEmpty();
        if (bl && (bl2 || bl3)) {
            Integer n = this.getMinChannelBandwidthFromAllMo(bl2, bl3, tableData2, tableData3);
            Object[] objectArray = this.getAttributeColumn(tableData, string, ATTRIBUTE_MAX_NO_OF_PAGING_RECORDS);
            if (n != null && objectArray != null) {
                this.setUpRefMaxNoOfPagingRecords();
                this.updateMaxNoOfPagingRecordsValue(n, (Integer)objectArray[0], tableData);
            }
        }
        logger.traceReturn(THIS_CLASS, "convert");
    }

    private Integer getMinChannelBandwidthFromAllMo(boolean bl, boolean bl2, TableData tableData, TableData tableData2) throws CrbsAueException {
        Integer n = null;
        if (bl) {
            n = this.getMinChannelBandwidth(n, tableData, MOTYPE_EUTRANCELLFDD, ATTRIBUTE_DL_CHANNEL_BANDWIDTH);
        }
        if (bl2) {
            n = this.getMinChannelBandwidth(n, tableData2, MOTYPE_EUTRANCELLTDD, ATTRIBUTE_CHANNEL_BANDWIDTH);
        }
        return n;
    }

    private void updateMaxNoOfPagingRecordsValue(Integer n, Integer n2, TableData tableData) throws CrbsAueException {
        Integer n3 = n2;
        Integer n4 = this.getMaxNoOfPagingRecordsFromChannelBandwidth(n);
        if (n4 == null) {
            throw new CrbsAueException("Could not get refMaxNoOfPagingRecordsValue based on channelBandwidth(" + n + ")");
        }
        try {
            if (n3.compareTo(n4) > 0) {
                tableData.setAttributeValue(0, ATTRIBUTE_MAX_NO_OF_PAGING_RECORDS, (Object)n4);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Could not set [maxNoOfPagingRecords to " + n4.toString() + " based on minChannelBandwidth(" + n.toString() + ")]", (Throwable)tableDataException);
        }
    }

    private Integer getMinChannelBandwidth(Integer n, TableData tableData, String string, String string2) throws CrbsAueException {
        Integer n2 = n;
        Object[] objectArray = this.getAttributeColumn(tableData, string, string2);
        for (int i = 0; i < objectArray.length; ++i) {
            Integer n3 = (Integer)objectArray[i];
            if (n3 == null || n2 != null && n2.compareTo(n3) <= 0) continue;
            n2 = n3;
        }
        return n2;
    }

    private Integer getMaxNoOfPagingRecordsFromChannelBandwidth(Integer n) {
        return (Integer)refMaxNoOfPagingRecordsMap.get(n);
    }

    private void setUpRefMaxNoOfPagingRecords() {
        refMaxNoOfPagingRecordsMap.put(new Integer(1400), new Integer(1));
        refMaxNoOfPagingRecordsMap.put(new Integer(3000), new Integer(4));
        refMaxNoOfPagingRecordsMap.put(new Integer(5000), new Integer(7));
        refMaxNoOfPagingRecordsMap.put(new Integer(10000), new Integer(16));
        refMaxNoOfPagingRecordsMap.put(new Integer(15000), new Integer(16));
        refMaxNoOfPagingRecordsMap.put(new Integer(20000), new Integer(16));
    }
}

