/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.step1.actions.it24;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.lte.rbs.omf.aue.step1.AbstractStep1ConversionAction;

public class CorrectCorruptComplexStructAttributesAction
extends AbstractStep1ConversionAction {
    private static final String PM_UE_MEAS_CONTROL_MO_TYPE = "PmUeMeasControl";
    private static final String[] PM_UE_MEAS_CONTROL_ATTRIBUTES = new String[]{"ueMeasIntraFreq1", "ueMeasIntraFreq2"};
    private static final String IDLE_MODE_PRIO_AT_RELEASE_MO_TYPE = "IdleModePrioAtRelease";
    private static final String[] IDLE_MODE_PRIO_AT_RELEASE_ATTRIBUTES = new String[]{"highLoadDistributionInfo", "lowLoadDistributionInfo", "lowMediumLoadDistributionInfo", "mediumHighLoadDistributionInfo", "mediumLoadDistributionInfo"};
    private static final Class THIS_CLASS = CorrectCorruptComplexStructAttributesAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException, NoSuchTableException, TableAlreadyExistsException {
        logger.traceEnter(THIS_CLASS, "convert()");
        this.correctAttributesOfMo(PM_UE_MEAS_CONTROL_MO_TYPE, PM_UE_MEAS_CONTROL_ATTRIBUTES, aueContext);
        this.correctAttributesOfMo(IDLE_MODE_PRIO_AT_RELEASE_MO_TYPE, IDLE_MODE_PRIO_AT_RELEASE_ATTRIBUTES, aueContext);
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void correctAttributesOfMo(String string, String[] stringArray, AueContext aueContext) throws CrbsAueException {
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = null;
        try {
            tableData = this.getTableData(tableHandler, string);
        }
        catch (CrbsAueException crbsAueException) {
            logger.traceDebug(THIS_CLASS, "No TableData for " + string + ". Do nothing.");
        }
        if (tableData != null && tableData.isNotEmpty()) {
            for (int i = 0; i < stringArray.length; ++i) {
                Object[] objectArray = this.getAttributeColumn(tableData, string, stringArray[i]);
                this.checkAndCorrectAttributes(string, objectArray, stringArray[i], tableData);
            }
        }
    }

    private void checkAndCorrectAttributes(String string, Object[] objectArray, String string2, TableData tableData) throws CrbsAueException {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                String string3 = (String)objectArray[i];
                if (!this.isCorrupt(string3)) continue;
                String string4 = this.correctAttribute(string, string2, string3);
                this.setAttributeValue(tableData, string, i, string2, string4);
            }
        }
    }

    private boolean isCorrupt(String string) {
        boolean bl = false;
        if (string != null && string.indexOf("<complex>") > -1) {
            bl = string.indexOf("<strct name=") == -1;
        }
        return bl;
    }

    private String correctAttribute(String string, String string2, String string3) {
        String string4;
        String string5 = "<complex>\n<strct name=\"" + string2 + "\">\n";
        if (PM_UE_MEAS_CONTROL_MO_TYPE.equals(string)) {
            string5 = string3.indexOf("eutranFrequencyRef") > -1 ? string5 + "<moref name=\"" + "eutranFrequencyRef" + "\"/>\n" + "<moref name=\"" + "reportConfigEUtraIntraFreqPmRef" + "\"/>\n" : string5 + "<moref name=\"" + "reportConfigEUtraIntraFreqPmRef" + "\"/>\n" + "<moref name=\"" + "eutranFrequencyRef" + "\"/>\n";
            string4 = string5 + string3.substring(string3.indexOf("</strct>"), string3.length());
        } else {
            string4 = string5 + string3.substring(string3.indexOf("<seq"), string3.length());
        }
        return string4;
    }
}

